/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.reservoir;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class ReservoirTPsim
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    private SystemInterface reservoirFluid = null;
    private StreamInterface outStream = null;
    private double pressure = 100.0;
    private double temperature = 100.0;
    private double flowRate = 100.0;
    private String flowUnit = "kg/hr";
    private String tUnit = "K";
    private String pUnit = "bar";
    private String prodPhaseName = "gas";

    public SystemInterface getReserervourFluid() {
        return this.reservoirFluid;
    }

    public ReservoirTPsim(String name, SystemInterface reservoirFluid) {
        super(name);
        this.reservoirFluid = reservoirFluid;
        this.outStream = new Stream(this.getName() + "_out", reservoirFluid.clone());
    }

    @Override
    public void run(UUID id) {
        SystemInterface fluid1 = this.reservoirFluid.clone();
        fluid1.setTemperature(this.temperature, this.tUnit);
        fluid1.setPressure(this.pressure, this.pUnit);
        fluid1.setTotalFlowRate(this.flowRate, this.flowUnit);
        ThermodynamicOperations operations = new ThermodynamicOperations(fluid1);
        operations.TPflash();
        if (this.prodPhaseName.equals("gas") && fluid1.hasPhaseType("gas")) {
            this.outStream.setFluid(fluid1.phaseToSystem("gas"));
        } else if (this.prodPhaseName.equals("oil") && fluid1.hasPhaseType("oil")) {
            this.outStream.setFluid(fluid1.phaseToSystem("oil"));
        } else {
            this.outStream.setFluid(fluid1.phaseToSystem(1));
        }
    }

    public StreamInterface getOutStream() {
        return this.outStream;
    }

    public void setPressure(double reservoirPressure, String pUnit) {
        this.pressure = reservoirPressure;
        this.pUnit = pUnit;
    }

    public void setTemperature(double reservoirTemperature, String tUnit) {
        this.temperature = reservoirTemperature;
        this.tUnit = tUnit;
    }

    public String getProdPhaseName() {
        return this.prodPhaseName;
    }

    public void setProdPhaseName(String prodPhaseName) {
        this.prodPhaseName = prodPhaseName;
    }

    public void setFlowRate(double flowRate, String flowUnit) {
        this.flowRate = flowRate;
        this.flowUnit = flowUnit;
    }
}

