/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.UUID;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.separator.ThreePhaseSeparator;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowSetter
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    private static final Logger logger = LogManager.getLogger(FlowSetter.class);
    double[] pressure = new double[]{1.01325};
    double[] temperature = new double[]{15.0};
    String unitT = "C";
    String unitP = "bara";
    private double gasFlowRate;
    private double oilFlowRate;
    private double waterFlowRate;
    String unitGasFlowRate = "Sm3/day";
    String unitOilFlowRate = "m3/hr";
    String unitWaterFlowRate = "m3/hr";
    ProcessSystem referenceProcess = null;

    public FlowSetter(String name, StreamInterface stream) {
        super(name, stream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        try {
            this.outStream = inletStream.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setGasFlowRate(double flowRate, String flowUnit) {
        double conversionFactor = 1.0;
        switch (flowUnit) {
            case "Sm3/sec": {
                conversionFactor = 1.0;
                break;
            }
            case "Sm3/hr": {
                conversionFactor = 2.777777777777778E-4;
                break;
            }
            case "Sm3/day": {
                conversionFactor = 1.1574074074074073E-5;
                break;
            }
            case "MSm3/day": {
                conversionFactor = 11.574074074074073;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + flowUnit);
            }
        }
        this.gasFlowRate = flowRate * conversionFactor;
    }

    public double getGasFlowRate(String flowUnit) {
        double conversionFactor = 1.0;
        switch (flowUnit) {
            case "Sm3/sec": {
                conversionFactor = 1.0;
                break;
            }
            case "Sm3/hr": {
                conversionFactor = 3600.0;
                break;
            }
            case "Sm3/day": {
                conversionFactor = 86400.0;
                break;
            }
            case "MSm3/day": {
                conversionFactor = 0.0864;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + flowUnit);
            }
        }
        return this.gasFlowRate * conversionFactor;
    }

    public void setOilFlowRate(double flowRate, String flowUnit) {
        double conversionFactor = 1.0;
        switch (flowUnit) {
            case "m3/sec": {
                conversionFactor = 1.0;
                break;
            }
            case "m3/hr": {
                conversionFactor = 2.777777777777778E-4;
                break;
            }
            case "m3/day": {
                conversionFactor = 1.1574074074074073E-5;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + flowUnit);
            }
        }
        this.oilFlowRate = flowRate * conversionFactor;
    }

    public double getOilFlowRate(String flowUnit) {
        double conversionFactor = 1.0;
        switch (flowUnit) {
            case "m3/sec": {
                conversionFactor = 1.0;
                break;
            }
            case "m3/hr": {
                conversionFactor = 3600.0;
                break;
            }
            case "m3/day": {
                conversionFactor = 86400.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + flowUnit);
            }
        }
        return this.oilFlowRate * conversionFactor;
    }

    public void setWaterFlowRate(double flowRate, String flowUnit) {
        double conversionFactor = 1.0;
        switch (flowUnit) {
            case "m3/sec": {
                conversionFactor = 1.0;
                break;
            }
            case "m3/hr": {
                conversionFactor = 2.777777777777778E-4;
                break;
            }
            case "m3/day": {
                conversionFactor = 1.1574074074074073E-5;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + flowUnit);
            }
        }
        this.waterFlowRate = flowRate * conversionFactor;
    }

    public double getWaterFlowRate(String flowUnit) {
        double conversionFactor = 1.0;
        switch (flowUnit) {
            case "m3/sec": {
                conversionFactor = 1.0;
                break;
            }
            case "m3/hr": {
                conversionFactor = 3600.0;
                break;
            }
            case "m3/day": {
                conversionFactor = 86400.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + flowUnit);
            }
        }
        return this.waterFlowRate * conversionFactor;
    }

    @Override
    public void run(UUID id) {
        SystemInterface tempFluid = this.inStream.getThermoSystem().clone();
        if (this.referenceProcess == null) {
            this.referenceProcess = this.createReferenceProcess(this.inStream);
        }
        if (tempFluid.getFlowRate("kg/sec") < 1.0E-6) {
            this.outStream.setThermoSystem(tempFluid);
            return;
        }
        double error = 0.0;
        do {
            int i;
            error = 0.0;
            ((StreamInterface)this.referenceProcess.getUnit("feed stream")).setFluid(tempFluid);
            this.referenceProcess.run();
            this.referenceProcess.getUnit("gas").getFluid().initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            this.referenceProcess.getUnit("oil").getFluid().initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            double[] moleChange = new double[tempFluid.getNumberOfComponents()];
            for (i = 0; i < tempFluid.getNumberOfComponents(); ++i) {
                moleChange[i] = this.referenceProcess.getUnit("gas").getFluid().getComponent(i).getNumberOfMolesInPhase() * (this.getGasFlowRate("Sm3/hr") / ((StreamInterface)this.referenceProcess.getUnit("gas")).getFlowRate("Sm3/hr")) - this.referenceProcess.getUnit("gas").getFluid().getComponent(i).getNumberOfMolesInPhase() + this.referenceProcess.getUnit("oil").getFluid().getComponent(i).getNumberOfMolesInPhase() * (this.getOilFlowRate("m3/hr") / ((StreamInterface)this.referenceProcess.getUnit("oil")).getFlowRate("m3/hr")) - this.referenceProcess.getUnit("oil").getFluid().getComponent(i).getNumberOfMolesInPhase();
                error += Math.abs(moleChange[i]);
            }
            tempFluid.init(0);
            for (i = 0; i < tempFluid.getNumberOfComponents(); ++i) {
                tempFluid.addComponent(i, moleChange[i]);
            }
        } while (error > this.referenceProcess.getUnit("feed stream").getFluid().getTotalNumberOfMoles() / 1000000.0);
        if (this.waterFlowRate > 0.0) {
            tempFluid.addComponent("water", this.getWaterFlowRate("m3/hr") * 1000.0, "kg/hr");
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.outStream.setThermoSystem(tempFluid);
        this.outStream.run();
        this.outStream.getFluid().initPhysicalProperties();
        this.outStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    public ProcessSystem createReferenceProcess(StreamInterface feedStream) {
        ProcessSystem referenceProcess = new ProcessSystem();
        Stream feedStream1 = new Stream("feed stream", feedStream.getFluid());
        feedStream1.setTemperature(this.temperature[0], this.unitT);
        feedStream1.setPressure(this.pressure[0], this.unitP);
        referenceProcess.add(feedStream1);
        ThreePhaseSeparator separator1ststage = new ThreePhaseSeparator("1st stage separator", feedStream1);
        referenceProcess.add(separator1ststage);
        Mixer gasMixer = new Mixer("gas mixer");
        gasMixer.addStream(separator1ststage.getGasOutStream());
        Stream gasExport = new Stream("gas", gasMixer.getOutletStream());
        Stream oilExport = null;
        if (this.temperature.length == 0 || this.temperature == null) {
            throw new RuntimeException(new InvalidInputException(this, "getReferenceProcess", "temperature", "can not be null"));
        }
        if (this.temperature.length == 1) {
            oilExport = new Stream("oil", separator1ststage.getOilOutStream());
        } else if (this.temperature.length == 2) {
            Heater heater2ndstage = new Heater("2nd stage heater", separator1ststage.getOilOutStream());
            heater2ndstage.setOutPressure(this.pressure[1], this.unitP);
            heater2ndstage.setOutTemperature(this.temperature[1], this.unitT);
            referenceProcess.add(heater2ndstage);
            ThreePhaseSeparator separator2ndstage = new ThreePhaseSeparator("2nd stage separator", heater2ndstage.getOutletStream());
            referenceProcess.add(separator2ndstage);
            gasMixer.addStream(separator2ndstage.getGasOutStream());
            oilExport = new Stream("oil", separator2ndstage.getOilOutStream());
        } else if (this.temperature.length == 3) {
            Heater heater2ndstage = new Heater("2nd stage heater", separator1ststage.getOilOutStream());
            heater2ndstage.setOutPressure(this.pressure[1], this.unitP);
            heater2ndstage.setOutTemperature(this.temperature[1], this.unitT);
            referenceProcess.add(heater2ndstage);
            ThreePhaseSeparator separator2ndstage = new ThreePhaseSeparator("2nd stage separator", heater2ndstage.getOutletStream());
            referenceProcess.add(separator2ndstage);
            Heater heater3rdstage = new Heater("3rd stage heater", separator2ndstage.getOilOutStream());
            heater3rdstage.setOutPressure(this.pressure[2], this.unitP);
            heater3rdstage.setOutTemperature(this.temperature[2], this.unitT);
            referenceProcess.add(heater3rdstage);
            ThreePhaseSeparator separator3rdstage = new ThreePhaseSeparator("3rd stage separator", heater3rdstage.getOutletStream());
            referenceProcess.add(separator3rdstage);
            gasMixer.addStream(separator2ndstage.getGasOutStream());
            gasMixer.addStream(separator3rdstage.getGasOutStream());
            oilExport = new Stream("oil", separator3rdstage.getOilOutStream());
        }
        referenceProcess.add(gasMixer);
        referenceProcess.add(gasExport);
        referenceProcess.add(oilExport);
        return referenceProcess;
    }

    public ProcessSystem getReferenceProcess() {
        return this.referenceProcess;
    }

    public void setSeparationPT(double[] pressure, String unitP, double[] temperature, String unitT) {
        this.pressure = pressure;
        this.unitP = unitP;
        this.temperature = temperature;
        this.unitT = unitT;
    }
}

