/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.separator;

import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.process.costestimation.separator.SeparatorCostEstimate;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.separator.SeparatorInterface;
import neqsim.process.equipment.separator.sectiontype.SeparatorSection;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.MaterialPlateDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.PressureVesselDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.SeparatorDesignStandard;

public class SeparatorMechanicalDesign
extends MechanicalDesign {
    private static final long serialVersionUID = 1000L;
    double gasLoadFactor = 1.0;
    double volumeSafetyFactor = 1.0;
    double Fg = 1.0;
    double retentionTime = 60.0;

    public SeparatorMechanicalDesign(ProcessEquipmentInterface equipment) {
        super(equipment);
        this.costEstimate = new SeparatorCostEstimate(this);
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (this.getDesignStandard().containsKey("material plate design codes")) {
            ((MaterialPlateDesignStandard)this.getDesignStandard().get("material plate design codes")).readMaterialDesignStandard("Carbon Steel Plates and Sheets", "SA-516", "55", 1);
        } else {
            System.out.println("material plate design codes specified......");
        }
        if (this.getDesignStandard().containsKey("pressure vessel design code")) {
            System.out.println("pressure vessel code standard: " + this.getDesignStandard().get("pressure vessel design code").getStandardName());
            this.wallThickness = ((PressureVesselDesignStandard)this.getDesignStandard().get("pressure vessel design code")).calcWallThickness();
        } else {
            System.out.println("no pressure vessel code standard specified......");
        }
        if (this.getDesignStandard().containsKey("separator process design")) {
            System.out.println("separator process design: " + this.getDesignStandard().get("separator process design").getStandardName());
            this.gasLoadFactor = ((SeparatorDesignStandard)this.getDesignStandard().get("separator process design")).getGasLoadFactor();
            this.Fg = ((SeparatorDesignStandard)this.getDesignStandard().get("separator process design")).getFg();
            this.volumeSafetyFactor = ((SeparatorDesignStandard)this.getDesignStandard().get("separator process design")).getVolumetricDesignFactor();
            this.retentionTime = 120.0;
        } else {
            System.out.println("no separator process design specified......");
        }
    }

    @Override
    public void displayResults() {
        JFrame dialog = new JFrame("Unit design " + this.getProcessEquipment().getName());
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"Name", "Value", "Unit"};
        Object[][] table = new String[16][3];
        table[1][0] = "Separator Inner Diameter";
        table[1][1] = Double.toString(this.getInnerDiameter());
        table[1][2] = "m";
        table[2][0] = "Separator TanTan Length";
        table[2][1] = Double.toString(this.getTantanLength());
        table[2][2] = "m";
        table[3][0] = "Wall thickness";
        table[3][1] = Double.toString(this.getWallThickness());
        table[3][2] = "m";
        table[4][0] = "Empty Vessel Weight Weight";
        table[4][1] = Double.toString(this.getWeigthVesselShell());
        table[4][2] = "kg";
        table[5][0] = "Internals+Nozzle Weight";
        table[5][1] = Double.toString(this.getWeigthInternals());
        table[5][2] = "kg";
        table[8][0] = "Module Length";
        table[8][1] = Double.toString(this.getModuleLength());
        table[8][2] = "m";
        table[9][0] = "Module Height";
        table[9][1] = Double.toString(this.getModuleHeight());
        table[9][2] = "m";
        table[10][0] = "Module Width";
        table[10][1] = Double.toString(this.getModuleWidth());
        table[10][2] = "m";
        table[11][0] = "Module Total Weight";
        table[11][1] = Double.toString(this.getWeightTotal());
        table[11][2] = "kg";
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(800, 600);
        dialog.setVisible(true);
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        Separator separator = (Separator)this.getProcessEquipment();
        separator.getThermoSystem().initPhysicalProperties();
        separator.setDesignLiquidLevelFraction(this.Fg);
        double emptyVesselWeight = 0.0;
        double internalsWeight = 0.0;
        double externalNozzelsWeight = 0.0;
        double pipingWeight = 0.0;
        double structualWeight = 0.0;
        double electricalWeight = 0.0;
        double totalSkidWeight = 0.0;
        double materialsCost = 0.0;
        double gasDensity = ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getPhase(0).getPhysicalProperties().getDensity();
        double liqDensity = ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getPhase(1).getPhysicalProperties().getDensity();
        double liqViscosity = ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getPhase(1).getPhysicalProperties().getViscosity();
        if (((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getNumberOfPhases() == 1) {
            liqDensity = this.getDefaultLiquidDensity();
            liqViscosity = this.getDefaultLiquidViscosity();
        }
        this.maxDesignVolumeFlow = this.volumeSafetyFactor * ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getPhase(0).getVolume() / 100000.0;
        double maxGasVelocity = this.gasLoadFactor * Math.sqrt((liqDensity - gasDensity) / gasDensity);
        this.innerDiameter = Math.sqrt(4.0 * this.getMaxDesignVolumeFlow() / (3.14159265 * maxGasVelocity * this.Fg));
        this.outerDiameter = this.innerDiameter + 2.0 * this.wallThickness;
        this.retentionTime = ((SeparatorDesignStandard)this.getDesignStandard().get("separator process design")).getLiquidRetentionTime("API12J", this);
        this.tantanLength = Math.sqrt(4.0 * this.retentionTime * ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getLiquidVolume() / 100000.0 / (Math.PI * this.innerDiameter * this.innerDiameter * (1.0 - this.Fg)));
        double sepratorLength = this.tantanLength + this.innerDiameter;
        if (sepratorLength / this.innerDiameter > 6.0 || sepratorLength / this.innerDiameter < 3.0) {
            this.tantanLength = this.innerDiameter * 5.0;
            sepratorLength = this.tantanLength + this.innerDiameter;
        }
        double bubbleDiameter = 2.5E-4;
        double bubVelocity = 9.82 * Math.pow(bubbleDiameter, 2.0) * (liqDensity - gasDensity) / 18.0 / liqViscosity;
        double Ar = ((SeparatorInterface)((Object)this.getProcessEquipment())).getThermoSystem().getLiquidVolume() / 100000.0 / bubVelocity;
        double Daim = Math.sqrt(Ar / 4.0);
        double Length2 = 4.0 * Daim;
        if (Daim > this.innerDiameter) {
            this.innerDiameter = Daim;
            this.tantanLength = Length2;
        }
        emptyVesselWeight = 0.032 * this.getWallThickness() * 1000.0 * this.innerDiameter * 1000.0 * this.tantanLength;
        this.setOuterDiameter(this.innerDiameter + 2.0 * this.getWallThickness());
        for (SeparatorSection sep : separator.getSeparatorSections()) {
            sep.setOuterDiameter(this.getOuterDiameter());
            sep.getMechanicalDesign().calcDesign();
            internalsWeight += sep.getMechanicalDesign().getTotalWeight();
        }
        externalNozzelsWeight = 0.0;
        double Wv = emptyVesselWeight + internalsWeight + externalNozzelsWeight;
        pipingWeight = Wv * 0.4;
        structualWeight = Wv * 0.1;
        electricalWeight = Wv * 0.08;
        totalSkidWeight = Wv + pipingWeight + structualWeight + electricalWeight;
        materialsCost = totalSkidWeight / 1000.0 * 6000.0 / 1000.0;
        this.moduleWidth = this.innerDiameter * 2.0;
        this.moduleLength = this.tantanLength * 1.5;
        this.moduleHeight = this.innerDiameter * 2.0 + 1.0;
        this.setWeigthVesselShell(emptyVesselWeight);
        this.setInnerDiameter(this.innerDiameter);
        this.setOuterDiameter(this.outerDiameter);
        this.setWeightElectroInstrument(electricalWeight);
        this.setWeightNozzle(externalNozzelsWeight);
        this.setWeightPiping(pipingWeight);
        this.setWeightStructualSteel(structualWeight);
        this.setWeightTotal(totalSkidWeight);
        this.setWeigthInternals(internalsWeight);
        this.setWallThickness(this.wallThickness);
        this.setModuleHeight(this.moduleHeight);
        this.setModuleWidth(this.moduleWidth);
        this.setModuleLength(this.moduleLength);
    }

    @Override
    public void setDesign() {
        ((SeparatorInterface)((Object)this.getProcessEquipment())).setInternalDiameter(this.innerDiameter);
        ((Separator)this.getProcessEquipment()).setSeparatorLength(this.tantanLength);
    }
}

