/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.valve;

import java.util.HashMap;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.mechanicaldesign.valve.ControlValveSizing;
import neqsim.process.mechanicaldesign.valve.ValveMechanicalDesign;
import neqsim.thermo.system.SystemInterface;

public class ControlValveSizing_simple
extends ControlValveSizing {
    public ControlValveSizing_simple() {
    }

    public ControlValveSizing_simple(ValveMechanicalDesign valveMechanicalDesign) {
        super(valveMechanicalDesign);
    }

    @Override
    public double calcKv(double percentOpening) {
        SystemInterface fluid = ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFluid();
        HashMap result = this.valveMechanicalDesign.fullOutput ? new HashMap() : null;
        double density = fluid.getDensity("kg/m3");
        double Y = 1.0;
        if (!((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).isGasValve()) {
            density = fluid.getDensity("kg/m3") / 1000.0;
        } else {
            double Fgamma = ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFluid().getPhase(0).getGamma2() / 1.4;
            double x = (((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure() - ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getOutletStream().getPressure()) / ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure();
            double xuse = Math.min(x, this.xT);
            Y = 1.0 - xuse / (3.0 * Fgamma * this.xT);
        }
        return ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFlowRate("m3/hr") / Math.sqrt((((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure("bara") - ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getOutletStream().getPressure("bara")) / density) / Y / this.valveMechanicalDesign.getValveCharacterizationMethod().getOpeningFactor(percentOpening);
    }

    public double calculateFlowRateFromValveOpening(double Kv, double valveOpening, StreamInterface inletStream, StreamInterface outletStream) {
        return this.calculateMolarFlow(Kv * valveOpening / 100.0, inletStream, outletStream);
    }

    @Override
    public double calculateMolarFlow(double KvAdjusted, StreamInterface inStream, StreamInterface outStream) {
        double density = inStream.getFluid().getDensity("kg/m3");
        double Y = 1.0;
        if (!((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).isGasValve()) {
            density = inStream.getFluid().getDensity("kg/m3") / 1000.0;
        } else {
            double Fgamma = ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFluid().getPhase(0).getGamma2() / 1.4;
            double x = (((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure() - ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getOutletStream().getPressure()) / ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure();
            double xuse = Math.min(x, this.xT);
            Y = 1.0 - xuse / (3.0 * Fgamma * this.xT);
        }
        double flow_m3_s = KvAdjusted / 3600.0 * Y * Math.sqrt((inStream.getPressure("bara") - outStream.getPressure("bara")) / density);
        return flow_m3_s;
    }

    public double calculateValveOpeningFromFlowRate(double Q, double Kv, double valveOpening, StreamInterface inletStream, StreamInterface outletStream) {
        return 100.0;
    }

    public double findOutletPressureForFixedKv(double Kv, double valveOpening, StreamInterface inletStream) {
        return this.calculateOutletPressure(Kv * valveOpening / 100.0, inletStream);
    }

    @Override
    public double calculateOutletPressure(double KvAdjusted, StreamInterface inStream) {
        double density = inStream.getFluid().getDensity("kg/m3");
        double molarMass = inStream.getFluid().getMolarMass("kg/mol");
        double molarFlow = inStream.getFlowRate("mole/sec");
        double Q_m3_s = molarFlow * molarMass / density;
        double Y = 1.0;
        if (!((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).isGasValve()) {
            density = inStream.getFluid().getDensity("kg/m3") / 1000.0;
        } else {
            double Fgamma = ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFluid().getPhase(0).getGamma2() / 1.4;
            double x = (((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure() - ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getOutletStream().getPressure()) / ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure();
            double xuse = Math.min(x, this.xT);
            Y = 1.0 - xuse / (3.0 * Fgamma * this.xT);
        }
        double dP_bar = Math.pow(Q_m3_s * 3600.0 / (KvAdjusted * Y), 2.0) * density;
        return (inStream.getPressure("bara") - dP_bar) * 100000.0;
    }
}

