/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel.processmodules;

import java.util.UUID;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.separator.ThreePhaseSeparator;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.processmodel.ProcessModuleBaseClass;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class WellFluidModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface feedStream = null;
    protected StreamInterface outStream = null;
    Cooler oilCooler;
    double secondstagePressure = 15.0;
    double inletPressure = 55.0;
    double gasfactor = 0.1;
    double thirdstagePressure = 1.01325;
    double separationTemperature = 288.15;
    double exitGasScrubberTemperature = 303.15;
    double firstStageCompressorAfterCoolerTemperature = 303.15;
    double exportOilTemperature = 303.15;

    public WellFluidModule(String name) {
        super(name);
    }

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("feed stream")) {
            this.feedStream = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        return this.outStream;
    }

    @Override
    public void run(UUID id) {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.getOperations().run(id);
        double volGas = ((Mixer)this.getOperations().getUnit("gas mixer")).getOutletStream().getThermoSystem().getVolume();
        double volOil = ((ThreePhaseSeparator)this.getOperations().getUnit("3rd stage Separator")).getOilOutStream().getThermoSystem().getVolume();
        double GOR2 = volGas / volOil;
        System.out.println("GOR " + GOR2);
        this.outStream = ((Mixer)this.getOperations().getUnit("well mixer")).getOutletStream();
        Stream gasStream = (Stream)((Heater)this.getOperations().getUnit("gas heater")).getOutletStream().clone();
        gasStream.getThermoSystem().setPressure(this.inletPressure);
        Stream oilStream = (Stream)((ThreePhaseSeparator)this.getOperations().getUnit("3rd stage Separator")).getOilOutStream().clone();
        oilStream.getThermoSystem().setPressure(this.inletPressure);
        ((Separator)this.getOperations().getUnit("Inlet separator")).addStream(gasStream);
        ((Separator)this.getOperations().getUnit("Inlet separator")).addStream(oilStream);
        this.getOperations().run(id);
        volGas = ((Mixer)this.getOperations().getUnit("gas mixer")).getOutletStream().getThermoSystem().getVolume();
        volOil = ((ThreePhaseSeparator)this.getOperations().getUnit("3rd stage Separator")).getOilOutStream().getThermoSystem().getVolume();
        GOR2 = volGas / volOil;
        System.out.println("GOR " + GOR2);
        this.outStream = ((Mixer)this.getOperations().getUnit("well mixer")).getOutletStream();
        this.outStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        this.inletPressure = this.feedStream.getPressure();
        Separator inletSeparator = new Separator("Inlet separator", this.feedStream);
        Heater liquidOutHeater = new Heater("oil/water heater", inletSeparator.getLiquidOutStream());
        liquidOutHeater.setOutTemperature(this.separationTemperature);
        ThreePhaseSeparator firstStageSeparator = new ThreePhaseSeparator("1st stage separator", liquidOutHeater.getOutletStream());
        ThrottlingValve valve1 = new ThrottlingValve("1stTo2ndStageOilValve", firstStageSeparator.getOilOutStream());
        valve1.setOutletPressure(this.secondstagePressure);
        Heater liquidOutHeater2 = new Heater("oil/water heater2", valve1.getOutletStream());
        liquidOutHeater2.setOutTemperature(this.separationTemperature);
        ThreePhaseSeparator secondStageSeparator = new ThreePhaseSeparator("2nd stage Separator", liquidOutHeater2.getOutletStream());
        ThrottlingValve thirdStageValve = new ThrottlingValve("2-3stageOilValve", secondStageSeparator.getLiquidOutStream());
        thirdStageValve.setOutletPressure(this.thirdstagePressure);
        Heater liquidOutHeater3 = new Heater("oil/water heater3", thirdStageValve.getOutletStream());
        liquidOutHeater3.setOutTemperature(this.separationTemperature);
        ThreePhaseSeparator thirdStageSeparator = new ThreePhaseSeparator("3rd stage Separator", liquidOutHeater3.getOutletStream());
        Mixer gasMixer = new Mixer("gas mixer");
        gasMixer.addStream(inletSeparator.getGasOutStream());
        gasMixer.addStream(firstStageSeparator.getGasOutStream());
        gasMixer.addStream(secondStageSeparator.getGasOutStream());
        gasMixer.addStream(thirdStageSeparator.getGasOutStream());
        Heater gasHeater = new Heater("gas heater", gasMixer.getOutletStream());
        gasHeater.setOutTemperature(this.separationTemperature);
        Mixer wellStreamMixer = new Mixer("well mixer");
        wellStreamMixer.addStream(thirdStageSeparator.getOilOutStream());
        wellStreamMixer.addStream(gasHeater.getOutletStream());
        this.getOperations().add(inletSeparator);
        this.getOperations().add(liquidOutHeater);
        this.getOperations().add(firstStageSeparator);
        this.getOperations().add(valve1);
        this.getOperations().add(liquidOutHeater2);
        this.getOperations().add(secondStageSeparator);
        this.getOperations().add(thirdStageValve);
        this.getOperations().add(liquidOutHeater3);
        this.getOperations().add(thirdStageSeparator);
        this.getOperations().add(gasMixer);
        this.getOperations().add(gasHeater);
        this.getOperations().add(wellStreamMixer);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }

    @Override
    public void setSpecification(String specificationName, double value) {
        if (specificationName.equals("Second stage pressure")) {
            this.secondstagePressure = value;
        }
        if (specificationName.equals("separation temperature")) {
            this.separationTemperature = value;
        }
        if (specificationName.equals("Third stage pressure")) {
            this.thirdstagePressure = value;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(323.15, 65.0);
        testSystem.addComponent("methane", 195.0);
        testSystem.addComponent("nC10", 6.0);
        testSystem.addComponent("water", 12.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.setMultiPhaseCheck(true);
        testSystem.init(0);
        testSystem.init(3);
        double a = testSystem.getTotalNumberOfMoles();
        Stream wellStream = new Stream("Well stream", testSystem);
        WellFluidModule separationModule = new WellFluidModule("separationModule");
        separationModule.addInputStream("feed stream", wellStream);
        separationModule.setSpecification("Second stage pressure", 15.0);
        separationModule.setSpecification("separation temperature", 288.15);
        separationModule.setSpecification("Third stage pressure", 1.01325);
        ProcessSystem operations = new ProcessSystem();
        operations.add(wellStream);
        operations.add(separationModule);
        operations.run();
    }
}

