/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import java.util.HashMap;
import neqsim.process.equipment.heatexchanger.MultiStreamHeatExchanger;
import neqsim.process.util.monitor.BaseResponse;
import neqsim.process.util.monitor.Value;
import neqsim.util.unit.Units;

public class MultiStreamHeatExchangerResponse
extends BaseResponse {
    public HashMap<String, Value> data = new HashMap();
    public Double[] feedTemperature;
    public Double[] dischargeTemperature;
    public Double[] duty;
    public Double[] flowRate;

    public MultiStreamHeatExchangerResponse(MultiStreamHeatExchanger inputHX) {
        super(inputHX);
        int numberOfStreams = inputHX.numerOfFeedStreams();
        this.feedTemperature = new Double[numberOfStreams];
        this.dischargeTemperature = new Double[numberOfStreams];
        this.duty = new Double[numberOfStreams];
        this.flowRate = new Double[numberOfStreams];
        for (int i = 0; i < numberOfStreams; ++i) {
            this.feedTemperature[i] = inputHX.getInStream(i).getTemperature("C");
            this.dischargeTemperature[i] = inputHX.getOutStream(i).getTemperature("C");
            this.duty[i] = inputHX.getDuty(i);
            this.flowRate[i] = inputHX.getInStream(i).getFlowRate("kg/hr");
            String streamId = Integer.toString(i + 1);
            this.data.put("feed temperature stream " + streamId, new Value(Double.toString(this.feedTemperature[i]), Units.getSymbol("temperature")));
            this.data.put("discharge temperature stream " + streamId, new Value(Double.toString(this.dischargeTemperature[i]), Units.getSymbol("temperature")));
            this.data.put("duty stream " + streamId, new Value(Double.toString(this.duty[i]), Units.getSymbol("duty")));
            this.data.put("mass flow stream " + streamId, new Value(Double.toString(this.flowRate[i]), Units.getSymbol("mass flow")));
        }
        this.data.put("UA value", new Value(Double.toString(inputHX.getUAvalue()), "W/K"));
    }
}

