/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentGeNRTL;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentKentEisenberg
extends ComponentGeNRTL {
    private static final long serialVersionUID = 1000L;

    public ComponentKentEisenberg(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        double gamma = 1.0;
        if (this.referenceStateType.equals("solvent")) {
            this.fugacityCoefficient = gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure();
            this.gammaRefCor = gamma;
        } else {
            double activinf = 1.0;
            this.fugacityCoefficient = this.ionicCharge == 0 ? activinf * this.getHenryCoef(phase.getTemperature()) / phase.getPressure() : 1.0E8;
            this.gammaRefCor = activinf;
        }
        return this.fugacityCoefficient;
    }
}

