/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEos;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentVegaEos
extends ComponentEos {
    private static final long serialVersionUID = 1000L;

    public ComponentVegaEos(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
    }

    public ComponentVegaEos(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentVegaEos clone() {
        ComponentVegaEos clonedComponent = null;
        try {
            clonedComponent = (ComponentVegaEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedComponent;
    }

    @Override
    public double getVolumeCorrection() {
        return 0.0;
    }

    @Override
    public void Finit(PhaseInterface phase, double T, double p, double totalNumberOfMoles, double beta, int numberOfComponents, int initType) {
        super.Finit(phase, T, p, totalNumberOfMoles, beta, numberOfComponents, initType);
        if (initType == 3) {
            double phi = this.fugcoef(phase);
            phase.getComponent(this.getComponentNumber()).setFugacityCoefficient(phi);
        }
    }

    @Override
    public double calca() {
        return 0.0;
    }

    @Override
    public double calcb() {
        return 0.0;
    }

    @Override
    public double alpha(double temperature) {
        return 1.0;
    }

    @Override
    public double diffaT(double temperature) {
        return 1.0;
    }

    @Override
    public double diffdiffaT(double temperature) {
        return 1.0;
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return phase.getAlphares_Vega()[0][0].val + phase.getAlphares_Vega()[0][1].val;
    }

    @Override
    public double dFdNdN(int i, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return (2.0 * phase.getAlphares_Vega()[0][1].val + phase.getAlphares_Vega()[0][2].val) / phase.getNumberOfMolesInPhase();
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return -(2.0 * phase.getAlphares_Vega()[0][1].val + phase.getAlphares_Vega()[0][2].val) / phase.getVolume();
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return -(phase.getAlphares_Vega()[1][0].val + phase.getAlphares_Vega()[1][1].val) / phase.getTemperature();
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        double pressure = phase.getPressure();
        double logFugacityCoefficient = this.dFdN(phase, phase.getNumberOfComponents(), temperature, pressure) - Math.log(phase.getZ());
        double fugacityCoefficient = Math.exp(logFugacityCoefficient);
        return fugacityCoefficient;
    }
}

