/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermMatCopPRUMR;

public class AtractiveTermMatCopPRUMRNew
extends AttractiveTermMatCopPRUMR {
    private static final long serialVersionUID = 1000L;
    double orgpar = 0.0;
    boolean useStandardAlphaForSupercritical = false;

    public AtractiveTermMatCopPRUMRNew(ComponentEosInterface component) {
        super(component);
        this.m = 0.384401 + 1.52276 * component.getAcentricFactor() - 0.213808 * component.getAcentricFactor() * component.getAcentricFactor() + 0.034616 * Math.pow(component.getAcentricFactor(), 3.0) - 0.001976 * Math.pow(component.getAcentricFactor(), 4.0);
    }

    public AtractiveTermMatCopPRUMRNew(ComponentEosInterface component, double[] params) {
        this(component);
        this.parameters = new double[params.length];
        System.arraycopy(params, 0, this.parameters, 0, params.length);
        this.orgpar = this.parameters[0];
        if (Math.abs(this.parameters[0]) < 1.0E-12) {
            this.parameters[0] = this.m;
        }
        if (component.getName().equals("ethane")) {
            this.parameters[0] = 0.498809;
            this.parameters[1] = 0.115568;
            this.parameters[2] = -0.040775;
            this.parameters[3] = -0.057788;
            this.parameters[4] = 0.017702;
        }
        if (component.getName().equals("water")) {
            this.parameters[0] = 0.913;
            this.parameters[1] = -0.287;
            this.parameters[2] = 0.2395;
            this.parameters[3] = -4.0;
            this.parameters[4] = 7.0;
        }
        if (component.getName().equals("nitrogen")) {
            this.parameters[0] = 0.43635;
            this.parameters[1] = 0.0;
            this.parameters[2] = 0.0;
            this.parameters[3] = 0.0;
            this.parameters[4] = 0.0;
        }
        if (component.getName().equals("methane")) {
            this.parameters[0] = 0.386575;
            this.parameters[1] = 0.016011;
            this.parameters[2] = -0.017371;
            this.parameters[3] = 0.011761;
            this.parameters[4] = 0.020786;
        }
    }

    @Override
    public AtractiveTermMatCopPRUMRNew clone() {
        AtractiveTermMatCopPRUMRNew atractiveTerm = null;
        try {
            atractiveTerm = (AtractiveTermMatCopPRUMRNew)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return atractiveTerm;
    }

    @Override
    public double alpha(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.alpha(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        return Math.pow(1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0) + this.parameters[3] * Math.pow(1.0 - Math.sqrt(Tr), 4.0) + this.parameters[4] * Math.pow(1.0 - Math.sqrt(Tr), 5.0), 2.0);
    }

    @Override
    public double aT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.aT(temperature);
        }
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffalphaT(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        double tcrizatr = TC * Math.sqrt(Tr);
        return 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0) + this.parameters[3] * Math.pow(1.0 - Math.sqrt(Tr), 4.0) + this.parameters[4] * Math.pow(1.0 - Math.sqrt(Tr), 5.0)) * (-0.5 * this.parameters[0] / tcrizatr - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / tcrizatr - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / tcrizatr - 2.0 * this.parameters[3] * Math.pow(1.0 - Math.sqrt(Tr), 3.0) / tcrizatr - 2.5 * this.parameters[4] * Math.pow(1.0 - Math.sqrt(Tr), 4.0) / tcrizatr);
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffdiffalphaT(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        double tcrizatr = TC * Math.sqrt(Tr);
        double TcT = TC * temperature;
        double Tc2Trpower32 = TC * TC * Math.pow(Tr, 1.5);
        return 2.0 * Math.pow(this.parameters[0] / tcrizatr / 2.0 + this.parameters[1] * (1.0 - Math.sqrt(Tr)) / tcrizatr + 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / tcrizatr + 2.0 * this.parameters[3] * Math.pow(1.0 - Math.sqrt(Tr), 3.0) / tcrizatr + 2.5 * this.parameters[4] * Math.pow(1.0 - Math.sqrt(Tr), 4.0) / tcrizatr, 2.0) + 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0) + this.parameters[3] * Math.pow(1.0 - Math.sqrt(Tr), 4.0) + this.parameters[4] * Math.pow(1.0 - Math.sqrt(Tr), 5.0)) * (this.parameters[0] / Tc2Trpower32 / 4.0 + this.parameters[1] / TcT / 2.0 + this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Tc2Trpower32 / 2.0 + 1.5 * this.parameters[2] * (1.0 - Math.sqrt(Tr)) / TcT + 0.75 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Tc2Trpower32 + 3.0 * this.parameters[3] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / TcT + this.parameters[3] * Math.pow(1.0 - Math.sqrt(Tr), 3.0) / Tc2Trpower32 + 5.0 * this.parameters[4] * Math.pow(1.0 - Math.sqrt(Tr), 3.0) / TcT + 1.25 * this.parameters[4] * Math.pow(1.0 - Math.sqrt(Tr), 4.0) / Tc2Trpower32);
    }

    @Override
    public double diffaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffaT(temperature);
        }
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffdiffaT(temperature);
        }
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

