/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentBWRS;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseBWRSEos
extends PhaseSrkEos {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhaseBWRSEos.class);
    int OP = 9;
    int OE = 6;

    @Override
    public PhaseBWRSEos clone() {
        PhaseBWRSEos clonedPhase = null;
        try {
            clonedPhase = (PhaseBWRSEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentBWRS(name, moles, molesInPhase, compNumber);
        ((ComponentBWRS)this.componentArray[compNumber]).setRefPhaseBWRS(this);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        double oldMolDens = 0.0;
        if (initType == 0) {
            super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
            super.init(totalNumberOfMoles, numberOfComponents, 3, pt, beta);
            return;
        }
        do {
            oldMolDens = this.getMolarDensity();
            super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
        } while (Math.abs((this.getMolarDensity() - oldMolDens) / oldMolDens) > 1.0E-10);
        this.getF();
    }

    public double getMolarDensity() {
        return this.getNumberOfMolesInPhase() / this.getTotalVolume() * 100.0;
    }

    public double getdRhodV() {
        return -this.getMolarDensity() / (this.getTotalVolume() * 1.0E-5);
    }

    public double getdRhodVdV() {
        return 2.0 * this.getMolarDensity() / Math.pow(this.getTotalVolume() * 1.0E-5, 2.0);
    }

    public double getdRhodVdVdV() {
        return -6.0 * this.getMolarDensity() / Math.pow(this.getTotalVolume() * 1.0E-5, 3.0);
    }

    public double getGammadRho() {
        return 0.0;
    }

    public double getFpol() {
        double temp = 0.0;
        for (int i = 1; i < this.OP; ++i) {
            temp += ((ComponentBWRS)this.componentArray[0]).getBP(i) / ((double)i + 0.0) * Math.pow(this.getMolarDensity(), i);
        }
        return this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp;
    }

    public double getFpoldV() {
        double temp = 0.0;
        for (int i = 1; i < this.OP; ++i) {
            temp += (double)i * ((ComponentBWRS)this.componentArray[0]).getBP(i) / ((double)i - 0.0) * Math.pow(this.getMolarDensity(), (double)i - 1.0) * this.getdRhodV();
        }
        return this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp;
    }

    public double getFpoldVdV() {
        double temp = 0.0;
        double temp2 = 0.0;
        for (int i = 1; i < this.OP; ++i) {
            temp += (double)((i - 1) * i) * ((ComponentBWRS)this.componentArray[0]).getBP(i) / ((double)i - 0.0) * Math.pow(this.getMolarDensity(), (double)i - 2.0);
            temp2 += (double)i * ((ComponentBWRS)this.componentArray[0]).getBP(i) / ((double)i - 0.0) * Math.pow(this.getMolarDensity(), (double)i - 1.0);
        }
        return this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp * Math.pow(this.getdRhodV(), 2.0) + this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp2 * this.getdRhodVdV();
    }

    public double getFpoldVdVdV() {
        double temp = 0.0;
        double temp2 = 0.0;
        for (int i = 1; i < this.OP; ++i) {
            temp += (double)((i - 2) * (i - 1) * i) * ((ComponentBWRS)this.componentArray[0]).getBP(i) / ((double)i - 0.0) * Math.pow(this.getMolarDensity(), i - 3);
            temp2 += (double)((i - 1) * i) * ((ComponentBWRS)this.componentArray[0]).getBP(i) / ((double)i - 0.0) * Math.pow(this.getMolarDensity(), i - 2);
        }
        return this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp * Math.pow(this.getdRhodV(), 3.0) + 2.0 * this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp2 * Math.pow(this.getdRhodV(), 1.0) * this.getdRhodVdV() + this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp2 * Math.pow(this.getdRhodV(), 1.0) * this.getdRhodVdV() + this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp2 * this.getdRhodVdVdV();
    }

    public double getFpoldT() {
        double temp = 0.0;
        double temp2 = 0.0;
        for (int i = 1; i < this.OP; ++i) {
            temp += ((ComponentBWRS)this.componentArray[0]).getBP(i) / ((double)i + 0.0) * Math.pow(this.getMolarDensity(), i);
            temp2 += ((ComponentBWRS)this.componentArray[0]).getBPdT(i) / ((double)i + 0.0) * Math.pow(this.getMolarDensity(), i);
        }
        return -this.numberOfMolesInPhase / (8.3144621 * this.temperature * this.temperature) * temp + this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp2;
    }

    public double getEL() {
        return Math.exp(-((ComponentBWRS)this.componentArray[0]).getGammaBWRS() * Math.pow(this.getMolarDensity(), 2.0));
    }

    public double getELdRho() {
        return -2.0 * this.getMolarDensity() * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS() * Math.exp(-((ComponentBWRS)this.componentArray[0]).getGammaBWRS() * Math.pow(this.getMolarDensity(), 2.0));
    }

    public double getFexp() {
        double oldTemp = 0.0;
        double temp = 0.0;
        oldTemp = -((ComponentBWRS)this.componentArray[0]).getBE(0) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (this.getEL() - 1.0);
        temp += oldTemp;
        for (int i = 1; i < this.OE; ++i) {
            oldTemp = -((ComponentBWRS)this.componentArray[0]).getBE(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (this.getEL() * Math.pow(this.getMolarDensity(), 2.0 * (double)i) - 2.0 * (double)i / ((ComponentBWRS)this.componentArray[0]).getBE(i - 1) * oldTemp);
            temp += oldTemp;
        }
        return this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp;
    }

    public double getFexpdV() {
        double oldTemp = 0.0;
        double temp = 0.0;
        oldTemp = -((ComponentBWRS)this.componentArray[0]).getBE(0) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * this.getELdRho() * this.getdRhodV();
        temp += oldTemp;
        for (int i = 1; i < this.OE; ++i) {
            oldTemp = -((ComponentBWRS)this.componentArray[0]).getBE(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * Math.pow(this.getMolarDensity(), 2 * i) * this.getELdRho() * this.getdRhodV() - 2.0 * (double)i * ((ComponentBWRS)this.componentArray[0]).getBE(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * this.getEL() * Math.pow(this.getMolarDensity(), 2 * i - 1) * this.getdRhodV() + ((ComponentBWRS)this.componentArray[0]).getBE(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * 2.0 * (double)i / ((ComponentBWRS)this.componentArray[0]).getBE(i - 1) * oldTemp;
            temp += oldTemp;
        }
        return this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp;
    }

    public double getFexpdVdV() {
        return 0.0;
    }

    public double getFexpdT() {
        double oldTemp = 0.0;
        double temp = 0.0;
        double oldTemp2 = 0.0;
        oldTemp = -((ComponentBWRS)this.componentArray[0]).getBEdT(0) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (this.getEL() - 1.0);
        oldTemp2 = -((ComponentBWRS)this.componentArray[0]).getBE(0) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (this.getEL() - 1.0);
        temp += oldTemp;
        for (int i = 1; i < this.OE; ++i) {
            oldTemp = -((ComponentBWRS)this.componentArray[0]).getBEdT(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (this.getEL() * Math.pow(this.getMolarDensity(), 2.0 * (double)i) - 2.0 * (double)i / ((ComponentBWRS)this.componentArray[0]).getBE(i - 1) * oldTemp2) + -((ComponentBWRS)this.componentArray[0]).getBE(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (2.0 * (double)i / Math.pow(((ComponentBWRS)this.componentArray[0]).getBE(i - 1), 2.0) * oldTemp2) * ((ComponentBWRS)this.componentArray[0]).getBEdT(i - 1) + ((ComponentBWRS)this.componentArray[0]).getBE(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (2.0 * (double)i / ((ComponentBWRS)this.componentArray[0]).getBE(i - 1) * oldTemp);
            oldTemp2 = -((ComponentBWRS)this.componentArray[0]).getBE(i) / (2.0 * ((ComponentBWRS)this.componentArray[0]).getGammaBWRS()) * (this.getEL() * Math.pow(this.getMolarDensity(), 2.0 * (double)i) - 2.0 * (double)i / ((ComponentBWRS)this.componentArray[0]).getBE(i - 1) * oldTemp2);
            temp += oldTemp;
        }
        return -this.getFexp() / this.temperature + this.numberOfMolesInPhase / (8.3144621 * this.temperature) * temp;
    }

    public double calcPressure2() {
        int i;
        double temp = 0.0;
        logger.info("molar density " + this.getMolarDensity());
        for (i = 0; i < this.OP; ++i) {
            temp += ((ComponentBWRS)this.componentArray[0]).getBP(i) * Math.pow(this.getMolarDensity(), 1.0 + (double)i);
        }
        for (i = 0; i < this.OE; ++i) {
            temp += this.getEL() * ((ComponentBWRS)this.componentArray[0]).getBE(i) * Math.pow(this.getMolarDensity(), 3.0 + 2.0 * (double)i);
        }
        this.calcPVT();
        return temp / 100.0;
    }

    public void calcPVT() {
        double[] moldens = new double[300];
        double[] pres = new double[300];
        for (int j = 0; j < 300; ++j) {
            int i;
            moldens[j] = 30.0 - (double)j * 0.1;
            double temp = 0.0;
            for (i = 0; i < this.OP; ++i) {
                temp += ((ComponentBWRS)this.componentArray[0]).getBP(i) * Math.pow(moldens[j], 1.0 + (double)i);
            }
            for (i = 0; i < this.OE; ++i) {
                temp += Math.exp(-((ComponentBWRS)this.componentArray[0]).getGammaBWRS() * Math.pow(moldens[j], 2.0)) * ((ComponentBWRS)this.componentArray[0]).getBE(i) * Math.pow(moldens[j], 3.0 + 2.0 * (double)i);
            }
            pres[j] = temp / 100.0;
            logger.info("moldens " + moldens[j] * 16.01 + "  pres " + pres[j]);
        }
    }

    @Override
    public double getF() {
        return (this.getFpol() + this.getFexp()) * 1000.0;
    }

    public double getdFdN() {
        double dn = this.numberOfMolesInPhase / 100.0;
        this.getComponent(0).addMoles(dn);
        this.numberOfMolesInPhase += dn;
        this.init(this.numberOfMolesInPhase, this.numberOfComponents, 3, 1.0);
        double fold = this.getF();
        this.numberOfMolesInPhase -= 2.0 * dn;
        this.getComponent(0).addMoles(-2.0 * dn);
        this.init(this.numberOfMolesInPhase, this.numberOfComponents, 3, 1.0);
        double fnew = this.getF();
        this.numberOfMolesInPhase += dn;
        this.getComponent(0).addMoles(dn);
        this.init(this.numberOfMolesInPhase, this.numberOfComponents, 3, 1.0);
        return (fold - fnew) / (2.0 * dn);
    }

    @Override
    public double dFdT() {
        return (this.getFpoldT() + this.getFexpdT()) * 1000.0;
    }

    @Override
    public double dFdTdT() {
        double dv = this.temperature / 1000.0;
        this.temperature += dv;
        this.init(this.numberOfMolesInPhase, this.numberOfComponents, 3, 1.0);
        double fold = this.dFdT();
        this.temperature -= 2.0 * dv;
        this.init(this.numberOfMolesInPhase, this.numberOfComponents, 3, 1.0);
        double fnew = this.dFdT();
        this.temperature += dv;
        this.init(this.numberOfMolesInPhase, this.numberOfComponents, 3, 1.0);
        return (fold - fnew) / (2.0 * dv);
    }

    @Override
    public double dFdTdV() {
        double dv = this.getMolarVolume() / 1000.0;
        this.setMolarVolume(this.getMolarVolume() + dv);
        double fold = this.dFdT();
        this.setMolarVolume(this.getMolarVolume() - 2.0 * dv);
        double fnew = this.dFdT();
        this.setMolarVolume(this.getMolarVolume() + dv);
        return (fold - fnew) / (2.0 * dv);
    }

    @Override
    public double dFdV() {
        return (this.getFpoldV() + this.getFexpdV()) * 1000.0 * 1.0E-5;
    }

    @Override
    public double dFdVdV() {
        double dv = this.getMolarVolume() / 1000.0;
        this.setMolarVolume(this.getMolarVolume() + dv);
        double fold = this.dFdV();
        this.setMolarVolume(this.getMolarVolume() - 2.0 * dv);
        double fnew = this.dFdV();
        this.setMolarVolume(this.getMolarVolume() + dv);
        return (fold - fnew) / (2.0 * dv);
    }

    @Override
    public double molarVolume2(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        double BonV = pt == PhaseType.LIQUID ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        double Btemp = this.getB();
        this.setMolarVolume(1.0 / BonV * Btemp);
        int iterations = 0;
        int maxIterations = 10000;
        double guesPres = pressure;
        double guesPresdV = 0.0;
        do {
            ++iterations;
            guesPres = -8.3144621 * temperature * this.dFdV() + 8.3144621 * temperature / this.getMolarVolume();
            guesPresdV = -8.3144621 * temperature * this.dFdVdV() - this.getNumberOfMolesInPhase() * 8.3144621 * temperature / Math.pow(this.getTotalVolume(), 2.0);
            logger.info("gues pres " + guesPres);
            this.setMolarVolume(this.getMolarVolume() - 1.0 / (guesPresdV * this.getNumberOfMolesInPhase()) * (guesPres - pressure) / 50.0);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((guesPres - pressure) / pressure) > 1.0E-10 && iterations < maxIterations);
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(this, "molarVolume2", (long)maxIterations);
        }
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume2", "Molar Volume");
        }
        return this.getMolarVolume();
    }
}

