/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.component.ComponentHydrateGF;
import neqsim.thermo.component.ComponentHydratePVTsim;
import neqsim.thermo.mixingrule.MixingRuleTypeInterface;
import neqsim.thermo.mixingrule.MixingRulesInterface;
import neqsim.thermo.phase.Phase;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseHydrate
extends Phase {
    private static final long serialVersionUID = 1000L;
    String hydrateModel = "PVTsimHydrateModel";

    public PhaseHydrate() {
        this.setType(PhaseType.HYDRATE);
    }

    public PhaseHydrate(String fluidModel) {
        this.hydrateModel = fluidModel.isEmpty() ? "PVTsimHydrateModel" : (fluidModel.equals("CPAs-SRK-EOS-statoil") || fluidModel.equals("CPAs-SRK-EOS") || fluidModel.equals("CPA-SRK-EOS") ? "CPAHydrateModel" : "PVTsimHydrateModel");
    }

    @Override
    public PhaseHydrate clone() {
        PhaseHydrate clonedPhase = null;
        try {
            clonedPhase = (PhaseHydrate)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        double sum = 1.0;
        int hydrateStructure = ((ComponentHydrate)this.getComponent(0)).getHydrateStructure();
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                sum += ((ComponentHydrate)this.getComponent(i)).getCavprwat(hydrateStructure, j) * ((ComponentHydrate)this.getComponent(i)).calcYKI(hydrateStructure, j, this);
            }
        }
        return sum / ((ComponentHydrate)this.getComponent(0)).getMolarVolumeHydrate(hydrateStructure, temperature);
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = this.hydrateModel.equals("CPAHydrateModel") ? new ComponentHydrateGF(name, moles, molesInPhase, compNumber) : new ComponentHydratePVTsim(name, moles, molesInPhase, compNumber);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
        this.setType(PhaseType.HYDRATE);
    }

    @Override
    public MixingRulesInterface getMixingRule() {
        return null;
    }

    @Override
    public void setMixingRuleGEModel(String name) {
    }

    @Override
    public void resetMixingRule(MixingRuleTypeInterface mr) {
    }

    @Override
    public void setMixingRule(MixingRuleTypeInterface mr) {
    }

    public void setSolidRefFluidPhase(PhaseInterface refPhase) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentArray[i].getName().equals("water")) continue;
            ((ComponentHydrate)this.componentArray[i]).setSolidRefFluidPhase(refPhase);
        }
    }

    @Override
    public double getSoundSpeed() {
        return Double.NaN;
    }
}

