/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentSolid;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.phase.PhaseType;

public abstract class PhaseSolid
extends PhaseSrkEos {
    private static final long serialVersionUID = 1000L;

    public PhaseSolid() {
        this.setType(PhaseType.SOLID);
        this.calcMolarVolume = false;
    }

    @Override
    public PhaseSolid clone() {
        PhaseSolid clonedPhase = null;
        try {
            clonedPhase = (PhaseSolid)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        try {
            super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
            this.getDensityTemp();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        this.setType(PhaseType.SOLID);
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentSolid(name, moles, molesInPhase, compNumber);
    }

    @Override
    public double getEnthalpy() {
        double fusionHeat = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            fusionHeat += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getHeatOfFusion();
        }
        return super.getEnthalpy() - fusionHeat;
    }

    public void setSolidRefFluidPhase(PhaseInterface refPhase) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            ((ComponentSolid)this.componentArray[i]).setSolidRefFluidPhase(refPhase);
        }
    }

    public double getDensityTemp() {
        double density = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            density += this.getWtFrac(i) * ((ComponentSolid)this.componentArray[i]).getPureComponentSolidDensity(this.getTemperature()) * 1000.0;
        }
        this.molarVolume = density / this.getMolarMass() * 1.0E-5;
        return density;
    }
}

