/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentVegaEos;
import neqsim.thermo.phase.PhaseEos;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.netlib.util.doubleW;

public class PhaseVegaEos
extends PhaseEos {
    private static final long serialVersionUID = 1000L;
    int IPHASE = 0;
    boolean okVolume = true;
    double enthalpy = 0.0;
    double entropy = 0.0;
    double gibbsEnergy = 0.0;
    double CpVega = 0.0;
    double CvVega = 0.0;
    double internalEnery = 0.0;
    double JTcoef = 0.0;
    doubleW[] a0 = null;
    doubleW[][] ar = null;
    double kappa = 0.0;
    double W = 0.0;

    public PhaseVegaEos() {
        this.thermoPropertyModelName = "Vega Eos";
    }

    @Override
    public PhaseVegaEos clone() {
        PhaseVegaEos clonedPhase = null;
        try {
            clonedPhase = (PhaseVegaEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentVegaEos(name, moles, molesInPhase, compNumber);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        this.IPHASE = pt == PhaseType.LIQUID ? -1 : -2;
        super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
        if (!this.okVolume) {
            this.IPHASE = pt == PhaseType.LIQUID ? -2 : -1;
            super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
        }
        if (initType >= 1) {
            double[] temp = new double[18];
            temp = this.getProperties_Vega();
            this.a0 = this.getAlpha0_Vega();
            this.ar = this.getAlphares_Vega();
            this.pressure = temp[0] / 100.0;
            this.Z = temp[1];
            this.W = temp[11];
            this.JTcoef = temp[13];
            this.kappa = temp[14];
            this.gibbsEnergy = temp[12];
            this.internalEnery = temp[6];
            this.enthalpy = temp[7];
            this.entropy = temp[8];
            this.CpVega = temp[10];
            this.CvVega = temp[9];
            super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
        }
    }

    @Override
    public double getGibbsEnergy() {
        return this.gibbsEnergy * this.numberOfMolesInPhase;
    }

    @Override
    public double getZ() {
        return this.Z;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        return this.JTcoef * 1000.0;
    }

    @Override
    public double getEnthalpy() {
        return this.enthalpy * this.numberOfMolesInPhase;
    }

    @Override
    public double getEntropy() {
        return this.entropy * this.numberOfMolesInPhase;
    }

    @Override
    public double getInternalEnergy() {
        return this.internalEnery * this.numberOfMolesInPhase;
    }

    @Override
    public double getCp() {
        return this.CpVega * this.numberOfMolesInPhase;
    }

    @Override
    public double getCv() {
        return this.CvVega * this.numberOfMolesInPhase;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        return this.getMolarMass() * 100000.0 / this.getDensity_Vega();
    }

    @Override
    public double calcPressure() {
        return this.numberOfMolesInPhase / this.getVolume() * 8.3144621 * this.temperature * (1.0 + this.ar[0][1].val);
    }

    @Override
    public double calcPressuredV() {
        return -Math.pow(this.getDensity() / this.getMolarMass(), 2.0) * 8.3144621 * this.temperature * (1.0 + 2.0 * this.ar[0][1].val + this.ar[0][2].val) / this.numberOfMolesInPhase;
    }

    @Override
    public double dFdN(int i) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdN(this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }

    @Override
    public double dFdNdN(int i, int j) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdNdN(j, this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }

    @Override
    public double dFdNdV(int i) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdNdV(this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }

    @Override
    public double dFdNdT(int i) {
        return ((ComponentEosInterface)this.getComponent(i)).dFdNdT(this, this.getNumberOfComponents(), this.temperature, this.pressure);
    }

    @Override
    public double getDensity() {
        return this.getDensity_Vega();
    }

    @Override
    public double getdPdTVn() {
        return this.getNumberOfMolesInPhase() / this.getVolume() * 8.3144621 * (1.0 + this.ar[0][1].val + this.ar[1][1].val);
    }

    @Override
    public double getdPdVTn() {
        return -Math.pow(this.getNumberOfMolesInPhase() / this.getVolume(), 2.0) * 8.3144621 * this.temperature * (1.0 + 2.0 * this.ar[0][1].val + this.ar[0][2].val) / this.numberOfMolesInPhase;
    }

    @Override
    public double getdPdrho() {
        return 8.3144621 * this.temperature * (1.0 + 2.0 * this.ar[0][1].val + this.ar[0][2].val);
    }
}

