/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import java.io.Serializable;
import neqsim.chemicalreactions.ChemicalReactionOperations;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.physicalproperties.interfaceproperties.InterphasePropertiesInterface;
import neqsim.physicalproperties.system.PhysicalPropertyModel;
import neqsim.standards.StandardInterface;
import neqsim.thermo.characterization.Characterise;
import neqsim.thermo.characterization.WaxCharacterise;
import neqsim.thermo.characterization.WaxModelInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.mixingrule.EosMixingRuleType;
import neqsim.thermo.mixingrule.MixingRuleTypeInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemProperties;
import neqsim.thermo.util.readwrite.TablePrinter;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public interface SystemInterface
extends Cloneable,
Serializable {
    public static SystemInterface addFluids(SystemInterface addFluid1, SystemInterface addFluid2) {
        SystemInterface newFluid = addFluid1.clone();
        newFluid.addFluid(addFluid2);
        return newFluid;
    }

    public void addCapeOpenProperty(String var1);

    public void addCharacterized(String[] var1, double[] var2, double[] var3, double[] var4);

    public void addComponent(ComponentInterface var1);

    public void addComponent(int var1, double var2);

    public void addComponent(int var1, double var2, int var4);

    default public void addComponent(String name) {
        this.addComponent(name, 0.0);
    }

    public void addComponent(String var1, double var2);

    public void addComponent(String var1, double var2, double var4, double var6, double var8);

    public void addComponent(String var1, double var2, int var4);

    public void addComponent(String var1, double var2, String var4);

    public void addComponent(String var1, double var2, String var4, int var5);

    default public void addComponents(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.addComponent(names[i], 0.0);
        }
    }

    default public void addComponents(String[] names, double[] moles) {
        for (int i = 0; i < names.length; ++i) {
            this.addComponent(names[i], moles[i]);
        }
    }

    public SystemInterface addFluid(SystemInterface var1);

    public SystemInterface addFluid(SystemInterface var1, int var2);

    public void addGasToLiquid(double var1);

    public void addLiquidToGas(double var1);

    public void addOilFractions(String[] var1, double[] var2, double[] var3, double[] var4, boolean var5);

    public void addOilFractions(String[] var1, double[] var2, double[] var3, double[] var4, boolean var5, boolean var6, int var7);

    public void addPhase();

    public void addPhaseFractionToPhase(double var1, String var3, String var4, String var5);

    public void addPhaseFractionToPhase(double var1, String var3, String var4, String var5, String var6);

    public void addPlusFraction(String var1, double var2, double var4, double var6);

    public void addSalt(String var1, double var2);

    public void addSolidComplexPhase(String var1);

    public void addTBPfraction(String var1, double var2, double var4, double var6);

    public void addTBPfraction(String var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void addTBPfraction2(String var1, double var2, double var4, double var6);

    public double calculateDensityFromBoilingPoint(double var1, double var3);

    public void addToComponentNames(String var1);

    public boolean allowPhaseShift();

    public void allowPhaseShift(boolean var1);

    public void autoSelectMixingRule();

    public SystemInterface autoSelectModel();

    public void calc_x_y();

    public void calc_x_y_nonorm();

    public double calcHenrysConstant(String var1);

    public void calcInterfaceProperties();

    public void calcKIJ(boolean var1);

    default public String[][] calcResultTable() {
        return this.createTable("");
    }

    public void changeComponentName(String var1, String var2);

    public boolean checkStability();

    public void checkStability(boolean var1);

    public void chemicalReactionInit();

    public void clearAll();

    public SystemInterface clone();

    public void createDatabase(boolean var1);

    public String[][] createTable(String var1);

    public void deleteFluidPhase(int var1);

    @ExcludeFromJacocoGeneratedReport
    default public void display() {
        this.display(this.getFluidName());
    }

    public void display(String var1);

    public boolean doMultiPhaseCheck();

    public boolean doSolidPhaseCheck();

    public boolean equals(Object var1);

    public double getBeta();

    public double getBeta(int var1);

    public String[] getCapeOpenProperties10();

    public String[] getCapeOpenProperties11();

    public String[] getCASNumbers();

    public Characterise getCharacterization();

    public ChemicalReactionOperations getChemicalReactionOperations();

    public String[] getCompFormulaes();

    public String[] getCompIDs();

    public String[] getCompNames();

    default public ComponentInterface getComponent(int i) {
        return this.getPhase(0).getComponent(i);
    }

    default public ComponentInterface getComponent(String name) {
        return this.getPhase(0).getComponent(name);
    }

    default public String[] getComponentNames() {
        return this.getPhase(0).getComponentNames();
    }

    public String getComponentNameTag();

    public double getCorrectedVolume();

    public double getCorrectedVolumeFraction(int var1);

    public double getCp();

    public double getCp(String var1);

    public double getCv();

    public double getCv(String var1);

    public double getDensity();

    public double getDensity(String var1);

    public double getdVdPtn();

    public double getdVdTpn();

    public SystemInterface getEmptySystemClone();

    public double getEnthalpy();

    public double getEnthalpy(String var1);

    public double getEntropy();

    public double getEntropy(String var1);

    public double getExergy(double var1);

    public double getExergy(double var1, String var3);

    public double getFlowRate(String var1);

    public String getFluidInfo();

    public String getFluidName();

    public double getGamma();

    default public double getGamma2() {
        return this.getCp() / (this.getCp() - 8.3144621 * this.getTotalNumberOfMoles());
    }

    public PhaseInterface getGasPhase();

    public double getGibbsEnergy();

    public double getHeatOfVaporization();

    public double getHelmholtzEnergy();

    public boolean getHydrateCheck();

    public double getIdealLiquidDensity(String var1);

    public double getInterfacialTension(int var1, int var2);

    public double getInterfacialTension(int var1, int var2, String var3);

    public double getInterfacialTension(String var1, String var2);

    public double getInternalEnergy();

    public double getInternalEnergy(String var1);

    public InterphasePropertiesInterface getInterphaseProperties();

    public double getJouleThomsonCoefficient();

    public double getJouleThomsonCoefficient(String var1);

    public double getKappa();

    public double getKinematicViscosity();

    public double getKinematicViscosity(String var1);

    public PhaseInterface getLiquidPhase();

    public double getLiquidVolume();

    public PhaseInterface getLowestGibbsEnergyPhase();

    public double getMass(String var1);

    public int getMaxNumberOfPhases();

    public MixingRuleTypeInterface getMixingRule();

    public String getMixingRuleName();

    public String getModelName();

    public double[] getMolarComposition();

    public double getMolarMass();

    public double getMolarMass(String var1);

    public double[] getMolarRate();

    public double getMolarVolume();

    public double getMolarVolume(String var1);

    public double[] getMolecularWeights();

    public double getMoleFraction(int var1);

    public double getMoleFractionsSum();

    public double[] getNormalBoilingPointTemperatures();

    public int getNumberOfComponents();

    @Deprecated
    default public double getNumberOfMoles() {
        return this.getTotalNumberOfMoles();
    }

    public int getNumberOfOilFractionComponents();

    public int getNumberOfPhases();

    public int[] getOilFractionIDs();

    public double[] getOilFractionLiquidDensityAt25C();

    public double[] getOilFractionMolecularMass();

    public double[] getOilFractionNormalBoilingPoints();

    public double getPC();

    public PhaseInterface getPhase(int var1);

    public PhaseInterface getPhase(PhaseType var1);

    public PhaseInterface getPhase(String var1);

    public double getPhaseFraction(String var1, String var2);

    public int getPhaseIndex(int var1);

    public int getPhaseIndex(PhaseInterface var1);

    public int getPhaseIndex(String var1);

    public int getPhaseNumberOfPhase(PhaseType var1);

    default public int getPhaseNumberOfPhase(String phaseTypeName) {
        return this.getPhaseNumberOfPhase(PhaseType.byDesc(phaseTypeName));
    }

    public PhaseInterface getPhaseOfType(String var1);

    public PhaseInterface[] getPhases();

    public double getPressure();

    public double getPressure(int var1);

    public double getPressure(String var1);

    public SystemProperties getProperties();

    public double getProperty(String var1);

    public double getProperty(String var1, int var2);

    public double getProperty(String var1, String var2, int var3);

    public String[][] getResultTable();

    public double getSoundSpeed();

    public double getSoundSpeed(String var1);

    public StandardInterface getStandard();

    public StandardInterface getStandard(String var1);

    public double getTC();

    public double getTemperature();

    public double getTemperature(int var1);

    public double getTemperature(String var1);

    public double getThermalConductivity();

    public double getThermalConductivity(String var1);

    public double getTotalNumberOfMoles();

    public double getViscosity();

    public double getViscosity(String var1);

    public double getVolume();

    public double getVolume(String var1);

    public double getVolumeFraction(int var1);

    public WaxCharacterise getWaxCharacterisation();

    public WaxModelInterface getWaxModel();

    public double getWtFraction(int var1);

    public double getZ();

    public double getZvolcorr();

    default public boolean hasComponent(String name) {
        return this.hasComponent(name, true);
    }

    default public boolean hasComponent(String name, boolean normalized) {
        return this.getPhase(0).hasComponent(name, normalized);
    }

    public int hashCode();

    public boolean hasPhaseType(PhaseType var1);

    default public boolean hasPhaseType(String phaseTypeName) {
        return this.hasPhaseType(PhaseType.byDesc(phaseTypeName));
    }

    public boolean hasPlusFraction();

    default public boolean hasSolidPhase() {
        return this.hasPhaseType(PhaseType.SOLID);
    }

    public void init(int var1);

    public void init(int var1, int var2);

    public void init_x_y();

    public void initBeta();

    public void initNumeric();

    public void initPhysicalProperties();

    public void initPhysicalProperties(PhysicalPropertyType var1);

    default public void initPhysicalProperties(String name) {
        this.initPhysicalProperties(PhysicalPropertyType.byName(name));
    }

    default public void initProperties() {
        this.initThermoProperties();
        this.initPhysicalProperties();
    }

    public void initRefPhases();

    default public void initThermoProperties() {
        this.init(2);
    }

    public void initTotalNumberOfMoles(double var1);

    public void invertPhaseTypes();

    public boolean isChemicalSystem();

    public void isChemicalSystem(boolean var1);

    public boolean isForcePhaseTypes();

    public boolean isImplementedCompositionDeriativesofFugacity();

    public void isImplementedCompositionDeriativesofFugacity(boolean var1);

    public boolean isImplementedPressureDeriativesofFugacity();

    public boolean isImplementedTemperatureDeriativesofFugacity();

    public boolean isMultiphaseWaxCheck();

    public boolean isNumericDerivatives();

    public boolean isPhase(int var1);

    public void normalizeBeta();

    public void orderByDensity();

    public SystemInterface phaseToSystem(int var1);

    public SystemInterface phaseToSystem(int var1, int var2);

    public SystemInterface phaseToSystem(PhaseInterface var1);

    public SystemInterface phaseToSystem(String var1);

    default public void prettyPrint() {
        TablePrinter.printTable(this.createTable(this.getFluidName()));
    }

    public void readFluid(String var1);

    public SystemInterface readObject(int var1);

    public SystemInterface readObjectFromFile(String var1, String var2);

    public void reInitPhaseType();

    public void removeComponent(String var1);

    public void removePhase(int var1);

    public void removePhaseKeepTotalComposition(int var1);

    public void renameComponent(String var1, String var2);

    public void replacePhase(int var1, PhaseInterface var2);

    public void reset();

    public void reset_x_y();

    public void resetCharacterisation();

    public void resetDatabase();

    public void resetPhysicalProperties();

    public void save(String var1);

    public void saveFluid(int var1);

    public void saveFluid(int var1, String var2);

    public void saveObject(int var1, String var2);

    public void saveObjectToFile(String var1, String var2);

    public void saveToDataBase();

    public void setAllComponentsInPhase(int var1);

    public void setAllPhaseType(PhaseType var1);

    public void setAttractiveTerm(int var1);

    public void setBeta(double var1);

    public void setBeta(int var1, double var2);

    public void setBmixType(int var1);

    public void setComponentNames(String[] var1);

    public void setComponentNameTag(String var1);

    public void setComponentNameTagOnNormalComponents(String var1);

    public void setEmptyFluid();

    public void setFluidInfo(String var1);

    public void setFluidName(String var1);

    public void setForcePhaseTypes(boolean var1);

    public boolean setHeavyTBPfractionAsPlusFraction();

    public void setHydrateCheck(boolean var1);

    public void setImplementedCompositionDeriativesofFugacity(boolean var1);

    public void setImplementedPressureDeriativesofFugacity(boolean var1);

    public void setImplementedTemperatureDeriativesofFugacity(boolean var1);

    public void setMaxNumberOfPhases(int var1);

    public void setMixingRule(MixingRuleTypeInterface var1);

    default public void setMixingRule(int type) {
        this.setMixingRule(EosMixingRuleType.byValue(type));
    }

    default public void setMixingRule(String typename) {
        this.setMixingRule(EosMixingRuleType.byName(typename.replace("-", "_")));
    }

    public void setMixingRule(String var1, String var2);

    public SystemInterface setModel(String var1);

    public void setMolarComposition(double[] var1);

    public void setMolarCompositionOfPlusFluid(double[] var1);

    public void setMolarCompositionPlus(double[] var1);

    public void setMolarFlowRates(double[] var1);

    public void setComponentFlowRates(double[] var1, String var2);

    public void setMultiPhaseCheck(boolean var1);

    public void setMultiphaseWaxCheck(boolean var1);

    public void setNumberOfPhases(int var1);

    public void setNumericDerivatives(boolean var1);

    public void setPC(double var1);

    public void setPhase(PhaseInterface var1, int var2);

    public void setPhaseIndex(int var1, int var2);

    public void setPhaseType(int var1, PhaseType var2);

    public void setPhaseType(int var1, String var2);

    default public void setPhysicalPropertyModel(PhysicalPropertyModel ppm) {
        for (int i = 0; i < this.getNumberOfPhases(); ++i) {
            this.getPhase(i).setPhysicalPropertyModel(ppm);
        }
    }

    default public void setPhysicalPropertyModel(int type) {
        this.setPhysicalPropertyModel(PhysicalPropertyModel.byValue(type));
    }

    public void setPressure(double var1);

    public void setPressure(double var1, String var3);

    public void setSolidPhaseCheck(boolean var1);

    public void setSolidPhaseCheck(String var1);

    public void setStandard(String var1);

    public void setTC(double var1);

    public void setTemperature(double var1);

    public void setTemperature(double var1, int var3);

    public void setTemperature(double var1, String var3);

    public void setTotalFlowRate(double var1, String var3);

    public void setTotalNumberOfMoles(double var1);

    public void setUseTVasIndependentVariables(boolean var1);

    public void tuneModel(String var1, double var2, int var4);

    public void useVolumeCorrection(boolean var1);

    public void write(String var1, String var2, boolean var3);

    public double[] getKvector();

    public double[] getzvector();

    public String toJson();

    public String toCompJson();

    public void setForceSinglePhase(PhaseType var1);

    public void setForceSinglePhase(String var1);

    public boolean isInitialized();

    public void setMolarCompositionOfNamedComponents(String var1, double[] var2);

    public void addTBPfraction3(String var1, double var2, double var4, double var6);

    public void addTBPfraction4(String var1, double var2, double var4, double var6, double var8);

    public double calculateMolarMassFromDensityAndBoilingPoint(double var1, double var3);
}

