/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermSoreideWhitson;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseSoreideWhitson;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemPrEos1978;

public class SystemSoreideWhitson
extends SystemPrEos1978 {
    private static final long serialVersionUID = 1000L;
    private double salinity = 0.0;

    public SystemSoreideWhitson() {
        this(298.15, 1.0, false);
    }

    public SystemSoreideWhitson(double T, double P) {
        this(T, P, false);
    }

    public SystemSoreideWhitson(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.modelName = "Soreide-Whitson-PR-EoS";
        this.attractiveTermNumber = 20;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseSoreideWhitson();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public void addSalinity(double value, String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be null");
        }
        switch (unit.toLowerCase()) {
            case "mole/hr": {
                this.salinity += value / 3600.0;
                break;
            }
            case "mole/sec": {
                this.salinity += value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported unit: " + unit);
            }
        }
    }

    public void addSalinity(String saltType, double value, String unit) {
        double valueInMoleSec;
        if (saltType == null) {
            throw new IllegalArgumentException("Salt type cannot be null");
        }
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be null");
        }
        switch (unit.toLowerCase()) {
            case "mole/hr": {
                valueInMoleSec = value / 3600.0;
                break;
            }
            case "mole/sec": {
                valueInMoleSec = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported unit: " + unit);
            }
        }
        switch (saltType.trim().toUpperCase()) {
            case "Na2SO4": {
                this.salinity += 3.0 * valueInMoleSec;
                break;
            }
            case "MgSO4": {
                this.salinity += 2.75 * valueInMoleSec;
                break;
            }
            case "Mg(NO3)2": {
                this.salinity += 1.3 * valueInMoleSec;
                break;
            }
            case "NaCl": {
                this.salinity += 1.0 * valueInMoleSec;
                break;
            }
            case "NaNO3": {
                this.salinity += 0.6 * valueInMoleSec;
                break;
            }
            case "KCl": {
                this.salinity += 0.5 * valueInMoleSec;
                break;
            }
            case "KNO3": {
                this.salinity += 0.3 * valueInMoleSec;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported salt type: " + saltType);
            }
        }
    }

    public void setSalinity(double value, String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be null");
        }
        switch (unit.toLowerCase()) {
            case "mole/hr": {
                this.salinity = value / 3600.0;
                break;
            }
            case "mole/sec": {
                this.salinity = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported unit: " + unit);
            }
        }
    }

    public double getSalinity() {
        return this.salinity;
    }

    public boolean calcSalinity() {
        boolean updatedSalinity = false;
        double systemSalinity = this.getSalinity();
        double salinityConcentration = 0.0;
        double errorSalinityConcentration = 0.0;
        for (int i = 0; i < this.getNumberOfPhases(); ++i) {
            PhaseInterface aqueousPhase;
            if (!(systemSalinity > 0.0)) continue;
            try {
                aqueousPhase = this.getPhase(PhaseType.AQUEOUS);
            }
            catch (Exception e) {
                aqueousPhase = null;
            }
            if (aqueousPhase == null) continue;
            double massKgWater = aqueousPhase.getNumberOfMolesInPhase() * aqueousPhase.getMolarMass();
            if (massKgWater > 0.0) {
                salinityConcentration = systemSalinity / massKgWater;
                errorSalinityConcentration = Math.abs(((PhaseSoreideWhitson)aqueousPhase).getSalinityConcentration() - salinityConcentration);
                if (errorSalinityConcentration > 1.0E-6) {
                    ((PhaseSoreideWhitson)aqueousPhase).setSalinityConcentration(salinityConcentration);
                    updatedSalinity = true;
                }
            }
            for (int phaseN = 0; phaseN < this.getNumberOfPhases(); ++phaseN) {
                PhaseInterface phase = this.getPhase(phaseN);
                for (int compN = 0; compN < phase.getNumberOfComponents(); ++compN) {
                    AttractiveTermInterface attractiveTerm;
                    ComponentInterface comp = phase.getComponent(compN);
                    if (comp == null || !comp.getClass().getName().equals("neqsim.thermo.component.ComponentEosInterface") || (attractiveTerm = ((ComponentEosInterface)comp).getAttractiveTerm()) == null || !attractiveTerm.getClass().getName().equals("neqsim.thermo.component.attractiveeosterm.AttractiveTermSoreideWhitson")) continue;
                    ((AttractiveTermSoreideWhitson)attractiveTerm).setSalinityFromPhase(salinityConcentration);
                }
            }
        }
        return updatedSalinity;
    }

    @Override
    public SystemSoreideWhitson clone() {
        SystemSoreideWhitson clonedSystem = null;
        try {
            clonedSystem = (SystemSoreideWhitson)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

