/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.empiric;

import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class BukacekWaterInGas {
    public static double getWaterInGas(double temperature, double pressure) {
        double TCwater = 667.14;
        double PCwater = 220.64;
        double tau = (TCwater - temperature) / TCwater;
        double temp = (-7.85823 * tau + 1.83991 * Math.pow(tau, 1.5) - 11.7811 * Math.pow(tau, 3.0) + 22.67 * Math.pow(tau, 3.5) - 15.9393 * Math.pow(tau, 4.0) + 1.77516 * Math.pow(tau, 7.5)) / (1.0 - tau);
        double psw = PCwater * Math.exp(temp);
        double mgwaterSm3 = 761900.42 * psw / pressure + 16.016 * Math.pow(10.0, -1716.26 / temperature + 6.69449);
        double molarMassGas = 16800.0;
        double ans = mgwaterSm3 / molarMassGas;
        double molgasSm3 = 42.29254601480821;
        return ans / molgasSm3;
    }

    public static double waterDewPointTemperature(double moleFractionWaterInGas, double pressure) {
        double newppm;
        int iter = 0;
        double newTemp = 273.15;
        do {
            newppm = BukacekWaterInGas.getWaterInGas(newTemp, pressure);
            newTemp -= (newppm - moleFractionWaterInGas) * 100000.0;
        } while (Math.abs((newppm - moleFractionWaterInGas) / moleFractionWaterInGas) > 1.0E-8 && ++iter < 1000);
        return newTemp;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        System.out.println("water in gas " + BukacekWaterInGas.getWaterInGas(255.14999999999998, 70.0));
        System.out.println("water dew point temperature " + (BukacekWaterInGas.waterDewPointTemperature(2.0E-5, 70.0) - 273.15));
    }
}

