/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.readwrite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.system.SystemEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemPrEos1978;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EclipseFluidReadWrite {
    static Logger logger = LogManager.getLogger(EclipseFluidReadWrite.class);
    public static String pseudoName = "";

    public static void setComposition(SystemInterface fluid, String inputFile, String pseudoNameIn) {
        pseudoName = pseudoNameIn;
        EclipseFluidReadWrite.setComposition(fluid, inputFile);
    }

    public static void setComposition(SystemInterface fluid, String inputFile) {
        fluid.setEmptyFluid();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            String st;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            while ((st = br.readLine()) != null) {
                if ((st = st.trim()).equals("CNAMES")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--")) {
                        names.add(st);
                    }
                }
                if (!st.equals("ZI")) continue;
                while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--")) {
                    ZI.add(Double.parseDouble(st));
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                String name = (String)names.get(counter);
                if (name.equals("C1")) {
                    name = "methane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C2")) {
                    name = "ethane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("N2")) {
                    name = "nitrogen";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("iC4")) {
                    name = "i-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C4")) {
                    name = "n-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("iC5")) {
                    name = "i-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C5")) {
                    name = "n-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C6")) {
                    name = "n-hexane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C3")) {
                    name = "propane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("CO2")) {
                    name = "CO2";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                fluid.addComponent(name + pseudoName, (double)((Double)ZI.get(counter)));
            }
        }
        catch (RuntimeException ex) {
            logger.error(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public static SystemInterface read(String inputFile, String pseudoNameIn) {
        pseudoName = pseudoNameIn;
        return EclipseFluidReadWrite.read(inputFile);
    }

    public static SystemInterface read(String inputFile) {
        SystemEos fluid = new SystemSrkEos(288.15, 1.01325);
        Double[][] kij = null;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            String st;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> TC = new ArrayList<Double>();
            ArrayList<Double> PC = new ArrayList<Double>();
            ArrayList<Double> ACF = new ArrayList<Double>();
            ArrayList<Double> MW = new ArrayList<Double>();
            ArrayList<Double> SSHIFT = new ArrayList<Double>();
            ArrayList<Double> SSHIFTS = new ArrayList<Double>();
            ArrayList<Double> TBOIL = new ArrayList<Double>();
            ArrayList<Double> VCRIT = new ArrayList<Double>();
            ArrayList<Double> PARACHOR = new ArrayList<Double>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            ArrayList<Double> BIC = new ArrayList<Double>();
            while ((st = br.readLine()) != null) {
                String line;
                if ((st = st.trim()).trim().equals("EOS")) {
                    String corr;
                    String EOS = br.readLine().trim().replace("/", "");
                    fluid = EOS.contains("SRK") ? new SystemSrkEos(288.15, 1.01325) : (EOS.contains("PR") ? ((corr = br.readLine().trim().replace("/", "")).equals("PRCORR") ? new SystemPrEos1978(288.15, 1.01325) : new SystemPrEos(288.15, 1.01325)) : new SystemPrEos(288.15, 1.01325));
                }
                if (st.trim().equals("CNAMES")) {
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        names.add(st);
                    }
                }
                if (st.trim().equals("TCRIT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        TC.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("PCRIT")) {
                    st = st.trim();
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        PC.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("ACF")) {
                    st = st.trim();
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        ACF.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("MW")) {
                    st = st.trim();
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        MW.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("TBOIL")) {
                    st = st.trim();
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        TBOIL.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("VCRIT")) {
                    st = st.trim();
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        VCRIT.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("SSHIFT")) {
                    st = st.trim();
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        SSHIFT.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("PARACHOR")) {
                    st = st.trim();
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        PARACHOR.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("ZI")) {
                    st = st.trim();
                    while ((st = br.readLine().replace("/", "")) != null && !(st = st.trim()).startsWith("--") && !st.isEmpty()) {
                        ZI.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("BIC")) {
                    st = st.trim();
                    int addedComps = 0;
                    for (Object[] objectArray : kij = new Double[names.size()][names.size()]) {
                        Arrays.fill(objectArray, (Object)0.0);
                    }
                    int lengthLastLine = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    while (!((st = br.readLine().replace("/", "")) == null || addedComps >= names.size() - 1 || (st = st.trim()).startsWith("--") || st.isEmpty() || st.trim().startsWith("/") || st.trim().startsWith(" "))) {
                        String[] arr = st.trim().split("\\s+");
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(arr));
                        list.addAll(arrayList);
                        list.removeAll(Arrays.asList("", null));
                        if (lengthLastLine >= list.size()) continue;
                        lengthLastLine = list.size();
                        for (int i = 0; i < list.size(); ++i) {
                            BIC.add(Double.parseDouble((String)list.get(i)));
                            kij[i][addedComps + 1] = Double.parseDouble((String)list.get(i));
                            kij[addedComps + 1][i] = kij[i][addedComps + 1];
                        }
                        ++addedComps;
                        list.clear();
                    }
                }
                if (!st.trim().equals("SSHIFTS")) continue;
                while ((line = br.readLine()) != null && !(st = (line = line.trim()).replace("/", "")).startsWith("--") && !st.isEmpty()) {
                    try {
                        SSHIFTS.add(Double.parseDouble(st));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing double value: " + e.getMessage());
                    }
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                String name = (String)names.get(counter);
                if (name.equals("C1") || (Double)TC.get(counter) < 0.0) {
                    name = "methane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C2") || (Double)TC.get(counter) < 0.0) {
                    name = "ethane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("N2") || (Double)TC.get(counter) < 0.0) {
                    name = "nitrogen";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("iC4") || (Double)TC.get(counter) < 0.0) {
                    name = "i-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C4") || (Double)TC.get(counter) < 0.0) {
                    name = "n-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("iC5") || (Double)TC.get(counter) < 0.0) {
                    name = "i-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C5") || (Double)TC.get(counter) < 0.0) {
                    name = "n-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C6") || (Double)TC.get(counter) < 0.0) {
                    name = "n-hexane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C3") || (Double)TC.get(counter) < 0.0) {
                    name = "propane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("CO2") || (Double)TC.get(counter) < 0.0) {
                    name = "CO2";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.trim().equals("H2O") || (Double)TC.get(counter) < 0.0) {
                    name = "water";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if ((Double)TC.get(counter) >= 0.0) {
                    name = (String)names.get(counter);
                    Double stddensity = 0.5046 * (Double)MW.get(counter) / 1000.0 + 0.668468;
                    fluid.addTBPfraction(name, (Double)ZI.get(counter), (Double)MW.get(counter) / 1000.0, stddensity);
                    name = name + "_PC";
                } else {
                    name = (String)names.get(counter);
                    Double stddensity = 0.5046 * (Double)MW.get(counter) / 1000.0 + 0.668468;
                    fluid.addTBPfraction(name, (Double)ZI.get(counter), (Double)MW.get(counter) / 1000.0, stddensity);
                    name = name + "_PC";
                }
                for (int i = 0; i < fluid.getMaxNumberOfPhases(); ++i) {
                    fluid.getPhase(i).getComponent(name).setTC((Double)TC.get(counter));
                    fluid.getPhase(i).getComponent(name).setPC((Double)PC.get(counter));
                    fluid.getPhase(i).getComponent(name).setAcentricFactor((Double)ACF.get(counter));
                    fluid.getPhase(i).getComponent(name).setMolarMass((Double)MW.get(counter) / 1000.0);
                    fluid.getPhase(i).getComponent(name).setNormalBoilingPoint((Double)TBOIL.get(counter));
                    fluid.getPhase(i).getComponent(name).setCriticalVolume((Double)VCRIT.get(counter));
                    fluid.getPhase(i).getComponent(name).setParachorParameter((Double)PARACHOR.get(counter));
                    if (SSHIFTS.size() > 0) {
                        fluid.getPhase(i).getComponent(name).setVolumeCorrectionConst((Double)SSHIFTS.get(counter));
                    } else {
                        fluid.getPhase(i).getComponent(name).setVolumeCorrectionConst((Double)SSHIFT.get(counter));
                    }
                    fluid.getPhase(i).getComponent(name).setRacketZ(0.29056 - 0.08775 * (Double)ACF.get(counter));
                }
                if (!fluid.getPhase(0).getComponent(name).isIsTBPfraction()) continue;
                fluid.changeComponentName(name, ((String)names.get(counter)).replaceAll("_PC", "") + pseudoName);
            }
            fluid.setMixingRule(2);
            fluid.useVolumeCorrection(true);
            fluid.init(0);
            for (int i = 0; i < names.size(); ++i) {
                for (int j = i; j < names.size(); ++j) {
                    for (int phaseNum = 0; phaseNum < fluid.getMaxNumberOfPhases(); ++phaseNum) {
                        ((PhaseEosInterface)fluid.getPhase(phaseNum)).getEosMixingRule().setBinaryInteractionParameter(i, j, kij[i][j]);
                        ((PhaseEosInterface)fluid.getPhase(phaseNum)).getEosMixingRule().setBinaryInteractionParameter(j, i, kij[i][j]);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return fluid;
    }

    public static SystemInterface read(String inputFile, String[] fluidNames) {
        SystemEos fluid = new SystemSrkEos(288.15, 1.01325);
        Double[][] kij = null;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            String st;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> TC = new ArrayList<Double>();
            ArrayList<Double> PC = new ArrayList<Double>();
            ArrayList<Double> ACF = new ArrayList<Double>();
            ArrayList<Double> MW = new ArrayList<Double>();
            ArrayList<Double> SSHIFT = new ArrayList<Double>();
            ArrayList<Double> SSHIFTS = new ArrayList<Double>();
            ArrayList<Double> TBOIL = new ArrayList<Double>();
            ArrayList<Double> VCRIT = new ArrayList<Double>();
            ArrayList<Double> PARACHOR = new ArrayList<Double>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            ArrayList<Double> BIC = new ArrayList<Double>();
            while ((st = br.readLine()) != null) {
                Object line;
                if ((st = st.trim()).equals("EOS")) {
                    String corr;
                    st = st.trim();
                    String EOS = br.readLine().trim().replace("/", "");
                    fluid = EOS.contains("SRK") ? new SystemSrkEos(288.15, 1.01325) : (EOS.contains("PR") ? ((corr = br.readLine().trim().replace("/", "")).equals("PRCORR") ? new SystemPrEos1978(288.15, 1.01325) : new SystemPrEos(288.15, 1.01325)) : new SystemPrEos(288.15, 1.01325));
                }
                if (st.trim().equals("CNAMES")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        names.add(st);
                    }
                }
                if (st.trim().equals("TCRIT")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        TC.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("PCRIT")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        PC.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("ACF")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        ACF.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("MW")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        MW.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("TBOIL")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        TBOIL.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("VCRIT")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        VCRIT.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("SSHIFT")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        SSHIFT.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("PARACHOR")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        PARACHOR.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("ZI")) {
                    while ((st = br.readLine().trim().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        ZI.add(Double.parseDouble(st));
                    }
                }
                if (st.trim().equals("BIC")) {
                    int addedComps = 0;
                    for (Object[] objectArray : kij = new Double[names.size()][names.size()]) {
                        Arrays.fill(objectArray, (Object)0.0);
                    }
                    int lengthLastLine = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    while ((st = br.readLine().trim().replace("/", "")) != null && addedComps < names.size() - 1 && !st.startsWith("--") && !st.isEmpty()) {
                        String[] arr = st.split("  ");
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(arr));
                        list.addAll(arrayList);
                        list.removeAll(Arrays.asList("", null));
                        if (lengthLastLine >= list.size()) continue;
                        lengthLastLine = list.size();
                        for (int i = 0; i < list.size(); ++i) {
                            BIC.add(Double.parseDouble((String)list.get(i)));
                            kij[i][addedComps + 1] = Double.parseDouble((String)list.get(i));
                            kij[addedComps + 1][i] = kij[i][addedComps + 1];
                        }
                        ++addedComps;
                        list.clear();
                    }
                }
                if (!st.trim().equals("SSHIFTS")) continue;
                while ((line = br.readLine().trim()) != null && !(st = ((String)line).replace("/", "")).startsWith("--") && !st.isEmpty()) {
                    try {
                        SSHIFTS.add(Double.parseDouble(st));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing double value: " + e.getMessage());
                    }
                }
            }
            for (String fluidName : fluidNames) {
                for (int i = 0; i < names.size(); ++i) {
                    String name = (String)names.get(i);
                    if (name.equals("C1") || (Double)TC.get(i) < 0.0) {
                        name = "methane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("C2") || (Double)TC.get(i) < 0.0) {
                        name = "ethane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("N2") || (Double)TC.get(i) < 0.0) {
                        name = "nitrogen";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("iC4") || (Double)TC.get(i) < 0.0) {
                        name = "i-butane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("C4") || (Double)TC.get(i) < 0.0) {
                        name = "n-butane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("iC5") || (Double)TC.get(i) < 0.0) {
                        name = "i-pentane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("C5") || (Double)TC.get(i) < 0.0) {
                        name = "n-pentane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("C6") || (Double)TC.get(i) < 0.0) {
                        name = "n-hexane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("C3") || (Double)TC.get(i) < 0.0) {
                        name = "propane";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.equals("CO2") || (Double)TC.get(i) < 0.0) {
                        name = "CO2";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if (name.trim().equals("H2O") || (Double)TC.get(i) < 0.0) {
                        name = "water";
                        fluid.addComponent(name, (double)((Double)ZI.get(i)));
                    } else if ((Double)TC.get(i) >= 0.0) {
                        name = (String)names.get(i);
                        Double stddensity = 0.5046 * (Double)MW.get(i) / 1000.0 + 0.668468;
                        fluid.addTBPfraction(name, (Double)ZI.get(i), (Double)MW.get(i) / 1000.0, stddensity);
                        name = name + "_PC";
                    } else {
                        name = (String)names.get(i);
                        Double stddensity = 0.5046 * (Double)MW.get(i) / 1000.0 + 0.668468;
                        fluid.addTBPfraction(name, (Double)ZI.get(i), (Double)MW.get(i) / 1000.0, stddensity);
                        name = name + "_PC";
                    }
                    for (int i2 = 0; i2 < fluid.getMaxNumberOfPhases(); ++i2) {
                        fluid.getPhase(i2).getComponent(name).setTC((Double)TC.get(i));
                        fluid.getPhase(i2).getComponent(name).setPC((Double)PC.get(i));
                        fluid.getPhase(i2).getComponent(name).setAcentricFactor((Double)ACF.get(i));
                        fluid.getPhase(i2).getComponent(name).setMolarMass((Double)MW.get(i) / 1000.0);
                        fluid.getPhase(i2).getComponent(name).setNormalBoilingPoint((Double)TBOIL.get(i));
                        fluid.getPhase(i2).getComponent(name).setCriticalVolume((Double)VCRIT.get(i));
                        fluid.getPhase(i2).getComponent(name).setParachorParameter((Double)PARACHOR.get(i));
                        if (SSHIFTS.size() > 0) {
                            fluid.getPhase(i2).getComponent(name).setVolumeCorrectionConst((Double)SSHIFTS.get(i));
                        } else {
                            fluid.getPhase(i2).getComponent(name).setVolumeCorrectionConst((Double)SSHIFT.get(i));
                        }
                        fluid.getPhase(i2).getComponent(name).setRacketZ(0.29056 - 0.08775 * (Double)ACF.get(i));
                    }
                    fluid.changeComponentName(name, name + "_" + fluidName);
                }
            }
            fluid.setMixingRule(2);
            fluid.useVolumeCorrection(true);
            fluid.init(0);
            int nCompsPerFluid = names.size();
            int nFluids = fluidNames.length;
            for (int i = 0; i < nCompsPerFluid * nFluids; ++i) {
                int fluidIndexI = i / nCompsPerFluid;
                int n = i % nCompsPerFluid;
                for (int j = 0; j < nCompsPerFluid * nFluids; ++j) {
                    int fluidIndexJ = j / nCompsPerFluid;
                    int baseIndexJ = j % nCompsPerFluid;
                    double kijVal = kij[n][baseIndexJ];
                    for (int phaseNum = 0; phaseNum < fluid.getMaxNumberOfPhases(); ++phaseNum) {
                        ((PhaseEosInterface)fluid.getPhase(phaseNum)).getEosMixingRule().setBinaryInteractionParameter(i, j, kijVal);
                        ((PhaseEosInterface)fluid.getPhase(phaseNum)).getEosMixingRule().setBinaryInteractionParameter(j, i, kijVal);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return fluid;
    }

    public static SystemInterface readE300File(String inputFile) {
        SystemSrkEos fluid = new SystemSrkEos(288.15, 1.01325);
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            String line;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> TC = new ArrayList<Double>();
            ArrayList<Double> PC = new ArrayList<Double>();
            ArrayList<Double> ACF = new ArrayList<Double>();
            ArrayList<Double> MW = new ArrayList<Double>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            block11: while ((line = br.readLine().trim()) != null) {
                if ((line = line.trim()).equals("CNAMES")) {
                    while ((line = br.readLine().trim()) != null) {
                        if ((line = line.trim()).endsWith("/")) {
                            names.add(line.substring(0, line.length() - 1).trim());
                            continue block11;
                        }
                        names.add(line);
                    }
                    continue;
                }
                if (line.equals("TCRIT")) {
                    while ((line = br.readLine().trim()) != null) {
                        if ((line = line.trim()).endsWith("/")) {
                            TC.add(Double.parseDouble(line.substring(0, line.length() - 1).trim()));
                            continue block11;
                        }
                        TC.add(Double.parseDouble(line));
                    }
                    continue;
                }
                if (line.equals("PCRIT")) {
                    while ((line = br.readLine().trim()) != null) {
                        if ((line = line.trim()).endsWith("/")) {
                            PC.add(Double.parseDouble(line.substring(0, line.length() - 1).trim()));
                            continue block11;
                        }
                        PC.add(Double.parseDouble(line));
                    }
                    continue;
                }
                if (line.equals("ACF")) {
                    while ((line = br.readLine().trim()) != null) {
                        if ((line = line.trim()).endsWith("/")) {
                            ACF.add(Double.parseDouble(line.substring(0, line.length() - 1).trim()));
                            continue block11;
                        }
                        ACF.add(Double.parseDouble(line));
                    }
                    continue;
                }
                if (line.equals("MW")) {
                    while ((line = br.readLine().trim()) != null) {
                        if ((line = line.trim()).endsWith("/")) {
                            MW.add(Double.parseDouble(line.substring(0, line.length() - 1).trim()));
                            continue block11;
                        }
                        MW.add(Double.parseDouble(line));
                    }
                    continue;
                }
                if (!line.equals("ZI")) continue;
                while ((line = br.readLine().trim()) != null) {
                    if ((line = line.trim()).endsWith("/")) {
                        ZI.add(Double.parseDouble(line.substring(0, line.length() - 1).trim()));
                        continue block11;
                    }
                    ZI.add(Double.parseDouble(line));
                }
            }
            for (int i = 0; i < names.size(); ++i) {
                String name = (String)names.get(i);
                double zi = (Double)ZI.get(i);
                fluid.addComponent(name, zi);
                for (int phase = 0; phase < fluid.getMaxNumberOfPhases(); ++phase) {
                    fluid.getPhase(phase).getComponent(name).setTC((Double)TC.get(i));
                    fluid.getPhase(phase).getComponent(name).setPC((Double)PC.get(i));
                    fluid.getPhase(phase).getComponent(name).setAcentricFactor((Double)ACF.get(i));
                    fluid.getPhase(phase).getComponent(name).setMolarMass((Double)MW.get(i) / 1000.0);
                }
            }
            fluid.setMixingRule(2);
            fluid.useVolumeCorrection(true);
            fluid.init(0);
        }
        catch (Exception ex) {
            logger.error("Error reading E300 file: " + ex.getMessage(), (Throwable)ex);
        }
        return fluid;
    }
}

