/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.SysNewtonRhapsonPHflash;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class QfuncFlash
extends Flash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(QfuncFlash.class);
    double Hspec = 0.0;
    Flash tpFlash;
    int type = 0;

    public QfuncFlash() {
    }

    public QfuncFlash(SystemInterface system, double Hspec, int type) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Hspec = Hspec;
        this.type = type;
    }

    public double calcdQdTT() {
        double dQdTT = -this.system.getTemperature() * this.system.getTemperature() * this.system.getCp();
        return dQdTT;
    }

    public double calcdQdT() {
        double dQ = this.system.getEnthalpy() - this.Hspec;
        return dQ;
    }

    public double solveQ() {
        double oldTemp = 1.0 / this.system.getTemperature();
        double nyTemp = 1.0 / this.system.getTemperature();
        double iterations = 1.0;
        do {
            iterations += 1.0;
            oldTemp = nyTemp;
            this.system.init(3);
            nyTemp = oldTemp - this.calcdQdT() / this.calcdQdTT();
            this.system.setTemperature(1.0 / nyTemp);
            this.tpFlash.run();
        } while (Math.abs((1.0 / nyTemp - 1.0 / oldTemp) / (1.0 / nyTemp)) > 1.0E-9 && iterations < 1000.0);
        return 1.0 / nyTemp;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        logger.info("entropy: " + this.system.getEntropy());
        SysNewtonRhapsonPHflash secondOrderSolver = new SysNewtonRhapsonPHflash(this.system, 2, this.system.getPhases()[0].getNumberOfComponents(), this.type);
        secondOrderSolver.setSpec(this.Hspec);
        secondOrderSolver.solve(1);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

