/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrateInhibitorConcentrationFlash
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(HydrateInhibitorConcentrationFlash.class);
    double hydT = 273.15;
    String inhibitor = "MEG";

    public HydrateInhibitorConcentrationFlash(SystemInterface system, String inhibitor, double hydrateTemperature) {
        super(system);
        this.hydT = hydrateTemperature;
        this.inhibitor = inhibitor;
    }

    public void stop() {
        this.system = null;
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iter = 0;
        double error = 1.0;
        double oldError = 1.0;
        double oldC = this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles();
        double derrordC = 1.0;
        do {
            ++iter;
            try {
                derrordC = (error - oldError) / (this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles() - oldC);
                oldError = error;
                oldC = this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles();
                if (iter < 4) {
                    this.system.addComponent(this.inhibitor, error * 0.01);
                } else {
                    double newC = -error / derrordC;
                    double correction = newC * 0.5;
                    this.system.addComponent(this.inhibitor, correction);
                }
                this.system.init(0);
                this.system.init(1);
                ops.hydrateFormationTemperature(this.system.getTemperature());
                error = this.system.getTemperature() - this.hydT;
                logger.info("error " + error);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } while (Math.abs(error) > 0.001 && iter < 100 || iter < 3);
    }

    @Override
    public void printToFile(String name) {
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(273.15, 100.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("methane", 1.0);
        testSystem.addComponent("ethane", 0.1);
        testSystem.addComponent("propane", 0.05);
        testSystem.addComponent("i-butane", 0.005);
        testSystem.addComponent("MEG", 0.1);
        testSystem.addComponent("water", 1.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(9);
        testSystem.init(0);
        testSystem.setMultiPhaseCheck(true);
        testSystem.setHydrateCheck(true);
        try {
            testOps.hydrateInhibitorConcentration("MEG", 270.9);
            double cons = 100.0 * testSystem.getPhase(0).getComponent("MEG").getNumberOfmoles() * testSystem.getPhase(0).getComponent("MEG").getMolarMass() / (testSystem.getPhase(0).getComponent("MEG").getNumberOfmoles() * testSystem.getPhase(0).getComponent("MEG").getMolarMass() + testSystem.getPhase(0).getComponent("water").getNumberOfmoles() * testSystem.getPhase(0).getComponent("water").getMolarMass());
            logger.info("hydrate inhibitor concentration " + cons + " wt%");
        }
        catch (Exception ex) {
            ex.toString();
        }
        testSystem.display();
    }
}

