/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.OperationInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.jfree.chart.JFreeChart;

public class PTphaseEnvelopeNew3
implements OperationInterface {
    private final SystemInterface system;
    private double[][] betta;
    private boolean[][] bettaTransitionRegion;
    double[] pressures;
    double[] temperatures;
    private double[] dewPointTemperatures;
    private double[] dewPointPressures;
    private List<Double> pressurePhaseEnvelope = new ArrayList<Double>();
    private List<Double> temperaturePhaseEnvelope = new ArrayList<Double>();
    private List<double[]> refinedTransitionPoints = new ArrayList<double[]>();
    private double minPressure;
    private double maxPressure;
    private double minTemp;
    private double maxTemp;
    private double pressureStep;
    private double tempStep;

    public PTphaseEnvelopeNew3(SystemInterface system, double minPressure, double maxPressure, double minTemp, double maxTemp, double pressureStep, double tempStep) {
        this.system = system;
        this.minPressure = minPressure;
        this.maxPressure = maxPressure;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.pressureStep = pressureStep;
        this.tempStep = tempStep;
    }

    @Override
    public void run() {
        this.coarse();
        this.findBettaTransitionsAndRefine();
    }

    public void coarse() {
        int j;
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        int nP = (int)Math.round((this.maxPressure - this.minPressure) / this.pressureStep) + 1;
        int nT = (int)Math.round((this.maxTemp - this.minTemp) / this.tempStep) + 1;
        this.betta = new double[nT][nP];
        this.pressures = new double[nP];
        this.temperatures = new double[nT];
        for (int i = 0; i < nP; ++i) {
            this.pressures[i] = this.minPressure + (double)i * this.pressureStep;
        }
        for (j = 0; j < nT; ++j) {
            this.temperatures[j] = this.minTemp + (double)j * this.tempStep;
        }
        for (j = 0; j < nT; ++j) {
            for (int i = 0; i < nP; ++i) {
                this.system.setPressure(this.pressures[i], "bara");
                this.system.setTemperature(this.temperatures[j], "C");
                try {
                    testOps.TPflash();
                }
                catch (Exception e) {
                    this.betta[j][i] = Double.NaN;
                    continue;
                }
                this.betta[j][i] = this.system.getBeta();
            }
        }
    }

    public void findBettaTransitionsAndRefine() {
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        for (int i = 0; i < this.pressures.length; ++i) {
            for (int j = 1; j < this.temperatures.length; ++j) {
                double bettaVal;
                double tHigh;
                double tEnd;
                double tLow;
                double tStart;
                double p;
                double tTransition;
                double bettaPrev = this.betta[j - 1][i];
                double bettaCurr = this.betta[j][i];
                if (Double.isNaN(bettaPrev) || Double.isNaN(bettaCurr) || !(bettaPrev >= 1.0 && bettaCurr < 1.0) && (!(bettaPrev < 1.0) || !(bettaCurr >= 1.0)) || Double.isNaN(tTransition = this.bisectionBettaTransition(testOps, p = this.pressures[i], tStart = (tLow = this.temperatures[j - 1]), tEnd = (tHigh = this.temperatures[j]), 0.9999999, 1.0E-8, 5))) continue;
                this.system.setPressure(p, "bara");
                this.system.setTemperature(tTransition, "C");
                try {
                    testOps.TPflash();
                    bettaVal = this.system.getBeta();
                }
                catch (Exception e) {
                    bettaVal = Double.NaN;
                }
                this.refinedTransitionPoints.add(new double[]{p, tTransition, bettaVal});
                this.pressurePhaseEnvelope.add(p);
                this.temperaturePhaseEnvelope.add(tTransition);
            }
        }
    }

    private double bisectionBettaTransition(ThermodynamicOperations testOps, double pressure, double tLow, double tHigh, double target, double tol, int maxIter) {
        double fLow = this.getBettaAt(testOps, pressure, tLow) - target;
        double fHigh = this.getBettaAt(testOps, pressure, tHigh) - target;
        if (Double.isNaN(fLow) || Double.isNaN(fHigh) || fLow * fHigh > 0.0) {
            return Double.NaN;
        }
        for (int iter = 0; iter < maxIter; ++iter) {
            double tMid = 0.5 * (tLow + tHigh);
            double fMid = this.getBettaAt(testOps, pressure, tMid) - target;
            if (Double.isNaN(fMid)) {
                return Double.NaN;
            }
            if (Math.abs(fMid) < tol) {
                return tMid;
            }
            if (fLow * fMid < 0.0) {
                tHigh = tMid;
                fHigh = fMid;
                continue;
            }
            tLow = tMid;
            fLow = fMid;
        }
        return 0.5 * (tLow + tHigh);
    }

    private double getBettaAt(ThermodynamicOperations testOps, double pressure, double temperature) {
        this.system.setPressure(pressure, "bara");
        this.system.setTemperature(temperature, "C");
        try {
            testOps.TPflash();
            return this.system.getBeta();
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public List<double[]> getRefinedTransitionPoints() {
        return this.refinedTransitionPoints;
    }

    public double[] getPressures() {
        return this.pressures;
    }

    public double[] getTemperatures() {
        return this.temperatures;
    }

    @Override
    public void displayResult() {
    }

    @Override
    public double[][] getPoints(int i) {
        return new double[0][0];
    }

    @Override
    public void addData(String name, double[][] data) {
    }

    @Override
    public String[][] getResultTable() {
        return new String[0][0];
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public double[] get(String name) {
        return new double[0];
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.system;
    }

    public double[][] getPhaseMatrix() {
        return this.betta;
    }

    public boolean[][] getBettaTransitionRegion() {
        return this.bettaTransitionRegion;
    }

    public double[][] getBettaMatrix() {
        return this.betta;
    }

    public double[] getDewPointTemperatures() {
        return this.dewPointTemperatures;
    }

    public double[] getDewPointPressures() {
        return this.dewPointPressures;
    }

    public List<Double> getPressurePhaseEnvelope() {
        return this.pressurePhaseEnvelope;
    }

    public List<Double> getTemperaturePhaseEnvelope() {
        return this.temperaturePhaseEnvelope;
    }

    public double getCricondenbar() {
        if (this.pressurePhaseEnvelope.isEmpty()) {
            return Double.NaN;
        }
        return Collections.max(this.pressurePhaseEnvelope);
    }

    public double getCricondentherm() {
        if (this.temperaturePhaseEnvelope.isEmpty()) {
            return Double.NaN;
        }
        return Collections.max(this.temperaturePhaseEnvelope);
    }
}

