/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.propertygenerator;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.BaseOperation;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLGApropertyTableGenerator
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(OLGApropertyTableGenerator.class);
    SystemInterface thermoSystem = null;
    ThermodynamicOperations thermoOps = null;
    double[] pressures;
    double[] temperatureLOG;
    double[] temperatures;
    double[] pressureLOG = null;
    double[][] ROG = null;
    double[][] DROGDP;
    double[][] DROHLDP;
    double[][] DROGDT;
    double[][] DROHLDT;
    double[][] ROL;
    double[][] CPG;
    double[][] CPHL;
    double[][] HG;
    double[][] HHL;
    double[][] TCG;
    double[][] TCHL;
    double[][] VISG;
    double[][] VISHL;
    double[][] SIGGHL;
    double[][] SEG;
    double[][] SEHL;
    double[][] RS;
    double TC;
    double PC;

    public OLGApropertyTableGenerator(SystemInterface system) {
        this.thermoSystem = system;
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
    }

    public void setPressureRange(double minPressure, double maxPressure, int numberOfSteps) {
        this.pressures = new double[numberOfSteps];
        this.pressureLOG = new double[numberOfSteps];
        double step = (maxPressure - minPressure) / ((double)numberOfSteps * 1.0);
        for (int i = 0; i < numberOfSteps; ++i) {
            this.pressures[i] = minPressure + (double)i * step;
            this.pressureLOG[i] = this.pressures[i] * 100000.0;
        }
    }

    public void setTemperatureRange(double minTemperature, double maxTemperature, int numberOfSteps) {
        this.temperatures = new double[numberOfSteps];
        this.temperatureLOG = new double[numberOfSteps];
        double step = (maxTemperature - minTemperature) / ((double)numberOfSteps * 1.0);
        for (int i = 0; i < numberOfSteps; ++i) {
            this.temperatures[i] = minTemperature + (double)i * step;
            this.temperatureLOG[i] = this.temperatures[i] - 273.15;
        }
    }

    public void calcPhaseEnvelope() {
        try {
            this.thermoOps.calcPTphaseEnvelope();
            this.TC = this.thermoSystem.getTC() - 273.15;
            this.PC = this.thermoSystem.getPC() * 100000.0;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void run() {
        this.ROG = new double[this.pressures.length][this.temperatures.length];
        this.ROL = new double[this.pressures.length][this.temperatures.length];
        this.CPG = new double[this.pressures.length][this.temperatures.length];
        this.CPHL = new double[this.pressures.length][this.temperatures.length];
        this.HG = new double[this.pressures.length][this.temperatures.length];
        this.HHL = new double[this.pressures.length][this.temperatures.length];
        this.VISG = new double[this.pressures.length][this.temperatures.length];
        this.VISHL = new double[this.pressures.length][this.temperatures.length];
        this.TCG = new double[this.pressures.length][this.temperatures.length];
        this.TCHL = new double[this.pressures.length][this.temperatures.length];
        this.SIGGHL = new double[this.pressures.length][this.temperatures.length];
        this.SEG = new double[this.pressures.length][this.temperatures.length];
        this.SEHL = new double[this.pressures.length][this.temperatures.length];
        this.RS = new double[this.pressures.length][this.temperatures.length];
        this.DROGDP = new double[this.pressures.length][this.temperatures.length];
        this.DROHLDP = new double[this.pressures.length][this.temperatures.length];
        this.DROGDT = new double[this.pressures.length][this.temperatures.length];
        this.DROHLDT = new double[this.pressures.length][this.temperatures.length];
        for (int i = 0; i < this.pressures.length; ++i) {
            this.thermoSystem.setPressure(this.pressures[i]);
            for (int j = 0; j < this.temperatures.length; ++j) {
                this.thermoSystem.setTemperature(this.temperatures[j]);
                try {
                    this.thermoOps.TPflash();
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                this.thermoSystem.init(3);
                this.thermoSystem.initPhysicalProperties();
                if (this.thermoSystem.hasPhaseType("gas")) {
                    // empty if block
                }
                if (this.thermoSystem.hasPhaseType("oil")) {
                    // empty if block
                }
                if (this.thermoSystem.hasPhaseType("aqueous")) {
                    // empty if block
                }
                if (!this.thermoSystem.hasPhaseType("gas")) {
                    this.thermoSystem.setPhaseType(this.thermoSystem.getPhaseNumberOfPhase(PhaseType.OIL), PhaseType.GAS);
                    this.thermoSystem.init(3);
                    this.thermoSystem.initPhysicalProperties();
                }
                if (!this.thermoSystem.hasPhaseType("oil")) {
                    this.thermoSystem.setPhaseType(this.thermoSystem.getPhaseNumberOfPhase(PhaseType.GAS), PhaseType.GAS);
                    this.thermoSystem.init(3);
                    this.thermoSystem.initPhysicalProperties();
                }
                if (!this.thermoSystem.hasPhaseType("aqueous")) {
                    this.thermoSystem.setPhaseType(1, PhaseType.GAS);
                    this.thermoSystem.init(3);
                    this.thermoSystem.initPhysicalProperties();
                }
                this.ROG[i][j] = this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
                this.ROL[i][j] = this.thermoSystem.getPhase(1).getPhysicalProperties().getDensity();
                this.DROGDP[i][j] = this.thermoSystem.getPhase(0).getdrhodP();
                this.DROHLDP[i][j] = this.thermoSystem.getPhase(1).getdrhodP();
                this.DROGDT[i][j] = this.thermoSystem.getPhase(0).getdrhodT();
                this.DROHLDT[i][j] = this.thermoSystem.getPhase(1).getdrhodT();
                this.CPG[i][j] = this.thermoSystem.getPhase(0).getCp();
                this.CPHL[i][j] = this.thermoSystem.getPhase(1).getCp();
                this.HG[i][j] = this.thermoSystem.getPhase(0).getEnthalpy();
                this.HHL[i][j] = this.thermoSystem.getPhase(1).getEnthalpy();
                this.TCG[i][j] = this.thermoSystem.getPhase(0).getPhysicalProperties().getConductivity();
                this.TCHL[i][j] = this.thermoSystem.getPhase(1).getPhysicalProperties().getConductivity();
                this.VISG[i][j] = this.thermoSystem.getPhase(0).getPhysicalProperties().getViscosity();
                this.VISHL[i][j] = this.thermoSystem.getPhase(1).getPhysicalProperties().getViscosity();
                this.SIGGHL[i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(0, 1);
                this.SEG[i][j] = this.thermoSystem.getPhase(0).getEntropy();
                this.SEHL[i][j] = this.thermoSystem.getPhase(1).getEntropy();
                this.RS[i][j] = this.thermoSystem.getPhase(0).getBeta();
            }
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        logger.info("TC " + this.TC + " PC " + this.PC);
        for (int i = 0; i < this.pressures.length; ++i) {
            this.thermoSystem.setPressure(this.pressures[i]);
            for (int j = 0; j < this.temperatures.length; ++j) {
                logger.info("pressure " + this.pressureLOG[i] + " temperature " + this.temperatureLOG[j] + " ROG " + this.ROG[i][j] + " ROL " + this.ROL[i][j]);
            }
        }
        this.writeOLGAinpFile("");
    }

    public void writeOLGAinpFile(String filename) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("c:/temp/filename.txt"), "utf-8"));){
            writer.write("PRESSURE= (");
            for (int i = 0; i < this.pressures.length; ++i) {
                this.thermoSystem.setPressure(this.pressures[i]);
                for (int j = 0; j < this.temperatures.length; ++j) {
                    this.thermoSystem.setTemperature(this.temperatures[j]);
                    writer.write(this.ROG[i][j] + ",");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

