/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.unit;

import neqsim.util.exception.InvalidInputException;
import neqsim.util.unit.BaseUnit;

public class PressureUnit
extends BaseUnit {
    private static final long serialVersionUID = 1000L;

    public PressureUnit(double value, String unit) {
        super(value, unit);
    }

    public double getConversionFactor(String name) {
        double conversionFactor = 1.0;
        switch (name) {
            case "bara": {
                conversionFactor = 1.0;
                break;
            }
            case "bar": {
                conversionFactor = 1.0;
                break;
            }
            case "barg": {
                conversionFactor = 1.0;
                break;
            }
            case "psi": {
                conversionFactor = 0.0689475729317831;
                break;
            }
            case "psia": {
                conversionFactor = 0.0689475729317831;
                break;
            }
            case "psig": {
                conversionFactor = 0.0689475729317831;
                break;
            }
            case "Pa": {
                conversionFactor = 1.0E-5;
                break;
            }
            case "kPa": {
                conversionFactor = 0.01;
                break;
            }
            case "MPa": {
                conversionFactor = 10.0;
                break;
            }
            case "atm": {
                conversionFactor = 1.0;
                break;
            }
            default: {
                throw new RuntimeException(new InvalidInputException(this, "getConversionFactor", name, "unit not supproted"));
            }
        }
        return conversionFactor;
    }

    @Override
    public double getValue(double val, String fromunit, String tounit) {
        this.invalue = val;
        return this.getConversionFactor(fromunit) / this.getConversionFactor(tounit) * this.invalue;
    }

    @Override
    public double getValue(String tounit) {
        if (tounit.equals("barg")) {
            return this.getConversionFactor(this.inunit) / this.getConversionFactor("bara") * this.invalue - 1.01325;
        }
        if (tounit.equals("psig")) {
            return this.getConversionFactor(this.inunit) / this.getConversionFactor("bara") * this.invalue * 14.503773773 - 14.7;
        }
        if (this.inunit.equals("barg")) {
            return this.getConversionFactor(this.inunit) / this.getConversionFactor("bara") * this.invalue + 1.01325;
        }
        if (tounit.equals("atm")) {
            return this.getConversionFactor(this.inunit) / this.getConversionFactor("bara") * this.invalue / 1.01325;
        }
        if (this.inunit.equals("atm")) {
            return this.getConversionFactor(this.inunit) / this.getConversionFactor("bara") * this.invalue * 1.01325;
        }
        return this.getConversionFactor(this.inunit) / this.getConversionFactor(tounit) * this.invalue;
    }
}

