/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.unit;

import neqsim.util.exception.InvalidInputException;
import neqsim.util.unit.BaseUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RateUnit
extends BaseUnit {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(RateUnit.class);
    double molarmass = 0.0;
    double stddens = 0.0;
    double boilp = 0.0;

    public RateUnit(double value, String name, double molarmass, double stddens, double boilp) {
        super(value, name);
        this.molarmass = molarmass;
        this.stddens = stddens;
        this.boilp = boilp;
    }

    public double getConversionFactor(String name) {
        double mol_m3 = 0.0;
        double mol_Sm3 = 42.29254601480821;
        mol_m3 = this.boilp < 25.0 ? 42.29254601480821 : 1.0 / this.molarmass * this.stddens * 1000.0;
        if (name.equals("mole/sec") || name.equals("mol/sec") || name.equals("SI") || name.equals("mol")) {
            this.factor = 1.0;
        } else if (name.equals("Nlitre/min")) {
            this.factor = 0.016666666666666666 * mol_m3 / 1000.0;
        } else if (name.equals("Nlitre/sec")) {
            this.factor = mol_m3 / 1000.0;
        } else if (name.equals("Am3/hr")) {
            this.factor = 1.0 / this.molarmass / 3600.0 * this.stddens;
        } else if (name.equals("Am3/day")) {
            this.factor = 1.0 / this.molarmass / 86400.0 * this.stddens;
        } else if (name.equals("Am3/min")) {
            this.factor = 1.0 / this.molarmass / 60.0 * this.stddens;
        } else if (name.equals("Am3/sec")) {
            this.factor = 1.0 / this.molarmass * this.stddens;
        } else if (name.equals("kg/sec")) {
            this.factor = 1.0 / this.molarmass;
        } else if (name.equals("kg/min")) {
            this.factor = 0.016666666666666666 / this.molarmass;
        } else if (name.equals("kg/hr")) {
            this.factor = 1.0 / this.molarmass / 3600.0;
        } else if (name.equals("kg/day")) {
            this.factor = 1.0 / this.molarmass / 86400.0;
        } else if (name.equals("Sm^3/sec") | name.equals("Sm3/sec")) {
            this.factor = mol_Sm3;
        } else if (name.equals("Sm^3/min") | name.equals("Sm3/min")) {
            this.factor = 0.016666666666666666 * mol_Sm3;
        } else if (name.equals("Sm^3/hr") | name.equals("Sm3/hr")) {
            this.factor = 2.777777777777778E-4 * mol_Sm3;
        } else if (name.equals("Sm^3/day") || name.equals("Sm3/day")) {
            this.factor = 1.1574074074074073E-5 * mol_Sm3;
        } else if (name.equals("MSm^3/day") || name.equals("MSm3/day")) {
            this.factor = 1000000.0 * mol_Sm3 / 86400.0;
        } else if (name.equals("MSm^3/hr") || name.equals("MSm3/hr")) {
            this.factor = 1000000.0 * mol_Sm3 / 3600.0;
        } else if (name.equals("idSm3/sec")) {
            this.factor = 1.0 / this.molarmass * this.stddens;
        } else if (name.equals("idSm3/min")) {
            this.factor = 1.0 / this.molarmass / 60.0 * this.stddens;
        } else if (name.equals("idSm3/hr")) {
            this.factor = 1.0 / this.molarmass / 3600.0 * this.stddens;
        } else if (name.equals("idSm3/day")) {
            this.factor = 1.0 / this.molarmass / 86400.0 * this.stddens;
        } else if (name.equals("gallons/min")) {
            this.factor = 1.0 / this.molarmass / 60.0 * this.stddens / 10.0 * 3.78541178;
        } else {
            throw new RuntimeException(new InvalidInputException(this, "getConversionFactor", "unit", "not supported"));
        }
        return this.factor;
    }

    @Override
    public double getSIvalue() {
        return this.getConversionFactor(this.inunit) / this.getConversionFactor("SI") * this.invalue;
    }

    @Override
    public double getValue(String tounit) {
        return this.getConversionFactor(this.inunit) / this.getConversionFactor(tounit) * this.invalue;
    }
}

