/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.reactivefilmmodel.enhancementfactor;

import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundaryInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.reactivefilmmodel.enhancementfactor.EnhancementFactor;

public class EnhancementFactorAlg
extends EnhancementFactor {
    public EnhancementFactorAlg(FluidBoundaryInterface fluidBoundary) {
        super(fluidBoundary);
    }

    @Override
    public void calcEnhancementVec(int phaseNum) {
        double hatta = 0.0;
        for (int j = 0; j < this.fluidBoundary.getBulkSystem().getPhase(phaseNum).getNumberOfComponents(); ++j) {
            if (this.fluidBoundary.getBulkSystem().getPhase(phaseNum).getComponent(j).getName().equals("CO2") && phaseNum == 1) {
                this.enhancementVec[j] = this.fluidBoundary.getBulkSystem().getChemicalReactionOperations().solveKinetics(phaseNum, this.fluidBoundary.getInterphaseSystem().getPhase(phaseNum), j);
                this.hattaNumber[j] = hatta = Math.sqrt(this.enhancementVec[j] * this.fluidBoundary.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getEffectiveDiffusionCoefficient(j)) / this.fluidBoundary.getEffectiveMassTransferCoefficient(phaseNum, j);
                double phi = this.fluidBoundary.getBulkSystem().getChemicalReactionOperations().getKinetics().getPhiInfinite();
                if (hatta > 2.0) {
                    this.enhancementVec[j] = 1.0 + (phi - 1.0) * (1.0 - Math.exp(-(hatta - 1.0) / (phi - 1.0)));
                    continue;
                }
                this.enhancementVec[j] = 1.0 + (phi - 1.0) * (1.0 - Math.exp(-1.0 / (phi - 1.0))) * Math.exp(1.0 - 2.0 / hatta);
                continue;
            }
            this.enhancementVec[j] = 1.0;
        }
    }
}

