/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.compressor.CompressorChart;
import neqsim.process.equipment.compressor.SafeSplineSurgeCurve;

public class CompressorChartGenerator {
    private final Compressor compressor;

    public CompressorChartGenerator(Compressor inpCompressor) {
        this.compressor = inpCompressor;
    }

    public CompressorChart generateCompressorChart(String generationOption) {
        CompressorChart compChart = new CompressorChart();
        boolean isNormalCurves = "normal curves".equalsIgnoreCase(generationOption);
        double[] chartConditions = new double[]{this.compressor.getOutletStream().getFluid().getMolarMass("kg/mol")};
        double refSpeed = this.compressor.getSpeed();
        double[] speed = new double[]{refSpeed};
        double minSpeed = isNormalCurves ? refSpeed * 0.75 : refSpeed / 2.0;
        double maxSpeed = isNormalCurves ? refSpeed * 1.05 : refSpeed * 2.0;
        double refFlow = this.compressor.getInletStream().getFlowRate("m3/hr");
        double[][] flow = this.generateFlowData(refFlow, isNormalCurves);
        double minFlow = refFlow / 2.0;
        double maxFlow = refFlow * 2.0;
        double refHead = this.compressor.getPolytropicFluidHead();
        double[][] head = this.generateHeadData(refHead, isNormalCurves);
        double[][] polyEff = this.generateEfficiencyData(this.compressor.getPolytropicEfficiency());
        compChart.setUseCompressorChart(true);
        compChart.setHeadUnit("kJ/kg");
        compChart.setCurves(chartConditions, speed, flow, head, polyEff);
        SafeSplineSurgeCurve surgeCurve = this.generateSurgeCurve(compChart, refFlow, refSpeed, minFlow, maxFlow, minSpeed, maxSpeed, isNormalCurves);
        compChart.setSurgeCurve(surgeCurve);
        return compChart;
    }

    private double[][] generateFlowData(double refFlow, boolean isNormalCurves) {
        double[][] flow = new double[1][3];
        if (isNormalCurves) {
            flow[0][0] = refFlow / 1.3;
            flow[0][1] = refFlow;
            flow[0][2] = refFlow * 2.5 / 1.3;
        } else {
            flow[0][0] = refFlow * 0.7;
            flow[0][1] = refFlow;
            flow[0][2] = refFlow * 1.43;
        }
        return flow;
    }

    private double[][] generateHeadData(double refHead, boolean isNormalCurves) {
        double[][] head = new double[1][3];
        if (isNormalCurves) {
            head[0][0] = refHead * 1.2;
            head[0][1] = refHead;
            head[0][2] = refHead * 1.2 * 0.4;
        } else {
            head[0][0] = refHead * 1.5;
            head[0][1] = refHead;
            head[0][2] = refHead * 0.5;
        }
        return head;
    }

    private double[][] generateEfficiencyData(double refEfficiency) {
        double[][] polyEff = new double[1][3];
        polyEff[0][0] = refEfficiency * 100.0 * 0.9;
        polyEff[0][1] = refEfficiency * 100.0;
        polyEff[0][2] = refEfficiency * 100.0 * 0.85;
        return polyEff;
    }

    private SafeSplineSurgeCurve generateSurgeCurve(CompressorChart compChart, double refFlow, double refSpeed, double minFlow, double maxFlow, double minSpeed, double maxSpeed, boolean isNormalCurves) {
        double minSurgeFlow = 0.7 * refFlow;
        double refSurgeFlow = isNormalCurves ? refFlow / 1.3 : 0.8 * refFlow;
        double maxSurgeFlow = 0.9 * refFlow;
        double headSurgeMin = compChart.getPolytropicHead(minFlow, minSpeed);
        double headSurgeRef = compChart.getPolytropicHead(refSurgeFlow, refSpeed);
        double headSurgeMax = compChart.getPolytropicHead(maxSurgeFlow, maxSpeed);
        SafeSplineSurgeCurve surgeCurve = new SafeSplineSurgeCurve();
        surgeCurve.setCurve(new double[3], new double[]{minSurgeFlow, refSurgeFlow, maxSurgeFlow}, new double[]{headSurgeMin, headSurgeRef, headSurgeMax});
        return surgeCurve;
    }
}

