/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.expander;

import java.util.UUID;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.expander.ExpanderInterface;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class Expander
extends Compressor
implements ExpanderInterface {
    private static final long serialVersionUID = 1000L;

    public Expander(String name) {
        super(name);
    }

    public Expander(String name, StreamInterface inletStream) {
        super(name, inletStream);
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.getThermoSystem());
        thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double hinn = this.getThermoSystem().getEnthalpy();
        double entropy = this.getThermoSystem().getEntropy();
        this.inletEnthalpy = hinn;
        double hout = hinn;
        if (this.usePolytropicCalc) {
            int numbersteps = 40;
            double dp = (this.pressure - this.getThermoSystem().getPressure()) / (1.0 * (double)numbersteps);
            for (int i = 0; i < numbersteps; ++i) {
                entropy = this.getThermoSystem().getEntropy();
                double hinn_loc = this.getThermoSystem().getEnthalpy();
                this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + dp);
                thermoOps.PSflash(entropy);
                hout = hinn_loc + (this.getThermoSystem().getEnthalpy() - hinn_loc) * this.polytropicEfficiency;
                thermoOps.PHflash(hout, 0);
            }
            this.dH = hout - hinn;
        } else {
            this.getThermoSystem().setPressure(this.pressure);
            thermoOps.PSflash(entropy);
            if (!this.powerSet) {
                this.dH = (this.getThermoSystem().getEnthalpy() - hinn) * this.isentropicEfficiency;
            }
            hout = hinn + this.dH;
            this.isentropicEfficiency = this.dH / (this.getThermoSystem().getEnthalpy() - hinn);
            this.dH = hout - hinn;
            thermoOps.PHflash(hout, 0);
        }
        if (this.isSetEnergyStream()) {
            this.energyStream.setDuty(-this.dH);
        }
        this.outStream.setThermoSystem(this.getThermoSystem());
        this.setCalculationIdentifier(id);
    }
}

