/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.flare;

import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.unit.PowerUnit;

public class Flare
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    private double heatDuty = 0.0;
    private double co2Emission = 0.0;

    public Flare(String name) {
        super(name);
    }

    public Flare(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    @Override
    public void setInletStream(StreamInterface stream) {
        this.inStream = stream;
        this.outStream = new Stream(stream.getName() + "_flareout", stream.getFluid().clone());
    }

    @Override
    public void run(UUID id) {
        SystemInterface thermoSystem = this.inStream.getThermoSystem().clone();
        double flowSm3sec = this.inStream.getFlowRate("Sm3/sec");
        this.heatDuty = this.inStream.LCV() * flowSm3sec;
        double molesTotalPerSec = this.inStream.getFlowRate("mole/sec");
        double molesCarbonPerSec = 0.0;
        for (int i = 0; i < thermoSystem.getNumberOfComponents(); ++i) {
            double moleFrac = thermoSystem.getComponent(i).getz();
            double molesCompPerSec = moleFrac * molesTotalPerSec;
            double nC = thermoSystem.getComponent(i).getElements().getNumberOfElements("C");
            molesCarbonPerSec += molesCompPerSec * nC;
        }
        this.co2Emission = molesCarbonPerSec * 0.04401;
        this.outStream.setThermoSystem(thermoSystem);
        this.setCalculationIdentifier(id);
    }

    public double getHeatDuty() {
        return this.heatDuty;
    }

    public double getHeatDuty(String unit) {
        PowerUnit conv = new PowerUnit(this.heatDuty, "W");
        return conv.getValue(unit);
    }

    public double getCO2Emission() {
        return this.co2Emission;
    }

    public double getCO2Emission(String unit) {
        switch (unit) {
            case "kg/hr": {
                return this.co2Emission * 3600.0;
            }
            case "kg/day": {
                return this.co2Emission * 3600.0 * 24.0;
            }
        }
        return this.co2Emission;
    }
}

