/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.heatexchanger;

import java.util.UUID;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.util.humidair.HumidAir;

public class AirCooler
extends Cooler {
    private static final long serialVersionUID = 1000L;
    private double airInletTemperature = 298.15;
    private double airOutletTemperature = 308.15;
    private double relativeHumidity = 0.6;
    private double pressure = 101325.0;
    private double airMassFlow = 0.0;
    private double airVolumeFlow = 0.0;

    public AirCooler(String name) {
        super(name);
    }

    public AirCooler(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    public void setAirInletTemperature(double temperature, String unit) {
        this.airInletTemperature = unit.equalsIgnoreCase("C") ? temperature + 273.15 : temperature;
    }

    public void setAirOutletTemperature(double temperature, String unit) {
        this.airOutletTemperature = unit.equalsIgnoreCase("C") ? temperature + 273.15 : temperature;
    }

    public void setRelativeHumidity(double rh) {
        this.relativeHumidity = rh;
    }

    @Override
    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public double getAirMassFlow() {
        return this.airMassFlow;
    }

    public double getAirVolumeFlow() {
        return this.airVolumeFlow;
    }

    private void calcAirFlow(double duty) {
        double W = HumidAir.humidityRatioFromRH(this.airInletTemperature, this.pressure, this.relativeHumidity);
        double hin = HumidAir.enthalpy(this.airInletTemperature, W);
        double hout = HumidAir.enthalpy(this.airOutletTemperature, W);
        double dh = hout - hin;
        if (Math.abs(dh) < 1.0E-6) {
            this.airMassFlow = 0.0;
            this.airVolumeFlow = 0.0;
            return;
        }
        this.airMassFlow = duty / (dh * 1000.0);
        double Mda = 0.028965;
        double Mw = 0.01801528;
        double volumePerKgDryAir = (1.0 / Mda + W / Mw) * 8.314 * this.airInletTemperature / this.pressure;
        this.airVolumeFlow = this.airMassFlow * volumePerKgDryAir;
    }

    @Override
    public void run(UUID id) {
        super.run(id);
        double duty = -this.getDuty();
        this.calcAirFlow(duty);
    }
}

