/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.heatexchanger;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.heatexchanger.MultiStreamHeatExchangerInterface;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.MultiStreamHeatExchanger2Response;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiStreamHeatExchanger2
extends Heater
implements MultiStreamHeatExchangerInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(MultiStreamHeatExchanger2.class);
    SystemInterface thermoSystem;
    private double tolerance = 0.001;
    private int maxIterations = 1000;
    private double jacobiDelta = 1.0E-4;
    private static final String SINGULAR_JACOBIAN_MSG = "Jacobian determinant is zero";
    private final double extremeEnergy = 0.3;
    private final double extremeUA = 2.0;
    private final int extremeAttempts = 1000;
    private List<Double> prevOutletTemps = null;
    private int stallCounter = 0;
    private final int stallLimit = 50;
    private double localRange = 5.0;
    private double damping = 1.0;
    private Double approachTemperature = 5.0;
    private Double UA = null;
    private double hotLoad;
    private double coldLoad;
    private Map<String, List<Map<String, Object>>> compositeCurvePoints = new HashMap<String, List<Map<String, Object>>>();
    private List<Double> hInlet = new ArrayList<Double>();
    private List<SystemInterface> fluidInlet = new ArrayList<SystemInterface>();
    private List<Double> allLoad = new ArrayList<Double>();
    private List<Double> hotTempAll = new ArrayList<Double>();
    private List<Double> coldTempAll = new ArrayList<Double>();
    private List<Double> tempDiff = new ArrayList<Double>();
    private List<StreamInterface> inStreams = new ArrayList<StreamInterface>();
    private List<StreamInterface> outStreams = new ArrayList<StreamInterface>();
    private List<String> streamTypes = new ArrayList<String>();
    private List<Double> inletTemps = new ArrayList<Double>();
    private List<Double> outletTemps = new ArrayList<Double>();
    private List<Object> unknownOutlets = new ArrayList<Object>();
    private List<Double> pressures = new ArrayList<Double>();
    private List<Double> massFlows = new ArrayList<Double>();
    private List<Double> streamLoads = new ArrayList<Double>();

    public MultiStreamHeatExchanger2(String name) {
        super(name);
    }

    @Override
    public void addInStream(StreamInterface inStream) {
    }

    public void addInStreamMSHE(StreamInterface inStream, String streamType, Double outletTemp) {
        this.inStreams.add(inStream);
        StreamInterface outStream = inStream.clone();
        this.outStreams.add(outStream);
        this.streamTypes.add(streamType);
        this.inletTemps.add(inStream.getFluid().getTemperature("C"));
        this.outletTemps.add(outletTemp);
        this.unknownOutlets.add(outletTemp == null);
        this.pressures.add(inStream.getFluid().getPressure("bara"));
        this.massFlows.add(inStream.getFlowRate("kg/sec"));
        this.streamLoads.add(0.0);
    }

    public void setTemperatureApproach(double temperatureApproach) {
        this.approachTemperature = temperatureApproach;
    }

    @Override
    public void setUAvalue(double UAvalue) {
        this.UA = UAvalue;
    }

    @Override
    public void run(UUID id) {
        for (int i = 0; i < this.inStreams.size(); ++i) {
            SystemInterface fluid = this.inStreams.get(i).getFluid().clone();
            fluid.initThermoProperties();
            this.hInlet.add(fluid.getEnthalpy("kJ/kg"));
            this.fluidInlet.add(fluid);
        }
        int undefinedCount = 0;
        for (Double temp : this.outletTemps) {
            if (temp != null) continue;
            ++undefinedCount;
        }
        if (undefinedCount == 0) {
            logger.debug("No Unknown Temperatures to Solve");
        } else if (undefinedCount == 1) {
            this.oneUnknown();
        } else if (undefinedCount == 2) {
            this.twoUnknowns();
        } else if (undefinedCount == 3) {
            this.threeUnknowns();
        } else {
            logger.debug("Too Many Unknown Temperatures");
        }
        for (int i = 0; i < this.outStreams.size(); ++i) {
            this.outStreams.get(i).setFluid(this.inStreams.get(i).getFluid().clone());
            this.outStreams.get(i).setTemperature(this.outletTemps.get(i), "C");
            this.outStreams.get(i).setPressure(this.inStreams.get(i).getPressure("bara"), "bara");
            this.outStreams.get(i).run();
            logger.debug("Outlet temps before solving: " + String.valueOf(this.outletTemps));
            logger.debug("Unknown flags: " + String.valueOf(this.unknownOutlets));
        }
    }

    public void oneUnknown() {
        ArrayList<Integer> unknownIndices = new ArrayList<Integer>();
        int idx = -1;
        for (int i = 0; i < this.unknownOutlets.size(); ++i) {
            if (!((Boolean)this.unknownOutlets.get(i)).booleanValue()) continue;
            idx = i;
            unknownIndices.add(i);
            break;
        }
        this.outletTemps.set(idx, this.initializeOutletGuess(idx));
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            double[] delta;
            boolean stalled = this.stallDetection(unknownIndices);
            this.resetOfExtremesAndStalls(unknownIndices, stalled, false);
            double[] residuals = this.residualFunctionOneUnknown();
            if (Math.abs(residuals[0]) < this.tolerance) {
                return;
            }
            double[][] jacobian = this.numericalJacobiOneUnknown(unknownIndices);
            try {
                delta = this.linearSystemOneUnknown(jacobian, residuals);
            }
            catch (ArithmeticException e) {
                throw new RuntimeException("Jacobian is singular or poorly conditioned.");
            }
            this.outletTemps.set(idx, this.outletTemps.get(idx) - this.damping * delta[0]);
        }
        throw new RuntimeException("oneUnknown(): Failed to converge after maxIterations.");
    }

    private double[] residualFunctionOneUnknown() {
        return new double[]{this.energyDiff()};
    }

    private double[][] numericalJacobiOneUnknown(List<Integer> unknownIndices) {
        ArrayList<Double> baseTemps = new ArrayList<Double>();
        for (int idx : unknownIndices) {
            baseTemps.add(this.outletTemps.get(idx));
        }
        double[] baseResiduals = this.residualFunctionOneUnknown();
        ArrayList<double[]> J = new ArrayList<double[]>();
        for (int i = 0; i < unknownIndices.size(); ++i) {
            int idx = unknownIndices.get(i);
            this.outletTemps.set(idx, (Double)baseTemps.get(i) + this.jacobiDelta);
            double[] perturbed = this.residualFunctionOneUnknown();
            double[] column = new double[]{(perturbed[0] - baseResiduals[0]) / this.jacobiDelta};
            J.add(column);
            this.outletTemps.set(idx, (Double)baseTemps.get(i));
        }
        double[][] jacobian = new double[1][J.size()];
        for (int i = 0; i < J.size(); ++i) {
            jacobian[0][i] = ((double[])J.get(i))[0];
        }
        return jacobian;
    }

    private double[] linearSystemOneUnknown(double[][] A, double[] b) {
        if (Math.abs(A[0][0]) < 1.0E-12) {
            throw new ArithmeticException(SINGULAR_JACOBIAN_MSG);
        }
        return new double[]{b[0] / A[0][0]};
    }

    public void twoUnknowns() {
        ArrayList<Integer> unknownIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.unknownOutlets.size(); ++i) {
            if (!((Boolean)this.unknownOutlets.get(i)).booleanValue()) continue;
            unknownIndices.add(i);
            this.outletTemps.set(i, this.initializeOutletGuess(i));
        }
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            double[] delta;
            boolean stalled = this.stallDetection(unknownIndices);
            this.resetOfExtremesAndStalls(unknownIndices, stalled, false);
            double[] residuals = this.residualFunctionTwoUnknowns();
            if (Math.max(Math.abs(residuals[0]), Math.abs(residuals[1])) < this.tolerance) {
                logger.debug("\u2713 OK With Streams" + String.valueOf(this.outletTemps));
                return;
            }
            double[][] jacobian = this.numericalJacobiTwoUnknowns(unknownIndices);
            try {
                delta = this.linearSystemTwoUnknowns(jacobian, residuals);
            }
            catch (ArithmeticException e) {
                throw new RuntimeException("Jacobian is singular or poorly conditioned.");
            }
            for (int i = 0; i < unknownIndices.size(); ++i) {
                int idx = (Integer)unknownIndices.get(i);
                this.outletTemps.set(idx, this.outletTemps.get(idx) - this.damping * delta[i]);
            }
        }
        throw new RuntimeException("twoUnknowns(): Failed to converge after maxIterations.");
    }

    private double[] residualFunctionTwoUnknowns() {
        return new double[]{this.energyDiff(), this.pinch() - this.approachTemperature};
    }

    private double[][] numericalJacobiTwoUnknowns(List<Integer> unknownIndices) {
        double[] baseTemps = new double[2];
        for (int i = 0; i < 2; ++i) {
            baseTemps[i] = this.outletTemps.get(unknownIndices.get(i));
        }
        double[] baseResiduals = this.residualFunctionTwoUnknowns();
        double[][] J = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            int idx = unknownIndices.get(i);
            this.outletTemps.set(idx, baseTemps[i] + this.jacobiDelta);
            double[] perturbed = this.residualFunctionTwoUnknowns();
            for (int j = 0; j < 2; ++j) {
                J[j][i] = (perturbed[j] - baseResiduals[j]) / this.jacobiDelta;
            }
            this.outletTemps.set(idx, baseTemps[i]);
        }
        return J;
    }

    private double[] linearSystemTwoUnknowns(double[][] A, double[] b) {
        double det = A[0][0] * A[1][1] - A[0][1] * A[1][0];
        if (Math.abs(det) < 1.0E-12) {
            double eps = 1.0E-8;
            double[] dArray = A[0];
            dArray[0] = dArray[0] + eps;
            double[] dArray2 = A[1];
            dArray2[1] = dArray2[1] + eps;
            det = A[0][0] * A[1][1] - A[0][1] * A[1][0];
            if (Math.abs(det) < 1.0E-12) {
                throw new ArithmeticException(SINGULAR_JACOBIAN_MSG);
            }
        }
        double dx = b[0] * A[1][1] - b[1] * A[0][1];
        double dy = A[0][0] * b[1] - A[1][0] * b[0];
        return new double[]{dx / det, dy / det};
    }

    public void threeUnknowns() {
        ArrayList<Integer> unknownIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.unknownOutlets.size(); ++i) {
            if (!((Boolean)this.unknownOutlets.get(i)).booleanValue()) continue;
            unknownIndices.add(i);
            this.outletTemps.set(i, this.initializeOutletGuess(i));
        }
        logger.debug("Outlet temps before solving: " + String.valueOf(this.outletTemps));
        logger.debug("Unknown flags: " + String.valueOf(this.unknownOutlets));
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            double[] delta;
            boolean stalled = this.stallDetection(unknownIndices);
            this.resetOfExtremesAndStalls(unknownIndices, stalled, true);
            double[] residuals = this.residualFunctionThreeUnknowns();
            if (Math.max(Math.max(Math.abs(residuals[0]), Math.abs(residuals[1])), Math.abs(residuals[2])) < this.tolerance) {
                return;
            }
            double[][] jacobian = this.numericalJacobiThreeUnknowns(unknownIndices);
            try {
                delta = this.linearSystemThreeUnknowns(jacobian, residuals);
            }
            catch (ArithmeticException e) {
                throw new RuntimeException("Jacobian is singular or poorly conditioned.");
            }
            for (int i = 0; i < unknownIndices.size(); ++i) {
                int idx = (Integer)unknownIndices.get(i);
                this.outletTemps.set(idx, this.outletTemps.get(idx) - this.damping * delta[i]);
            }
        }
        throw new RuntimeException("threeUnknowns(): Failed to converge after maxIterations.");
    }

    private double[] residualFunctionThreeUnknowns() {
        return new double[]{this.energyDiff(), this.pinch() - this.approachTemperature, this.calculateUA() - this.UA};
    }

    private double[][] numericalJacobiThreeUnknowns(List<Integer> unknownIndices) {
        double[] baseTemps = new double[3];
        for (int i = 0; i < 3; ++i) {
            baseTemps[i] = this.outletTemps.get(unknownIndices.get(i));
        }
        double[] baseResiduals = this.residualFunctionThreeUnknowns();
        double[][] J = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            int idx = unknownIndices.get(i);
            this.outletTemps.set(idx, baseTemps[i] + this.jacobiDelta);
            double[] perturbed = this.residualFunctionThreeUnknowns();
            for (int j = 0; j < 3; ++j) {
                J[j][i] = (perturbed[j] - baseResiduals[j]) / this.jacobiDelta;
            }
            this.outletTemps.set(idx, baseTemps[i]);
        }
        return J;
    }

    private double[] linearSystemThreeUnknowns(double[][] A, double[] b) {
        double D = A[0][0] * (A[1][1] * A[2][2] - A[1][2] * A[2][1]) - A[0][1] * (A[1][0] * A[2][2] - A[1][2] * A[2][0]) + A[0][2] * (A[1][0] * A[2][1] - A[1][1] * A[2][0]);
        if (Math.abs(D) < 1.0E-12) {
            throw new ArithmeticException(SINGULAR_JACOBIAN_MSG);
        }
        double Dx = b[0] * (A[1][1] * A[2][2] - A[1][2] * A[2][1]) - A[0][1] * (b[1] * A[2][2] - A[1][2] * b[2]) + A[0][2] * (b[1] * A[2][1] - A[1][1] * b[2]);
        double Dy = A[0][0] * (b[1] * A[2][2] - A[1][2] * b[2]) - b[0] * (A[1][0] * A[2][2] - A[1][2] * A[2][0]) + A[0][2] * (A[1][0] * b[2] - b[1] * A[2][0]);
        double Dz = A[0][0] * (A[1][1] * b[2] - b[1] * A[2][1]) - A[0][1] * (A[1][0] * b[2] - b[1] * A[2][0]) + b[0] * (A[1][0] * A[2][1] - A[1][1] * A[2][0]);
        return new double[]{Dx / D, Dy / D, Dz / D};
    }

    public double energyDiff() {
        this.hotLoad = 0.0;
        this.coldLoad = 0.0;
        for (int i = 0; i < this.inStreams.size(); ++i) {
            double hIn = this.hInlet.get(i);
            double hOut = this.enthalpyTPFlash(i, this.pressures.get(i), this.outletTemps.get(i));
            double load = (hOut - hIn) * this.massFlows.get(i);
            this.streamLoads.set(i, load);
            if ("hot".equals(this.streamTypes.get(i))) {
                this.hotLoad += load;
                continue;
            }
            if (!"cold".equals(this.streamTypes.get(i))) continue;
            this.coldLoad += load;
        }
        return this.hotLoad + this.coldLoad;
    }

    public double pinch() {
        this.compositeCurve();
        TreeSet<Double> loadSet = new TreeSet<Double>();
        for (String t : new String[]{"hot", "cold"}) {
            for (Map<String, Object> p : this.compositeCurvePoints.get(t)) {
                loadSet.add((Double)p.get("load"));
            }
        }
        ArrayList sortedLoads = new ArrayList(loadSet);
        this.allLoad = new ArrayList<Double>();
        this.allLoad.add((Double)sortedLoads.get(0));
        for (int i = 1; i < sortedLoads.size(); ++i) {
            if (!(Math.abs((Double)sortedLoads.get(i) - (Double)sortedLoads.get(i - 1)) > 0.001)) continue;
            this.allLoad.add((Double)sortedLoads.get(i));
        }
        this.hotTempAll = new ArrayList<Double>();
        this.coldTempAll = new ArrayList<Double>();
        for (double load : this.allLoad) {
            for (int j = 0; j < 2; ++j) {
                String curveKey = j == 0 ? "hot" : "cold";
                List<Map<String, Object>> points = this.compositeCurvePoints.get(curveKey);
                List<Double> target = j == 0 ? this.hotTempAll : this.coldTempAll;
                Double exact = null;
                for (Map<String, Object> p : points) {
                    if (!(Math.abs((Double)p.get("load") - load) < 0.001)) continue;
                    exact = (Double)p.get("temperature");
                    break;
                }
                target.add(exact != null ? exact.doubleValue() : this.interpolateTemperature(points, load));
            }
        }
        this.tempDiff = new ArrayList<Double>();
        for (int i = 0; i < this.hotTempAll.size(); ++i) {
            this.tempDiff.add(this.hotTempAll.get(i) - this.coldTempAll.get(i));
        }
        double minDT = Collections.min(this.tempDiff);
        logger.debug("Minimum Approach Temperature = {}", (Object)minDT);
        return minDT;
    }

    public double calculateUA() {
        double UAvalue = 0.0;
        this.compositeCurve();
        this.pinch();
        for (int i = 1; i < this.allLoad.size(); ++i) {
            double UAinterval;
            double LMTD;
            double HIn = this.hotTempAll.get(i - 1);
            double CIn = this.coldTempAll.get(i - 1);
            double HOut = this.hotTempAll.get(i);
            double COut = this.coldTempAll.get(i);
            double deltaT1 = HIn - CIn;
            double deltaT2 = HOut - COut;
            double deltaQ = this.allLoad.get(i) - this.allLoad.get(i - 1);
            if (Math.abs(deltaT1 - deltaT2) < 1.0E-4) {
                LMTD = (deltaT1 + deltaT2) / 2.0;
                UAinterval = deltaQ / LMTD;
            } else {
                LMTD = (deltaT1 - deltaT2) / Math.log(deltaT1 / deltaT2);
                UAinterval = LMTD < 0.01 ? 0.0 : 1000.0 * deltaQ / LMTD;
            }
            UAvalue += UAinterval;
        }
        return UAvalue;
    }

    private double enthalpyTPFlash(int index, double pressure, double temperature) {
        SystemInterface thermoSystem = this.fluidInlet.get(index);
        thermoSystem.setPressure(pressure, "bara");
        thermoSystem.setTemperature(temperature, "C");
        ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem);
        testOps.TPflash();
        thermoSystem.initThermoProperties();
        return thermoSystem.getEnthalpy("kJ/kg");
    }

    public Map<String, List<Map<String, Object>>> compositeCurve() {
        this.compositeCurvePoints = new HashMap<String, List<Map<String, Object>>>();
        for (String t : new String[]{"hot", "cold"}) {
            HashSet<Double> tempSet = new HashSet<Double>();
            for (int i = 0; i < this.streamTypes.size(); ++i) {
                if (!t.equals(this.streamTypes.get(i))) continue;
                tempSet.add(this.inletTemps.get(i));
                tempSet.add(this.outletTemps.get(i));
            }
            ArrayList tempPoints = new ArrayList(tempSet);
            Collections.sort(tempPoints);
            double minTemp = Double.MAX_VALUE;
            for (int i = 0; i < this.streamTypes.size(); ++i) {
                double candidate;
                if (!t.equals(this.streamTypes.get(i)) || !((candidate = (t.equals("hot") ? this.outletTemps.get(i) : this.inletTemps.get(i)).doubleValue()) < minTemp)) continue;
                minTemp = candidate;
            }
            if (minTemp == Double.MAX_VALUE && !tempPoints.isEmpty()) {
                minTemp = (Double)tempPoints.get(0);
            }
            double cumulativeLoad = 0.0;
            ArrayList curveData = new ArrayList();
            HashMap<String, Double> initialPoint = new HashMap<String, Double>();
            initialPoint.put("temperature", minTemp);
            initialPoint.put("load", 0.0);
            curveData.add(initialPoint);
            for (int p = 0; p < tempPoints.size() - 1; ++p) {
                double tStart = (Double)tempPoints.get(p);
                double tEnd = (Double)tempPoints.get(p + 1);
                double intervalLoad = 0.0;
                for (int j = 0; j < this.streamTypes.size(); ++j) {
                    if (!t.equals(this.streamTypes.get(j))) continue;
                    double inlet = this.inletTemps.get(j);
                    double outlet = this.outletTemps.get(j);
                    double low = Math.min(inlet, outlet);
                    double high = Math.max(inlet, outlet);
                    if (!(tStart >= low) || !(tEnd <= high)) continue;
                    intervalLoad += this.intervalLoad(j, tStart, tEnd);
                }
                HashMap<String, Double> point = new HashMap<String, Double>();
                point.put("temperature", tEnd);
                point.put("load", cumulativeLoad += intervalLoad);
                curveData.add(point);
            }
            this.compositeCurvePoints.put(t, curveData);
        }
        return this.compositeCurvePoints;
    }

    private double initializeOutletGuess(int i) {
        String type = this.streamTypes.get(i);
        double inletTemp = this.inletTemps.get(i);
        if ("hot".equals(type)) {
            return inletTemp - this.approachTemperature;
        }
        return inletTemp + this.approachTemperature;
    }

    private double intervalLoad(int i, double tempStart, double tempEnd) {
        double deltaT = Math.abs(tempEnd - tempStart);
        double fullDeltaT = Math.abs(this.inletTemps.get(i) - this.outletTemps.get(i));
        if (fullDeltaT < 1.0E-8) {
            return 0.0;
        }
        double interpolationFactor = deltaT / fullDeltaT;
        return Math.abs(this.streamLoads.get(i) * interpolationFactor);
    }

    private double calculateIntervalTemp(double loadStart, double targetLoad, double loadEnd, double tempStart, double tempEnd) {
        double factor = Math.abs(targetLoad - loadStart) / Math.abs(loadEnd - loadStart);
        return tempStart + (tempEnd - tempStart) * factor;
    }

    private double interpolateTemperature(List<Map<String, Object>> points, double load) {
        ArrayList<Map<String, Object>> below = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> above = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> point : points) {
            double l = (Double)point.get("load");
            if (l < load) {
                below.add(point);
            }
            if (!(l > load)) continue;
            above.add(point);
        }
        if (below.isEmpty()) {
            return (Double)((Map)above.get(0)).get("temperature");
        }
        if (above.isEmpty()) {
            return (Double)((Map)below.get(below.size() - 1)).get("temperature");
        }
        double lo = (Double)((Map)below.get(below.size() - 1)).get("load");
        double hi = (Double)((Map)above.get(0)).get("load");
        double tLo = (Double)((Map)below.get(below.size() - 1)).get("temperature");
        double tHi = (Double)((Map)above.get(0)).get("temperature");
        return this.calculateIntervalTemp(lo, load, hi, tLo, tHi);
    }

    private void resetOfExtremesAndStalls(List<Integer> unknownIndices, boolean localMin, boolean UATest) {
        int attempt = 0;
        ArrayList<Object> msgs = new ArrayList<Object>();
        while (attempt < 1000) {
            ++attempt;
            msgs.clear();
            boolean directionOk = true;
            boolean energyOk = true;
            boolean heatFeasible = true;
            for (int i : unknownIndices) {
                double inT = this.inletTemps.get(i);
                double outT = this.outletTemps.get(i);
                String type = this.streamTypes.get(i);
                if (type.equals("hot") && outT >= inT) {
                    directionOk = false;
                    msgs.add("hot outlet \u2265 inlet");
                    continue;
                }
                if (!type.equals("cold") || !(outT <= inT)) continue;
                directionOk = false;
                msgs.add("cold outlet \u2264 inlet");
            }
            if (directionOk) {
                try {
                    this.energyDiff();
                    double imbalance = Math.abs(this.hotLoad / this.coldLoad);
                    boolean bl = energyOk = 0.7 <= imbalance && imbalance <= 1.3;
                    if (!energyOk) {
                        msgs.add(String.format("energy ratio = %.3f", imbalance));
                    }
                }
                catch (Exception e) {
                    energyOk = false;
                    msgs.add("energyDiff() raised " + e.getClass().getSimpleName());
                }
            } else {
                energyOk = false;
            }
            if (directionOk && energyOk) {
                this.pinch();
                for (int i = 1; i < this.allLoad.size(); ++i) {
                    double dT1 = this.hotTempAll.get(i - 1) - this.coldTempAll.get(i - 1);
                    double dT2 = this.hotTempAll.get(i) - this.coldTempAll.get(i);
                    if (!(dT1 <= this.tolerance) && !(dT2 <= this.tolerance)) continue;
                    heatFeasible = false;
                    msgs.add(String.format("segment %d: \u0394T1=%.2f \u00b0C, \u0394T2=%.2f \u00b0C (must be > 0)", i, dT1, dT2));
                }
            } else {
                heatFeasible = false;
            }
            boolean uaOk = true;
            if (UATest && directionOk && energyOk && heatFeasible) {
                double uaVal = this.calculateUA();
                double uaTol = this.UA * 2.0;
                boolean bl = uaOk = Math.abs(uaVal - this.UA) < uaTol;
                if (!uaOk) {
                    msgs.add(String.format("UA = %.2f (target %.2f \u00b1 %.2f)", uaVal, this.UA, uaTol));
                }
            } else {
                uaOk = false;
            }
            if (directionOk && energyOk && heatFeasible && (!UATest || uaOk) && !localMin) {
                logger.debug("\u2713 No reset on attempt " + attempt);
                logger.debug("With Streams " + String.valueOf(this.outletTemps));
                localMin = false;
                return;
            }
            logger.debug("\u2717 reset on attempt " + attempt + ": " + String.join((CharSequence)"; ", msgs));
            double hottestHot = Collections.max(this.inletTemps);
            double coldestCold = Collections.min(this.inletTemps);
            for (int idx : unknownIndices) {
                double upper;
                double lower;
                double inlet = this.inletTemps.get(idx);
                String type = this.streamTypes.get(idx);
                if (type.equals("hot")) {
                    lower = coldestCold + this.approachTemperature;
                    upper = inlet;
                } else {
                    lower = inlet;
                    upper = hottestHot - this.approachTemperature;
                }
                double guess = lower + Math.random() * (upper - lower);
                this.outletTemps.set(idx, guess);
            }
            logger.debug("Outlet temps before solving: " + String.valueOf(this.outletTemps));
            logger.debug("Unknown flags: " + String.valueOf(this.unknownOutlets));
        }
        throw new RuntimeException("resetOfExtremes: gave up after 1000 attempts - last issues: " + String.join((CharSequence)"; ", msgs));
    }

    private boolean stallDetection(List<Integer> unknownIndices) {
        if (this.prevOutletTemps != null) {
            double maxDelta = 0.0;
            for (int i = 0; i < unknownIndices.size(); ++i) {
                int idx = unknownIndices.get(i);
                double delta = Math.abs(this.outletTemps.get(idx) - this.prevOutletTemps.get(i));
                if (!(delta > maxDelta)) continue;
                maxDelta = delta;
            }
            this.stallCounter = maxDelta <= this.localRange ? ++this.stallCounter : 0;
            if (this.stallCounter >= 50) {
                logger.warn("Local Minimum Detected! Stall counter reached limit.");
                this.stallCounter = 0;
                return true;
            }
        }
        this.prevOutletTemps = new ArrayList<Double>();
        for (int idx : unknownIndices) {
            this.prevOutletTemps.add(this.outletTemps.get(idx));
        }
        return false;
    }

    public Map<String, List<Map<String, Object>>> getCompositeCurve() {
        logger.debug("Composite Curve Points: " + String.valueOf(this.compositeCurve()));
        return this.compositeCurve();
    }

    public double getUA() {
        return this.calculateUA();
    }

    public double getTemperatureApproach() {
        return this.pinch();
    }

    @Override
    public StreamInterface getOutStream(int i) {
        if (i < 0 || i >= this.outStreams.size()) {
            throw new IndexOutOfBoundsException("Invalid outStream index: " + i);
        }
        return this.outStreams.get(i);
    }

    @Override
    public StreamInterface getInStream(int i) {
        return null;
    }

    @Override
    public double getInTemperature(int i) {
        return 0.0;
    }

    @Override
    public double getOutTemperature(int i) {
        return 0.0;
    }

    @Override
    public double getDuty() {
        return 0.0;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    @Override
    public void runConditionAnalysis() {
    }

    @Override
    public double getGuessOutTemperature() {
        return 0.0;
    }

    @Override
    public void setGuessOutTemperature(double temp) {
    }

    @Override
    public void setGuessOutTemperature(double temp, String unit) {
    }

    @Override
    public void setFlowArrangement(String arrangement) {
    }

    @Override
    public String getFlowArrangement() {
        return null;
    }

    @Override
    public void setThermalEffectiveness(double effectiveness) {
    }

    @Override
    public double getThermalEffectiveness() {
        return 0.0;
    }

    @Override
    public double getHotColdDutyBalance() {
        return 0.0;
    }

    @Override
    public void setHotColdDutyBalance(double value) {
    }

    @Override
    public double calcThermalEffectiveness(double NTU, double Cr) {
        return 0.0;
    }

    @Override
    public void setUseDeltaT(boolean use) {
    }

    @Override
    public void setFeedStream(int index, StreamInterface stream) {
    }

    @Override
    public void setDeltaT(double dT) {
    }

    @Override
    public double getDeltaT() {
        return 0.0;
    }

    @Override
    public double getUAvalue() {
        return 0.0;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().serializeSpecialFloatingPointValues().create().toJson(new MultiStreamHeatExchanger2Response(this));
    }
}

