/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.heatexchanger;

import java.util.UUID;
import neqsim.physicalproperties.system.PhysicalPropertyModel;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.util.steam.Iapws_if97;
import neqsim.util.unit.PressureUnit;
import neqsim.util.unit.RateUnit;
import neqsim.util.unit.TemperatureUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SteamHeater
extends Heater {
    private static final Logger logger = LogManager.getLogger(SteamHeater.class);
    private static final long serialVersionUID = 1000L;
    private double steamInletTemperature = 453.15;
    private double steamOutletTemperature = 373.15;
    private double steamPressure = 1.0;
    private double steamFlowRate = 0.0;

    public SteamHeater(String name) {
        super(name);
    }

    public SteamHeater(String name, StreamInterface inStream) {
        super(name, inStream);
        this.setWaterModel();
    }

    public void setSteamInletTemperature(double temperature, String unit) {
        this.steamInletTemperature = new TemperatureUnit(temperature, unit).getValue("K");
    }

    public void setSteamOutletTemperature(double temperature, String unit) {
        this.steamOutletTemperature = new TemperatureUnit(temperature, unit).getValue("K");
    }

    public void setSteamPressure(double pressure, String unit) {
        this.steamPressure = new PressureUnit(pressure, unit).getValue("bara");
    }

    public double getSteamFlowRate(String unit) {
        return new RateUnit(this.steamFlowRate, "kg/sec", 1.0, 1.0, 0.0).getValue(unit);
    }

    private void setWaterModel() {
        if (this.inStream != null) {
            this.inStream.getThermoSystem().setPhysicalPropertyModel(PhysicalPropertyModel.WATER);
        }
        if (this.outStream != null) {
            this.outStream.getThermoSystem().setPhysicalPropertyModel(PhysicalPropertyModel.WATER);
        }
    }

    @Override
    public void setInletStream(StreamInterface stream) {
        super.setInletStream(stream);
        this.setWaterModel();
    }

    @Override
    public void run(UUID id) {
        super.run(id);
        this.calculateSteamFlowRate();
    }

    private void calculateSteamFlowRate() {
        double pinMPa = this.steamPressure / 10.0;
        double hin = Iapws_if97.h_pt(pinMPa, this.steamInletTemperature);
        double hout = Iapws_if97.h_pt(pinMPa, this.steamOutletTemperature);
        double deltaH = hin - hout;
        logger.debug("DEBUG SteamHeater: getEnergyInput()=" + this.getEnergyInput() + ", hin=" + hin + ", hout=" + hout + ", deltaH=" + deltaH);
        if (Math.abs(deltaH) < 1.0E-6) {
            this.steamFlowRate = 0.0;
            return;
        }
        this.steamFlowRate = this.getEnergyInput() / (deltaH * 1000.0);
    }
}

