/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrateEquilibriumTemperatureAnalyser
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(HydrateEquilibriumTemperatureAnalyser.class);
    private double referencePressure = 0.0;

    public HydrateEquilibriumTemperatureAnalyser(String name, StreamInterface stream) {
        super(name, "K", stream);
        this.setConditionAnalysisMaxDeviation(1.0);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    @Override
    public double getMeasuredValue(String unit) {
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        if (!tempFluid.getHydrateCheck()) {
            tempFluid.setHydrateCheck(true);
        }
        tempFluid.setTemperature(10.0, "C");
        if (this.referencePressure > 1.0E-10) {
            tempFluid.setPressure(this.referencePressure);
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.hydrateFormationTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return tempFluid.getTemperature(unit);
    }

    public double getReferencePressure() {
        return this.referencePressure;
    }

    public void setReferencePressure(double referencePressure) {
        this.referencePressure = referencePressure;
    }
}

