/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.designstandards;

import neqsim.process.equipment.separator.Separator;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.DesignStandard;
import neqsim.process.mechanicaldesign.designstandards.JointEfficiencyPlateStandard;
import neqsim.process.mechanicaldesign.designstandards.MaterialPlateDesignStandard;

public class PressureVesselDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;

    public PressureVesselDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
    }

    public double calcWallThickness() {
        Separator separator = (Separator)this.equipment.getProcessEquipment();
        double wallT = 0.0;
        MaterialPlateDesignStandard matPlateStyandard = (MaterialPlateDesignStandard)this.equipment.getDesignStandard().get("material plate design codes");
        JointEfficiencyPlateStandard JEPlateStyandard = (JointEfficiencyPlateStandard)this.equipment.getDesignStandard().get("plate Joint Efficiency design codes");
        double maxAllowableStress = matPlateStyandard.getDivisionClass();
        double jointEfficiency = JEPlateStyandard.getJEFactor();
        wallT = this.standardName.equals("ASME - Pressure Vessel Code") ? this.equipment.getMaxOperationPressure() / 10.0 * separator.getInternalDiameter() * 1000.0 / (2.0 * maxAllowableStress * jointEfficiency - 1.2 * this.equipment.getMaxOperationPressure() / 10.0) + this.equipment.getCorrosionAllowanse() : (this.standardName.equals("BS 5500 - Pressure Vessel") ? this.equipment.getMaxOperationPressure() / 10.0 * separator.getInternalDiameter() * 1000.0 / (2.0 * maxAllowableStress - jointEfficiency / 10.0) + this.equipment.getCorrosionAllowanse() : (this.standardName.equals("European Code") ? this.equipment.getMaxOperationPressure() / 10.0 * separator.getInternalDiameter() / 2.0 * 1000.0 / (2.0 * maxAllowableStress * jointEfficiency - 0.2 * this.equipment.getMaxOperationPressure() / 10.0) + this.equipment.getCorrosionAllowanse() : this.equipment.getMaxOperationPressure() / 10.0 * separator.getInternalDiameter() / 2.0 * 1000.0 / (2.0 * maxAllowableStress * jointEfficiency - 0.2 * this.equipment.getMaxOperationPressure() / 10.0) + this.equipment.getCorrosionAllowanse()));
        return wallT / 1000.0;
    }
}

