/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.valve;

import java.util.HashMap;
import java.util.Map;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ValveInterface;
import neqsim.process.mechanicaldesign.valve.ControlValveSizing_IEC_60534;
import neqsim.process.mechanicaldesign.valve.ValveMechanicalDesign;
import neqsim.thermo.phase.PhaseType;

public class ControlValveSizing_IEC_60534_full
extends ControlValveSizing_IEC_60534 {
    private static final double N2 = 0.0016;
    private static final double N4 = 0.0707;
    private static final double N5 = 0.0018;
    private static final double N18 = 0.865;
    private static final double N32 = 140.0;
    private static final int MAX_ITERATIONS = 20;
    private static final double CONVERGENCE_TOLERANCE = 0.001;
    private boolean isFullTrim = true;

    public ControlValveSizing_IEC_60534_full() {
    }

    public ControlValveSizing_IEC_60534_full(ValveMechanicalDesign valveMechanicalDesign) {
        super(valveMechanicalDesign);
    }

    public boolean isFullTrim() {
        return this.isFullTrim;
    }

    public void setFullTrim(boolean isFullTrim) {
        this.isFullTrim = isFullTrim;
    }

    @Override
    public Map<String, Object> sizeControlValveLiquid(double rho, double Psat, double Pc, double P1, double P2, double Q, double percentOpening) {
        HashMap<String, Object> ans = new HashMap<String, Object>();
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double locPsat = Psat / 1000.0;
        double locPc = Pc / 1000.0;
        double Qloc = Q * 3600.0;
        double dP = locP1 - locP2;
        double FF = this.ffCriticalPressureRatioL(locPsat, locPc);
        boolean initialChoked = this.isChokedTurbulentL(dP, locP1, locPsat, FF, this.getFL());
        double initialKv = initialChoked && this.isAllowChoked() ? Qloc / (0.1 * this.getFL() * Math.sqrt((locP1 - FF * locPsat) * 999.103 / rho)) : Qloc / (0.1 * Math.sqrt(dP * 999.103 / rho));
        if (this.getD1() == 0.0 || this.getD() == 0.0) {
            ans.put("Kv", initialKv);
            ans.put("Cv", this.Kv_to_Cv(initialKv));
            ans.put("choked", initialChoked);
            ans.put("FF", FF);
            ans.put("Rev", Double.POSITIVE_INFINITY);
            ans.put("laminar", false);
            return ans;
        }
        double nu = this.getValve().getInletStream().getThermoSystem().getViscosity("kg/msec") / rho;
        double dmm = this.getD() * 1000.0;
        double D1mm = this.getD1() * 1000.0;
        double D2mm = this.getD2() * 1000.0;
        double kv = initialKv;
        double Rev = this.reynoldsValve(nu * 1000000.0, Qloc, D1mm, this.getFL(), this.getFd(), kv);
        ans.put("Rev", Rev);
        ans.put("laminar", Rev <= 10000.0 && this.isAllowLaminar());
        if (Rev > 10000.0 || !this.isAllowLaminar()) {
            double FP = 1.0;
            double FLP = this.getFL();
            for (int i = 0; i < 20; ++i) {
                double loss = this.lossCoefficientPiping(dmm, D1mm, D2mm);
                FP = 1.0 / Math.sqrt(1.0 + loss / 0.0016 * Math.pow(kv / (dmm * dmm), 2.0));
                double lossUpstream = D1mm > 0.0 ? this.lossCoefficientPiping(dmm, D1mm, null) : 0.0;
                FLP = this.getFL() / Math.sqrt(1.0 + Math.pow(this.getFL(), 2.0) / 0.0016 * lossUpstream * Math.pow(kv / (dmm * dmm), 2.0));
                boolean choked = this.isChokedTurbulentL(dP, locP1, locPsat, FF, FLP, FP);
                double newKv = choked && this.isAllowChoked() ? Qloc / (0.1 * FLP) * Math.sqrt(rho / 999.103 / (locP1 - FF * locPsat)) : Qloc / (0.1 * FP) * Math.sqrt(rho / 999.103 / dP);
                if (Math.abs(newKv - kv) / newKv < 0.001) {
                    kv = newKv;
                    break;
                }
                kv = newKv;
            }
            ans.put("FP", FP);
            ans.put("FLP", FLP);
        } else {
            double FR = 1.0;
            for (int i = 0; i < 20; ++i) {
                Rev = this.reynoldsValve(nu * 1000000.0, Qloc, D1mm, this.getFL(), this.getFd(), kv);
                FR = this.reynoldsFactor(this.getFL(), kv, dmm, Rev, this.isFullTrim);
                double newKv = initialKv / FR;
                if (Math.abs(newKv - kv) / newKv < 0.001) {
                    kv = newKv;
                    break;
                }
                kv = newKv;
            }
            ans.put("Rev", Rev);
            ans.put("FR", FR);
        }
        ans.put("FF", FF);
        ans.put("choked", this.isChokedTurbulentL(dP, locP1, locPsat, FF, (Double)ans.get("FLP"), (Double)ans.get("FP")));
        ans.put("Kv", kv /= this.valveMechanicalDesign.getValveCharacterizationMethod().getOpeningFactor(percentOpening));
        ans.put("Cv", this.Kv_to_Cv(kv));
        return ans;
    }

    @Override
    public Map<String, Object> sizeControlValveGas(double T, double MW, double gamma, double Z, double P1, double P2, double Q, double percentOpening) {
        HashMap<String, Object> ans = new HashMap<String, Object>();
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double Qloc = Q * 3600.0;
        double dP = locP1 - locP2;
        double x = dP / locP1;
        double Fgamma = gamma / 1.4;
        double Y = Math.max(1.0 - x / (3.0 * Fgamma * this.getxT()), 0.6666666666666666);
        boolean initialChoked = this.isChokedTurbulentG(x, Fgamma, this.getxT());
        double initialKv = initialChoked && this.isAllowChoked() ? Qloc / (24.6 * locP1 * Y) * Math.sqrt(MW * T * Z / (this.getxT() * Fgamma)) : Qloc / (24.6 * locP1 * Y) * Math.sqrt(MW * T * Z / x);
        if (this.getD1() == 0.0 || this.getD() == 0.0) {
            ans.put("Kv", initialKv);
            ans.put("Cv", this.Kv_to_Cv(initialKv));
            ans.put("choked", initialChoked);
            ans.put("Y", Y);
            ans.put("Fgamma", Fgamma);
            ans.put("Rev", Double.POSITIVE_INFINITY);
            ans.put("laminar", false);
            return ans;
        }
        double Vm = Z * 8.314462 * T / P1;
        double rho = MW * 0.001 / Vm;
        double nu = this.getValve().getInletStream().getThermoSystem().getViscosity("kg/msec") / rho;
        double dmm = this.getD() * 1000.0;
        double D1mm = this.getD1() * 1000.0;
        double D2mm = this.getD2() * 1000.0;
        double kv = initialKv;
        double Rev = this.reynoldsValve(nu * 1000000.0, Qloc, D1mm, this.getFL(), this.getFd(), kv);
        ans.put("Rev", Rev);
        ans.put("laminar", Rev <= 10000.0 && this.isAllowLaminar());
        if (Rev > 10000.0 || !this.isAllowLaminar()) {
            double FP = 1.0;
            double xTP = this.getxT();
            for (int i = 0; i < 20; ++i) {
                double loss = this.lossCoefficientPiping(dmm, D1mm, D2mm);
                FP = 1.0 / Math.sqrt(1.0 + loss / 0.0016 * Math.pow(kv / (dmm * dmm), 2.0));
                double lossUpstream = D1mm > 0.0 ? this.lossCoefficientPiping(dmm, D1mm, null) : 0.0;
                xTP = this.getxT() / (FP * FP) / (1.0 + this.getxT() * lossUpstream / 0.0018 * Math.pow(kv / (dmm * dmm), 2.0));
                boolean choked = this.isChokedTurbulentG(x, Fgamma, xTP);
                double newKv = choked && this.isAllowChoked() ? Qloc / (24.6 * FP * locP1 * Y) * Math.sqrt(MW * T * Z / (xTP * Fgamma)) : Qloc / (24.6 * FP * locP1 * Y) * Math.sqrt(MW * T * Z / x);
                if (Math.abs(newKv - kv) / newKv < 0.001) {
                    kv = newKv;
                    break;
                }
                kv = newKv;
            }
            ans.put("FP", FP);
            ans.put("xTP", xTP);
        } else {
            double FR = 1.0;
            for (int i = 0; i < 20; ++i) {
                Rev = this.reynoldsValve(nu * 1000000.0, Qloc, D1mm, this.getFL(), this.getFd(), kv);
                FR = this.reynoldsFactor(this.getFL(), kv, dmm, Rev, this.isFullTrim);
                double newKv = initialKv / FR;
                if (Math.abs(newKv - kv) / newKv < 0.001) {
                    kv = newKv;
                    break;
                }
                kv = newKv;
            }
            ans.put("Rev", Rev);
            ans.put("FR", FR);
        }
        kv /= this.valveMechanicalDesign.getValveCharacterizationMethod().getOpeningFactor(percentOpening);
        ans.put("choked", this.isChokedTurbulentG(x, Fgamma, (Double)ans.getOrDefault("xTP", this.getxT())));
        ans.put("Y", Y);
        ans.put("Fgamma", Fgamma);
        ans.put("Kv", kv);
        ans.put("Cv", this.Kv_to_Cv(kv));
        return ans;
    }

    private double lossCoefficientPiping(double d, Double D1, Double D2) {
        double dr2;
        double dr;
        double loss = 0.0;
        if (D1 != null) {
            dr = d / D1;
            dr2 = dr * dr;
            loss += 1.0 - Math.pow(dr2, 2.0);
            loss += 0.5 * Math.pow(1.0 - dr2, 2.0);
        }
        if (D2 != null) {
            dr = d / D2;
            dr2 = dr * dr;
            loss += 1.0 * Math.pow(1.0 - dr2, 2.0);
            loss -= 1.0 - Math.pow(dr2, 2.0);
        }
        return loss;
    }

    private double reynoldsValve(double nu, double Q, double D1, double FL, double Fd, double C) {
        double nu_cSt = nu;
        return 0.0707 * Fd * Q / nu_cSt / Math.sqrt(C * FL) * Math.pow(Math.pow(FL, 2.0) * Math.pow(C, 2.0) / 0.0016 * Math.pow(D1, -4.0) + 1.0, 0.25);
    }

    private double reynoldsFactor(double FL, double C, double d, double Rev, boolean fullTrim) {
        double FR;
        if (fullTrim) {
            double n1 = 0.0016 / Math.pow(C / (d * d), 2.0);
            double FR_1a = 1.0 + 0.33 * Math.sqrt(FL) / Math.pow(n1, 0.25) * Math.log10(Rev / 10000.0);
            double FR_2 = 0.026 / FL * Math.sqrt(n1 * Rev);
            FR = Rev < 10.0 ? FR_2 : Math.min(FR_2, FR_1a);
        } else {
            double n2 = 1.0 + 140.0 * Math.pow(C / (d * d), 0.6666666666666666);
            double FR_3a = 1.0 + 0.33 * Math.sqrt(FL) / Math.pow(n2, 0.25) * Math.log10(Rev / 10000.0);
            double FR_4 = Math.min(0.026 / FL * Math.sqrt(n2 * Rev), 1.0);
            FR = Rev < 10.0 ? FR_4 : Math.min(FR_3a, FR_4);
        }
        return Math.max(0.0, FR);
    }

    private boolean isChokedTurbulentL(double dP, double P1, double Psat, double FF, Double FLP, Double FP) {
        if (FLP != null && FP != null) {
            return dP >= Math.pow(FLP / FP, 2.0) * (P1 - FF * Psat);
        }
        return super.isChokedTurbulentL(dP, P1, Psat, FF, this.getFL());
    }

    @Override
    public double findOutletPressureForFixedKv(double adjustedKv, StreamInterface inletStream) {
        return super.findOutletPressureForFixedKv(adjustedKv, inletStream);
    }

    @Override
    public double calculateFlowRateFromValveOpening(double adjustedKv, StreamInterface inletStream, StreamInterface outletStream) {
        if (inletStream.getThermoSystem().hasPhaseType(PhaseType.GAS)) {
            return this.calculateFlowRateFromValveOpeningGas_full(adjustedKv, inletStream, outletStream);
        }
        return this.calculateFlowRateFromValveOpeningLiquid_full(adjustedKv, inletStream, outletStream);
    }

    public double calculateValveOpeningFromFlowRate(double Q, double Kv, StreamInterface inletStream, StreamInterface outletStream, double percentValveOpening) {
        if (Q <= 0.0) {
            return 0.0;
        }
        Map<String, Object> result = this.calcValveSize(percentValveOpening);
        double requiredKv = (Double)result.get("Kv");
        double valveOpening = requiredKv / Kv * 100.0;
        return Math.max(0.0, Math.min(100.0, valveOpening));
    }

    private double calculateFlowRateFromValveOpeningLiquid_full(double adjustedKv, StreamInterface inletStream, StreamInterface outletStream) {
        double effectiveKv = adjustedKv;
        double rho = inletStream.getThermoSystem().getDensity("kg/m3");
        double Psat = inletStream.getThermoSystem().getPhase(0).getPressure("Pa");
        double Pc = inletStream.getThermoSystem().getPhase(0).getPseudoCriticalPressure() * 100000.0;
        double P1 = inletStream.getPressure("Pa");
        double P2 = outletStream.getPressure("Pa");
        double Q_low = 0.0;
        double dP_kPa = P1 > P2 ? (P1 - P2) / 1000.0 : 0.001;
        double Q_high_m3h = 0.1 * effectiveKv * Math.sqrt(dP_kPa * 999.103 / rho);
        double Q_high = Q_high_m3h / 3600.0 * 2.0;
        double Q_mid = 0.0;
        for (int i = 0; i < 20 && !((Q_mid = 0.5 * (Q_low + Q_high)) < 1.0E-9); ++i) {
            Map<String, Object> result = this.sizeControlValveLiquid(rho, Psat, Pc, P1, P2, Q_mid, ((ValveInterface)this.getValveMechanicalDesign().getProcessEquipment()).getPercentValveOpening());
            double requiredKv = (Double)result.get("Kv");
            if (requiredKv < effectiveKv) {
                Q_low = Q_mid;
            } else {
                Q_high = Q_mid;
            }
            if (Math.abs(Q_high - Q_low) < 1.0E-6) break;
        }
        return Q_mid;
    }

    private double calculateFlowRateFromValveOpeningGas_full(double adjustedKv, StreamInterface inletStream, StreamInterface outletStream) {
        double effectiveKv = adjustedKv;
        double T = inletStream.getThermoSystem().getTemperature("K");
        double MW = inletStream.getThermoSystem().getMolarMass("gr/mol");
        double gamma = inletStream.getThermoSystem().getGamma2();
        double Z = inletStream.getThermoSystem().getZ();
        double P1 = inletStream.getPressure("Pa");
        double P2 = outletStream.getPressure("Pa");
        double Q_low = 0.0;
        double Y = 0.8;
        double x = P1 > P2 ? (P1 - P2) / P1 : 0.001;
        double Q_high_m3h = 24.6 * effectiveKv * (P1 / 1000.0) * Y / Math.sqrt(MW * T * Z / x);
        double Q_high = Q_high_m3h / 3600.0 * 2.0;
        double Q_mid = 0.0;
        for (int i = 0; i < 20 && !((Q_mid = 0.5 * (Q_low + Q_high)) < 1.0E-9); ++i) {
            Map<String, Object> result = this.sizeControlValveGas(T, MW, gamma, Z, P1, P2, Q_mid, ((ValveInterface)this.getValveMechanicalDesign().getProcessEquipment()).getPercentValveOpening());
            double requiredKv = (Double)result.get("Kv");
            if (requiredKv < effectiveKv) {
                Q_low = Q_mid;
            } else {
                Q_high = Q_mid;
            }
            if (Math.abs(Q_high - Q_low) < 1.0E-6) break;
        }
        return Q_mid;
    }
}

