/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import neqsim.datapresentation.filehandling.TextFile;
import neqsim.process.SimulationBaseClass;
import neqsim.process.conditionmonitor.ConditionMonitor;
import neqsim.process.equipment.EquipmentEnum;
import neqsim.process.equipment.EquipmentFactory;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.pump.Pump;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.util.Adjuster;
import neqsim.process.equipment.util.Recycle;
import neqsim.process.equipment.util.RecycleController;
import neqsim.process.measurementdevice.MeasurementDeviceInterface;
import neqsim.process.processmodel.ModuleInterface;
import neqsim.process.processmodel.ProcessLoader;
import neqsim.process.util.report.Report;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessSystem
extends SimulationBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ProcessSystem.class);
    transient Thread thisThread;
    String[][] signalDB = new String[10000][100];
    private double surroundingTemperature = 288.15;
    private int timeStepNumber = 0;
    private List<ProcessEquipmentInterface> unitOperations = new ArrayList<ProcessEquipmentInterface>();
    List<MeasurementDeviceInterface> measurementDevices = new ArrayList<MeasurementDeviceInterface>(0);
    RecycleController recycleController = new RecycleController();
    private double timeStep = 1.0;
    private boolean runStep = false;
    private final Map<String, Integer> equipmentCounter = new HashMap<String, Integer>();
    private ProcessEquipmentInterface lastAddedUnit = null;

    public ProcessSystem() {
        this("Process system");
    }

    public ProcessSystem(String name) {
        super(name);
    }

    public void add(ProcessEquipmentInterface operation) {
        this.add(this.getUnitOperations().size(), operation);
    }

    public void add(int position, ProcessEquipmentInterface operation) {
        List<ProcessEquipmentInterface> units = this.getUnitOperations();
        for (ProcessEquipmentInterface unit : units) {
            if (unit != operation) continue;
            logger.info("Equipment " + operation.getName() + " is already included in ProcessSystem");
            return;
        }
        if (this.getAllUnitNames().contains(operation.getName())) {
            ProcessEquipmentInterface existing = this.getUnit(operation.getName());
            throw new RuntimeException(new InvalidInputException("ProcessSystem", "add", "operation", "- Process equipment of type " + existing.getClass().getSimpleName() + " named " + operation.getName() + " already included in ProcessSystem"));
        }
        this.getUnitOperations().add(position, operation);
        if (operation instanceof ModuleInterface) {
            ((ModuleInterface)operation).initializeModule();
        }
    }

    public void add(MeasurementDeviceInterface measurementDevice) {
        this.measurementDevices.add(measurementDevice);
    }

    public void add(ProcessEquipmentInterface[] operations) {
        this.getUnitOperations().addAll(Arrays.asList(operations));
    }

    public boolean replaceUnit(String name, ProcessEquipmentInterface newObject) {
        try {
            ProcessEquipmentInterface unit = this.getUnit(name);
            unit = newObject;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public ProcessEquipmentInterface getUnit(String name) {
        for (int i = 0; i < this.getUnitOperations().size(); ++i) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                for (int j = 0; j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size(); ++j) {
                    if (!((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName().equals(name)) continue;
                    return ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j);
                }
                continue;
            }
            if (!this.getUnitOperations().get(i).getName().equals(name)) continue;
            return this.getUnitOperations().get(i);
        }
        return null;
    }

    public boolean hasUnitName(String name) {
        return this.getUnit(name) != null;
    }

    public MeasurementDeviceInterface getMeasurementDevice(String name) {
        for (int i = 0; i < this.measurementDevices.size(); ++i) {
            if (!this.measurementDevices.get(i).getName().equals(name)) continue;
            return this.measurementDevices.get(i);
        }
        return null;
    }

    public int getUnitNumber(String name) {
        for (int i = 0; i < this.getUnitOperations().size(); ++i) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                for (int j = 0; j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size(); ++j) {
                    if (!((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName().equals(name)) continue;
                    return j;
                }
                continue;
            }
            if (!this.getUnitOperations().get(i).getName().equals(name)) continue;
            return i;
        }
        return 0;
    }

    public void replaceObject(String unitName, ProcessEquipmentBaseClass operation) {
        this.unitOperations.set(this.getUnitNumber(this.name), operation);
    }

    public ArrayList<String> getAllUnitNames() {
        ArrayList<String> unitNames = new ArrayList<String>();
        for (int i = 0; i < this.getUnitOperations().size(); ++i) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                for (int j = 0; j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size(); ++j) {
                    unitNames.add(((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName());
                }
            }
            unitNames.add(this.unitOperations.get(i).getName());
        }
        return unitNames;
    }

    public List<ProcessEquipmentInterface> getUnitOperations() {
        return this.unitOperations;
    }

    public void removeUnit(String name) {
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (!this.unitOperations.get(i).getName().equals(name)) continue;
            this.unitOperations.remove(i);
        }
    }

    public void clearAll() {
        this.unitOperations.clear();
    }

    public void clear() {
        this.unitOperations = new ArrayList<ProcessEquipmentInterface>(0);
    }

    public void setFluid(SystemInterface fluid1, SystemInterface fluid2, boolean addNewComponents) {
        fluid1.setEmptyFluid();
        boolean addedComps = false;
        for (int i = 0; i < fluid2.getNumberOfComponents(); ++i) {
            if (fluid1.getPhase(0).hasComponent(fluid2.getComponent(i).getName())) {
                fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
                continue;
            }
            if (!addNewComponents) continue;
            addedComps = true;
            if (fluid2.getComponent(i).isIsTBPfraction() || fluid2.getComponent(i).isIsPlusFraction()) {
                fluid1.addTBPfraction(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles(), fluid2.getComponent(i).getMolarMass(), fluid2.getComponent(i).getNormalLiquidDensity());
                continue;
            }
            fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
        }
        if (addedComps) {
            fluid1.createDatabase(true);
        }
        fluid1.init(0);
        fluid1.setTemperature(fluid2.getTemperature());
        fluid1.setPressure(fluid2.getPressure());
    }

    public void setFluid(SystemInterface fluid1, SystemInterface fluid2) {
        fluid1.setEmptyFluid();
        boolean addedComps = false;
        for (int i = 0; i < fluid2.getNumberOfComponents(); ++i) {
            if (fluid1.getPhase(0).hasComponent(fluid2.getComponent(i).getName())) {
                fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
                continue;
            }
            addedComps = true;
            if (fluid2.getComponent(i).isIsTBPfraction() || fluid2.getComponent(i).isIsPlusFraction()) {
                fluid1.addTBPfraction(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles(), fluid2.getComponent(i).getMolarMass(), fluid2.getComponent(i).getNormalLiquidDensity());
                continue;
            }
            fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
        }
        if (addedComps) {
            fluid1.createDatabase(true);
        }
        fluid1.init(0);
        fluid1.setTemperature(fluid2.getTemperature());
        fluid1.setPressure(fluid2.getPressure());
    }

    public Thread runAsThread() {
        Thread processThread = new Thread(this);
        processThread.start();
        return processThread;
    }

    @Override
    public void run(UUID id) {
        int i;
        for (int i2 = 0; i2 < this.unitOperations.size(); ++i2) {
            if (!this.unitOperations.get(i2).getClass().getSimpleName().equals("Setter")) continue;
            this.unitOperations.get(i2).run(id);
        }
        boolean hasRecycle = false;
        this.recycleController.clear();
        for (int i3 = 0; i3 < this.unitOperations.size(); ++i3) {
            if (this.unitOperations.get(i3).getClass().getSimpleName().equals("Recycle")) {
                hasRecycle = true;
                this.recycleController.addRecycle((Recycle)this.unitOperations.get(i3));
            }
            if (!this.unitOperations.get(i3).getClass().getSimpleName().equals("Adjuster")) continue;
        }
        this.recycleController.init();
        boolean isConverged = true;
        int iter = 0;
        block6: do {
            ++iter;
            isConverged = true;
            for (i = 0; i < this.unitOperations.size(); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("Process simulation was interrupted, exiting run()..." + this.getName());
                    break;
                }
                if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Recycle")) {
                    try {
                        if (iter == 1 || this.unitOperations.get(i).needRecalculation()) {
                            this.unitOperations.get(i).run(id);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("error running unit uperation " + this.unitOperations.get(i).getName() + " " + ex.getMessage(), (Throwable)ex);
                        ex.printStackTrace();
                    }
                }
                if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Recycle") || !this.recycleController.doSolveRecycle((Recycle)this.unitOperations.get(i))) continue;
                try {
                    this.unitOperations.get(i).run(id);
                    continue;
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (!this.recycleController.solvedAll() || this.recycleController.hasHigherPriorityLevel()) {
                isConverged = false;
            }
            if (this.recycleController.solvedCurrentPriorityLevel()) {
                this.recycleController.nextPriorityLevel();
            } else if (this.recycleController.hasLoverPriorityLevel() && !this.recycleController.solvedAll()) {
                this.recycleController.resetPriorityLevel();
            }
            for (i = 0; i < this.unitOperations.size(); ++i) {
                if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Adjuster") || ((Adjuster)this.unitOperations.get(i)).solved()) continue;
                isConverged = false;
                continue block6;
            }
        } while ((!isConverged || iter < 2 && hasRecycle) && iter < 100 && !this.runStep && !Thread.currentThread().isInterrupted());
        for (i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).setCalculationIdentifier(id);
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void run_step(UUID id) {
        int i;
        for (i = 0; i < this.unitOperations.size(); ++i) {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("Process simulation was interrupted, exiting run()..." + this.getName());
                    break;
                }
                this.unitOperations.get(i).run(id);
                continue;
            }
            catch (Exception ex) {
                logger.error("equipment: " + this.unitOperations.get(i).getName() + " errror: " + ex.getMessage(), (Throwable)ex);
            }
        }
        for (i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).setCalculationIdentifier(id);
        }
        this.setCalculationIdentifier(id);
    }

    public void runTransient() {
        this.runTransient(this.getTimeStep(), UUID.randomUUID());
    }

    @Override
    public void runTransient(double dt, UUID id) {
        int i;
        for (i = 0; i < this.unitOperations.size(); ++i) {
            if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Setter")) continue;
            this.unitOperations.get(i).run(id);
        }
        this.setTimeStep(dt);
        this.increaseTime(dt);
        for (i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).runTransient(dt, id);
        }
        ++this.timeStepNumber;
        this.signalDB[this.timeStepNumber] = new String[1 + 3 * this.measurementDevices.size()];
        for (i = 0; i < this.measurementDevices.size(); ++i) {
            this.signalDB[this.timeStepNumber][0] = Double.toString(this.time);
            this.signalDB[this.timeStepNumber][3 * i + 1] = this.measurementDevices.get(i).getName();
            this.signalDB[this.timeStepNumber][3 * i + 2] = Double.toString(this.measurementDevices.get(i).getMeasuredValue());
            this.signalDB[this.timeStepNumber][3 * i + 3] = this.measurementDevices.get(i).getUnit();
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public boolean solved() {
        if (this.recycleController.solvedAll()) {
            for (int i = 0; i < this.unitOperations.size(); ++i) {
                logger.info("unit " + this.unitOperations.get(i).getName() + " solved: " + this.unitOperations.get(i).solved());
                if (this.unitOperations.get(i).solved()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public double getTime(String unit) {
        if (!unit.equals("sec")) {
            if (unit.equals("hr")) {
                return this.time / 3600.0;
            }
            if (unit.equals("day")) {
                return this.time / 86400.0;
            }
            if (unit.equals("year")) {
                return this.time / 3.1536E7;
            }
        }
        return this.time;
    }

    public int size() {
        return this.unitOperations.size();
    }

    public void view() {
        this.displayResult();
    }

    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        try {
            this.thisThread.join();
        }
        catch (Exception ex) {
            logger.error("Thread did not finish", (Throwable)ex);
        }
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).displayResult();
        }
    }

    public void reportMeasuredValues() {
        try {
            this.thisThread.join();
        }
        catch (Exception ex) {
            logger.error("Thread did not finish", (Throwable)ex);
        }
        for (int i = 0; i < this.measurementDevices.size(); ++i) {
            System.out.println("Measurements Device Name: " + this.measurementDevices.get(i).getName());
            System.out.println("Value: " + this.measurementDevices.get(i).getMeasuredValue() + " " + this.measurementDevices.get(i).getUnit());
            if (!this.measurementDevices.get(i).isOnlineSignal()) continue;
            System.out.println("Online value: " + this.measurementDevices.get(i).getOnlineSignal().getValue() + " " + this.measurementDevices.get(i).getOnlineSignal().getUnit());
        }
    }

    public void save(String filePath) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filePath, false));){
            out.writeObject(this);
            logger.info("process file saved to:  " + filePath);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static ProcessSystem open(String filePath) {
        ProcessSystem processSystem;
        ObjectInputStream objectinputstream = new ObjectInputStream(new FileInputStream(filePath));
        try {
            processSystem = (ProcessSystem)objectinputstream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectinputstream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        objectinputstream.close();
        return processSystem;
    }

    public String[][] reportResults() {
        String[][] text = new String[200][];
        int numb = 0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            for (int k = 0; k < this.unitOperations.get(i).reportResults().length; ++k) {
                text[numb++] = this.unitOperations.get(i).reportResults()[k];
            }
        }
        return text;
    }

    public void printLogFile(String filename) {
        TextFile tempFile = new TextFile();
        tempFile.setOutputFileName(filename);
        tempFile.setValues(this.signalDB);
        tempFile.createFile();
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setRunStep(boolean runStep) {
        this.runStep = runStep;
    }

    public boolean isRunStep() {
        return this.runStep;
    }

    public double getEntropyProduction(String unit) {
        double entropyProduction = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            entropyProduction += this.unitOperations.get(i).getEntropyProduction(unit);
            System.out.println("unit " + this.unitOperations.get(i).getName() + " entropy production " + this.unitOperations.get(i).getEntropyProduction(unit));
        }
        return entropyProduction;
    }

    public double getExergyChange(String unit) {
        double exergyChange = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            exergyChange += this.unitOperations.get(i).getExergyChange("J", this.getSurroundingTemperature());
            System.out.println("unit " + this.unitOperations.get(i).getName() + " exergy change  " + this.unitOperations.get(i).getExergyChange("J", this.getSurroundingTemperature()));
        }
        return exergyChange;
    }

    public double getPower(String unit) {
        double power = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (this.unitOperations.get(i).getClass().getSimpleName().equals("Compressor")) {
                power += ((Compressor)this.unitOperations.get(i)).getPower();
                continue;
            }
            if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Pump")) continue;
            power += ((Pump)this.unitOperations.get(i)).getPower();
        }
        if (unit.equals("MW")) {
            return power / 1000000.0;
        }
        if (unit.equals("kW")) {
            return power / 1000.0;
        }
        return power;
    }

    public double getCoolerDuty(String unit) {
        double heat = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Cooler")) continue;
            heat += ((Cooler)this.unitOperations.get(i)).getDuty();
        }
        if (unit.equals("MW")) {
            return heat / 1000000.0;
        }
        if (unit.equals("kW")) {
            return heat / 1000.0;
        }
        return heat;
    }

    public double getHeaterDuty(String unit) {
        double heat = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Heater")) continue;
            heat += ((Heater)this.unitOperations.get(i)).getDuty();
        }
        if (unit.equals("MW")) {
            return heat / 1000000.0;
        }
        if (unit.equals("kW")) {
            return heat / 1000.0;
        }
        return heat;
    }

    public double getSurroundingTemperature() {
        return this.surroundingTemperature;
    }

    public void setSurroundingTemperature(double surroundingTemperature) {
        this.surroundingTemperature = surroundingTemperature;
    }

    public ProcessSystem copy() {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(this);
            out.flush();
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            return (ProcessSystem)in.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy ProcessSystem", e);
        }
    }

    public ConditionMonitor getConditionMonitor() {
        return new ConditionMonitor(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.signalDB);
        result = 31 * result + Objects.hash(this.measurementDevices, this.name, this.recycleController, this.surroundingTemperature, this.time, this.timeStep, this.timeStepNumber, this.unitOperations);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessSystem other = (ProcessSystem)obj;
        return Objects.equals(this.measurementDevices, other.measurementDevices) && Objects.equals(this.name, other.name) && Objects.equals(this.recycleController, other.recycleController) && Arrays.deepEquals((Object[])this.signalDB, (Object[])other.signalDB) && Double.doubleToLongBits(this.surroundingTemperature) == Double.doubleToLongBits(other.surroundingTemperature) && Double.doubleToLongBits(this.time) == Double.doubleToLongBits(other.time) && Double.doubleToLongBits(this.timeStep) == Double.doubleToLongBits(other.timeStep) && this.timeStepNumber == other.timeStepNumber && Objects.equals(this.unitOperations, other.unitOperations);
    }

    @Override
    public String getReport_json() {
        return new Report(this).generateJsonReport();
    }

    public <T extends ProcessEquipmentInterface> T addUnit(String name, String equipmentType) {
        ProcessEquipmentInterface unit = EquipmentFactory.createEquipment(name, equipmentType);
        if (name == null || name.trim().isEmpty()) {
            name = this.generateUniqueName(equipmentType);
        }
        unit.setName(name);
        this.autoConnect(this.lastAddedUnit, unit);
        this.add(unit);
        this.lastAddedUnit = unit;
        return (T)unit;
    }

    public <T extends ProcessEquipmentInterface> T addUnit(String name, EquipmentEnum equipmentEnum) {
        return this.addUnit(name, equipmentEnum.name());
    }

    public <T extends ProcessEquipmentInterface> T addUnit(String equipmentType) {
        return this.addUnit(null, equipmentType);
    }

    public <T extends ProcessEquipmentInterface> T addUnit(EquipmentEnum equipmentEnum) {
        return this.addUnit(null, equipmentEnum);
    }

    public <T extends ProcessEquipmentInterface> T addUnit(String name, String equipmentType, StreamInterface stream) {
        ProcessEquipmentInterface unit = EquipmentFactory.createEquipment(name, equipmentType);
        if (name == null || name.trim().isEmpty()) {
            name = this.generateUniqueName(equipmentType);
        }
        unit.setName(name);
        try {
            Method setInlet = unit.getClass().getMethod("setInletStream", StreamInterface.class);
            setInlet.invoke((Object)unit, stream);
        }
        catch (NoSuchMethodException setInlet) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add(unit);
        this.lastAddedUnit = unit;
        return (T)unit;
    }

    public ProcessEquipmentInterface addUnit(String name, ProcessEquipmentInterface equipment) {
        this.unitOperations.add(equipment);
        equipment.setName(name);
        this.lastAddedUnit = equipment;
        equipment.run();
        return equipment;
    }

    public ProcessEquipmentInterface addUnit(ProcessEquipmentInterface equipment) {
        String generatedName = this.generateUniqueName(equipment.getClass().getSimpleName());
        return this.addUnit(generatedName, equipment);
    }

    private String generateUniqueName(String equipmentType) {
        int count = this.equipmentCounter.getOrDefault(equipmentType, 0) + 1;
        this.equipmentCounter.put(equipmentType, count);
        String formatted = equipmentType.substring(0, 1).toLowerCase() + equipmentType.substring(1);
        return formatted + "_" + count;
    }

    private void autoConnect(ProcessEquipmentInterface fromUnit, ProcessEquipmentInterface toUnit) {
        if (fromUnit == null) {
            return;
        }
        fromUnit.run();
        try {
            Method getOutlet = fromUnit.getClass().getMethod("getOutletStream", new Class[0]);
            Object outletStream = getOutlet.invoke((Object)fromUnit, new Object[0]);
            if (outletStream != null) {
                Method setInlet = toUnit.getClass().getMethod("setInletStream", StreamInterface.class);
                setInlet.invoke((Object)toUnit, outletStream);
            }
        }
        catch (NoSuchMethodException getOutlet) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportToGraphviz(String filename) {
        try (PrintWriter writer = new PrintWriter(filename);){
            writer.println("digraph process {");
            for (ProcessEquipmentInterface unit : this.getUnitOperations()) {
                boolean hasConnection = false;
                try {
                    Method getOutlet = unit.getClass().getMethod("getOutletStream", new Class[0]);
                    Object outlet = getOutlet.invoke((Object)unit, new Object[0]);
                    if (outlet != null) {
                        for (ProcessEquipmentInterface nextUnit : this.getUnitOperations()) {
                            try {
                                Method getInlet = nextUnit.getClass().getMethod("getInletStream", new Class[0]);
                                Object inlet = getInlet.invoke((Object)nextUnit, new Object[0]);
                                if (inlet == null || !inlet.equals(outlet)) continue;
                                writer.println("  \"" + unit.getName() + "\" -> \"" + nextUnit.getName() + "\";");
                                hasConnection = true;
                            }
                            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
                        }
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
                if (hasConnection) continue;
                writer.println("  \"" + unit.getName() + "\";");
            }
            writer.println("}");
        }
        catch (Exception e) {
            logger.error("Error exporting to Graphviz", (Throwable)e);
        }
    }

    public void loadProcessFromYaml(File yamlFile) {
        try {
            ProcessLoader.loadProcessFromYaml(yamlFile, this);
        }
        catch (Exception e) {
            logger.error("Error loading process from YAML file", (Throwable)e);
        }
    }
}

