/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel.processmodules;

import java.util.UUID;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.pump.Pump;
import neqsim.process.equipment.pump.PumpInterface;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.util.Recycle;
import neqsim.process.processmodel.ProcessModuleBaseClass;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class MixerGasProcessingModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    StreamInterface feedStream;
    StreamInterface gasExitStream;
    StreamInterface oilExitStream;
    StreamInterface glycolFeedStream;
    StreamInterface glycolExitStream;
    Separator glycolScrubber;
    Separator inletSeparator;
    double inletSepTemperature = 50.0;
    double gasScrubberTemperature = 30.0;
    double firstStageOutPressure = 110.0;
    double glycolScrubberTemperature = 20.0;
    double secondStageOutPressure = 200.0;
    double glycolInjectionRate = 10.0;
    double exportGasTemperature = 303.15;
    double liquidPumpPressure = 150.0;
    Compressor secondStageCompressor;
    Pump oilPump;
    Cooler secondStageAfterCooler;

    public MixerGasProcessingModule(String name) {
        super(name);
    }

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("feed stream")) {
            this.feedStream = stream;
        }
        if (streamName.equals("glycol feed stream")) {
            this.glycolFeedStream = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("gas exit stream")) {
            return this.gasExitStream;
        }
        if (streamName.equals("oil exit stream")) {
            return this.oilExitStream;
        }
        if (streamName.equals("glycol exit stream")) {
            return this.glycolExitStream;
        }
        if (streamName.equals("glycol feed stream")) {
            return this.glycolFeedStream;
        }
        return null;
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        Cooler inletCooler = new Cooler("inlet well stream cooler", this.feedStream);
        inletCooler.setOutTemperature(this.inletSepTemperature + 273.15);
        this.inletSeparator = new Separator("Inlet separator", inletCooler.getOutletStream());
        Cooler gasCooler = new Cooler("separator gas cooler", this.inletSeparator.getGasOutStream());
        gasCooler.setOutTemperature(this.gasScrubberTemperature + 273.15);
        this.oilPump = new Pump("liquid pump", this.inletSeparator.getLiquidOutStream());
        this.oilPump.setOutletPressure(this.liquidPumpPressure);
        Separator gasScrubber = new Separator("HC dew point control scrubber", gasCooler.getOutletStream());
        Recycle HPliquidRecycle = new Recycle("Recycle");
        double tolerance = 0.01;
        HPliquidRecycle.setTolerance(tolerance);
        HPliquidRecycle.addStream(gasScrubber.getLiquidOutStream());
        this.inletSeparator.addStream(HPliquidRecycle.getOutletStream());
        Compressor firstStageCompressor = new Compressor("1st stage compressor", gasScrubber.getGasOutStream());
        firstStageCompressor.setOutletPressure(this.firstStageOutPressure);
        this.glycolFeedStream.getThermoSystem().setPressure(this.firstStageOutPressure);
        Mixer glycolMixer = new Mixer("glycol injection mixer");
        glycolMixer.addStream(firstStageCompressor.getOutletStream());
        glycolMixer.addStream(this.glycolFeedStream);
        Cooler mixerAfterCooler = new Cooler("glycol mixer after cooler", glycolMixer.getOutletStream());
        mixerAfterCooler.setOutTemperature(this.glycolScrubberTemperature + 273.15);
        this.glycolScrubber = new Separator("Water dew point control scrubber", mixerAfterCooler.getOutletStream());
        this.secondStageCompressor = new Compressor("2nd stage compressor", this.glycolScrubber.getGasOutStream());
        this.secondStageCompressor.setOutletPressure(this.secondStageOutPressure);
        this.secondStageAfterCooler = new Cooler("second stage after cooler", this.secondStageCompressor.getOutletStream());
        this.secondStageAfterCooler.setOutTemperature(this.exportGasTemperature + 273.15);
        this.getOperations().add(inletCooler);
        this.getOperations().add(this.inletSeparator);
        this.getOperations().add(gasCooler);
        this.getOperations().add(this.oilPump);
        this.getOperations().add(gasScrubber);
        this.getOperations().add(HPliquidRecycle);
        this.getOperations().add(firstStageCompressor);
        this.getOperations().add(glycolMixer);
        this.getOperations().add(mixerAfterCooler);
        this.getOperations().add(this.glycolScrubber);
        this.getOperations().add(this.secondStageCompressor);
        this.getOperations().add(this.secondStageAfterCooler);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
    }

    @Override
    public void run(UUID id) {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.getOperations().run(id);
        this.gasExitStream = this.secondStageAfterCooler.getOutletStream();
        this.gasExitStream.setCalculationIdentifier(id);
        this.oilExitStream = this.oilPump.getOutletStream();
        this.oilExitStream.setCalculationIdentifier(id);
        this.glycolExitStream = this.glycolScrubber.getLiquidOutStream();
        this.glycolExitStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }

    @Override
    public void setSpecification(String specificationName, double value) {
        if (specificationName.equals("inlet separation temperature")) {
            this.inletSepTemperature = value;
        } else if (specificationName.equals("gas scrubber temperature")) {
            this.gasScrubberTemperature = value;
        } else if (specificationName.equals("first stage out pressure")) {
            this.firstStageOutPressure = value;
        } else if (specificationName.equals("glycol scrubber temperature")) {
            this.glycolScrubberTemperature = value;
        } else if (specificationName.equals("second stage out pressure")) {
            this.secondStageOutPressure = value;
        } else if (specificationName.equals("export gas temperature")) {
            this.exportGasTemperature = value;
        } else if (specificationName.equals("liquid pump out pressure")) {
            this.liquidPumpPressure = value;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(323.15, 65.0);
        testSystem.addComponent("methane", 50.0);
        testSystem.addComponent("propane", 0.15);
        testSystem.addComponent("nC10", 2.0);
        testSystem.addComponent("water", 5.0);
        testSystem.addComponent("TEG", 5.0E-9);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.setMultiPhaseCheck(true);
        SystemSrkCPAstatoil glycolTestSystem = new SystemSrkCPAstatoil(288.15, 50.0);
        glycolTestSystem.addComponent("methane", 0.0);
        glycolTestSystem.addComponent("propane", 0.0);
        glycolTestSystem.addComponent("nC10", 0.0);
        glycolTestSystem.addComponent("water", 1.0E-4);
        glycolTestSystem.addComponent("TEG", 0.8);
        glycolTestSystem.createDatabase(true);
        glycolTestSystem.setMixingRule(10);
        glycolTestSystem.setMultiPhaseCheck(true);
        glycolTestSystem.init(0);
        Stream wellStream = new Stream("Well stream", testSystem);
        wellStream.getThermoSystem().setTotalFlowRate(5.0, "MSm^3/day");
        Stream glycolFeedStream = new Stream("Glycol feed stream", glycolTestSystem);
        glycolFeedStream.getThermoSystem().setTotalFlowRate(4000.0, "kg/hr");
        MixerGasProcessingModule separationModule = new MixerGasProcessingModule("GasMixer");
        separationModule.addInputStream("feed stream", wellStream);
        separationModule.addInputStream("glycol feed stream", glycolFeedStream);
        separationModule.setSpecification("inlet separation temperature", 55.0);
        separationModule.setSpecification("gas scrubber temperature", 35.0);
        separationModule.setSpecification("glycol scrubber temperature", 25.0);
        separationModule.setSpecification("first stage out pressure", 110.0);
        separationModule.setSpecification("second stage out pressure", 200.0);
        separationModule.setSpecification("export gas temperature", 30.0);
        separationModule.setSpecification("liquid pump out pressure", 150.0);
        ProcessSystem operations = new ProcessSystem();
        operations.add(wellStream);
        operations.add(glycolFeedStream);
        operations.add(separationModule);
        operations.run();
        double en = ((PumpInterface)separationModule.getOperations().getUnit("liquid pump")).getPower();
    }
}

