/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.util.monitor.BaseResponse;

public class CompressorResponse
extends BaseResponse {
    public Double suctionTemperature;
    public Double dischargeTemperature;
    public Double suctionPressure;
    public Double dischargePressure;
    public Double polytropicHead;
    public Double polytropicEfficiency;
    public Double power;
    public Double suctionVolumeFlow;
    public Double internalVolumeFlow;
    public Double dischargeVolumeFlow;
    public Double molarMass;
    public Double suctionMassDensity;
    public Double dischargeMassDensity;
    public Double massflow;
    public Double stdFlow;
    public Double speed;

    public CompressorResponse() {
    }

    public CompressorResponse(Compressor inputCompressor) {
        super(inputCompressor);
        this.molarMass = inputCompressor.getInletStream().getFluid().getMolarMass();
        this.suctionMassDensity = inputCompressor.getInletStream().getFluid().getDensity("kg/m3");
        this.dischargeMassDensity = inputCompressor.getOutletStream().getFluid().getDensity("kg/m3");
        this.massflow = inputCompressor.getInletStream().getFluid().getFlowRate("kg/hr");
        this.stdFlow = inputCompressor.getInletStream().getFluid().getFlowRate("Sm3/hr");
        this.suctionVolumeFlow = inputCompressor.getInletStream().getFluid().getFlowRate("m3/hr");
        this.dischargeVolumeFlow = inputCompressor.getOutletStream().getFluid().getFlowRate("m3/hr");
        this.suctionPressure = inputCompressor.getInletStream().getPressure("bara");
        this.suctionTemperature = inputCompressor.getInletStream().getTemperature("C");
        this.dischargeTemperature = inputCompressor.getOutletStream().getTemperature("C");
        this.dischargePressure = inputCompressor.getOutletStream().getPressure("bara");
        this.polytropicHead = inputCompressor.getPolytropicFluidHead();
        this.polytropicEfficiency = inputCompressor.getPolytropicEfficiency();
        this.power = inputCompressor.getPower("kW");
        this.speed = inputCompressor.getSpeed();
        if (inputCompressor.getAntiSurge().isActive()) {
            this.internalVolumeFlow = inputCompressor.getCompressorChart().getSurgeCurve().getSurgeFlow(this.polytropicHead);
        }
    }
}

