/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import java.util.HashMap;
import neqsim.process.equipment.pump.Pump;
import neqsim.process.util.monitor.BaseResponse;
import neqsim.process.util.monitor.Value;
import neqsim.util.unit.Units;

public class PumpResponse
extends BaseResponse {
    public HashMap<String, Value> data = new HashMap();
    public Double suctionTemperature;
    public Double dischargeTemperature;
    public Double suctionPressure;
    public Double dischargePressure;
    public Double power;
    public Double duty;
    public Double suctionVolumeFlow;
    public Double internalVolumeFlow;
    public Double dischargeVolumeFlow;
    public Double molarMass;
    public Double suctionMassDensity;
    public Double dischargeMassDensity;
    public Double massflow;
    public Integer speed;

    public PumpResponse(Pump inputPump) {
        super(inputPump);
        this.molarMass = inputPump.getInletStream().getFluid().getMolarMass();
        this.suctionMassDensity = inputPump.getInletStream().getFluid().getDensity("kg/m3");
        this.dischargeMassDensity = inputPump.getOutletStream().getFluid().getDensity("kg/m3");
        this.massflow = inputPump.getInletStream().getFluid().getFlowRate("kg/hr");
        this.suctionVolumeFlow = inputPump.getInletStream().getFluid().getFlowRate("m3/hr");
        this.dischargeVolumeFlow = inputPump.getOutletStream().getFluid().getFlowRate("m3/hr");
        this.suctionPressure = inputPump.getInletStream().getPressure("bara");
        this.suctionTemperature = inputPump.getInletStream().getTemperature("C");
        this.dischargeTemperature = inputPump.getOutletStream().getTemperature("C");
        this.dischargePressure = inputPump.getOutletStream().getPressure("bara");
        this.duty = this.power = Double.valueOf(inputPump.getPower("W"));
        this.data.put("suction temperature", new Value(Double.toString(this.suctionTemperature), Units.getSymbol("temperature")));
        this.data.put("discharge temperature", new Value(Double.toString(this.dischargeTemperature), Units.getSymbol("temperature")));
        this.data.put("suction pressure", new Value(Double.toString(this.suctionPressure), Units.getSymbol("pressure")));
        this.data.put("discharge pressure", new Value(Double.toString(this.dischargePressure), Units.getSymbol("pressure")));
        this.data.put("mass flow", new Value(Double.toString(this.massflow), Units.getSymbol("mass flow")));
        this.data.put("duty", new Value(Double.toString(this.duty), Units.getSymbol("duty")));
        this.data.put("power", new Value(Double.toString(this.power), "W"));
    }
}

