/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.simulation;

import java.util.ArrayList;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.pvtsimulation.simulation.BasePVTsimulation;
import neqsim.pvtsimulation.util.parameterfitting.CVDFunction;
import neqsim.statistics.parameterfitting.SampleSet;
import neqsim.statistics.parameterfitting.SampleValue;
import neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConstantVolumeDepletion
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(ConstantVolumeDepletion.class);
    private double[] relativeVolume = null;
    double[] totalVolume = null;
    double[] liquidVolumeRelativeToVsat = null;
    double[] liquidVolume = null;
    boolean saturationConditionFound = false;
    private double[] liquidRelativeVolume = null;
    private double[] Zmix;
    private double[] Zgas = null;
    private double[] cummulativeMolePercDepleted = null;
    double[] temperatures = null;
    double[] pressure = null;

    public ConstantVolumeDepletion(SystemInterface tempSystem) {
        super(tempSystem);
    }

    public void setTemperaturesAndPressures(double[] temperature, double[] pressure) {
        this.pressure = pressure;
        this.temperatures = temperature;
        this.experimentalData = new double[temperature.length][1];
    }

    public void calcSaturationConditions() {
        this.getThermoSystem().setPressure(1.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
        } while (this.getThermoSystem().getNumberOfPhases() == 1 && this.getThermoSystem().getPressure() < 1000.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() > 1 && this.getThermoSystem().getPressure() < 1000.0);
        double minPres = this.getThermoSystem().getPressure() - 10.0;
        double maxPres = this.getThermoSystem().getPressure();
        do {
            this.getThermoSystem().setPressure((minPres + maxPres) / 2.0);
            this.thermoOps.TPflash();
            if (this.getThermoSystem().getNumberOfPhases() > 1) {
                minPres = this.getThermoSystem().getPressure();
                continue;
            }
            maxPres = this.getThermoSystem().getPressure();
        } while (Math.abs(maxPres - minPres) > 1.0E-5);
        this.getThermoSystem().initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
        this.saturationVolume = this.getThermoSystem().getCorrectedVolume();
        this.saturationPressure = this.getThermoSystem().getPressure();
        this.Zsaturation = this.getThermoSystem().getZvolcorr();
        this.saturationConditionFound = true;
    }

    public void runCalc() {
        int i;
        this.saturationConditionFound = false;
        this.relativeVolume = new double[this.pressures.length];
        this.totalVolume = new double[this.pressures.length];
        this.liquidVolumeRelativeToVsat = new double[this.pressures.length];
        this.liquidVolume = new double[this.pressures.length];
        this.Zgas = new double[this.pressures.length];
        this.Zmix = new double[this.pressures.length];
        this.liquidRelativeVolume = new double[this.pressures.length];
        double oldVolCorr = 0.0;
        double volumeCorrection = 0.0;
        this.cummulativeMolePercDepleted = new double[this.pressures.length];
        double totalNumberOfMoles = this.getThermoSystem().getTotalNumberOfMoles();
        if (!Double.isNaN(this.temperature)) {
            this.getThermoSystem().setTemperature(this.temperature, this.temperatureUnit);
        }
        for (i = 0; i < this.pressures.length; ++i) {
            int j;
            this.getThermoSystem().setPressure(this.pressures[i]);
            try {
                this.thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.getThermoSystem().initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            this.totalVolume[i] = this.getThermoSystem().getCorrectedVolume();
            this.cummulativeMolePercDepleted[i] = 100.0 - this.getThermoSystem().getTotalNumberOfMoles() / totalNumberOfMoles * 100.0;
            if (this.getThermoSystem().getNumberOfPhases() <= 1) continue;
            if (!this.saturationConditionFound) {
                this.calcSaturationConditions();
                this.getThermoSystem().setPressure(this.pressures[i]);
                try {
                    this.thermoOps.TPflash();
                    this.getThermoSystem().initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            this.liquidVolume[i] = this.getThermoSystem().getPhase(1).getCorrectedVolume();
            this.liquidVolumeRelativeToVsat[i] = this.liquidVolume[i] / this.saturationVolume;
            this.Zgas[i] = this.getThermoSystem().getPhase(0).getZvolcorr();
            this.Zmix[i] = this.getThermoSystem().getZvolcorr();
            this.liquidRelativeVolume[i] = this.getThermoSystem().getPhase("oil").getCorrectedVolume() / this.saturationVolume * 100.0;
            oldVolCorr = volumeCorrection;
            volumeCorrection = this.getThermoSystem().getCorrectedVolume() - this.saturationVolume;
            double test = (volumeCorrection - oldVolCorr) / this.getThermoSystem().getPhase(0).getCorrectedVolume();
            double[] change = new double[this.getThermoSystem().getPhase(0).getNumberOfComponents()];
            for (j = 0; j < this.getThermoSystem().getPhase(0).getNumberOfComponents(); ++j) {
                try {
                    change[j] = test * this.getThermoSystem().getPhase(0).getComponent(j).getx() < this.getThermoSystem().getPhase(0).getComponent(j).getNumberOfMolesInPhase() ? test * this.getThermoSystem().getPhase(0).getComponent(j).getx() : 0.0;
                    continue;
                }
                catch (Exception e) {
                    logger.debug(e.getMessage());
                }
            }
            this.getThermoSystem().init(0);
            for (j = 0; j < this.getThermoSystem().getPhase(0).getNumberOfComponents(); ++j) {
                try {
                    this.getThermoSystem().addComponent(j, -change[j]);
                    continue;
                }
                catch (Exception e) {
                    logger.debug(e.getMessage());
                }
            }
        }
        for (i = 0; i < this.pressures.length; ++i) {
            this.relativeVolume[i] = this.totalVolume[i] / this.saturationVolume;
        }
        try {
            this.thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void runTuning() {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            for (int i = 0; i < this.experimentalData[0].length; ++i) {
                CVDFunction function = new CVDFunction();
                double[] guess = new double[]{0.234};
                function.setInitialGuess(guess);
                SystemInterface tempSystem = this.getThermoSystem();
                tempSystem.setTemperature(this.temperature, this.temperatureUnit);
                tempSystem.setPressure(this.pressures[i]);
                double[] sample1 = new double[]{this.temperatures[i], this.pressures[i]};
                double relativeVolume = this.experimentalData[0][i];
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(relativeVolume, relativeVolume / 50.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        this.optimizer = new LevenbergMarquardt();
        this.optimizer.setMaxNumberOfIterations(20);
        this.optimizer.setSampleSet(sampleSet);
        this.optimizer.solve();
        this.runCalc();
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(298.0, 211.0);
        tempSystem.addComponent("nitrogen", 0.34);
        tempSystem.addComponent("CO2", 3.59);
        tempSystem.addComponent("methane", 67.42);
        tempSystem.addComponent("ethane", 9.02);
        tempSystem.addComponent("propane", 4.31);
        tempSystem.addComponent("i-butane", 0.93);
        tempSystem.addComponent("n-butane", 1.71);
        tempSystem.addComponent("i-pentane", 0.74);
        tempSystem.addComponent("n-pentane", 0.85);
        tempSystem.addComponent("n-hexane", 1.38);
        tempSystem.addTBPfraction("C7", 1.5, 0.109, 0.6912);
        tempSystem.addTBPfraction("C8", 1.69, 0.1202, 0.7255);
        tempSystem.addTBPfraction("C9", 1.14, 0.1295, 0.7454);
        tempSystem.addTBPfraction("C10", 0.8, 0.1353, 0.7864);
        tempSystem.addPlusFraction("C11", 4.58, 0.2562, 0.8398);
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        tempSystem.init(0);
        tempSystem.init(1);
        ConstantVolumeDepletion CVDsim = new ConstantVolumeDepletion(tempSystem);
        CVDsim.setTemperature(315.0, "K");
        CVDsim.setPressures(new double[]{400.0, 300.0, 200.0, 150.0, 100.0, 50.0});
        CVDsim.runCalc();
        CVDsim.setTemperaturesAndPressures(new double[]{313.0, 313.0, 313.0, 313.0}, new double[]{400.0, 300.0, 200.0, 100.0});
        double[][] expData = new double[][]{{0.95, 0.99, 1.0, 1.1}};
        CVDsim.setExperimentalData(expData);
    }

    public double[] getRelativeVolume() {
        return this.relativeVolume;
    }

    @Override
    public double getSaturationPressure() {
        return this.saturationPressure;
    }

    public double[] getZmix() {
        return this.Zmix;
    }

    public double[] getZgas() {
        return this.Zgas;
    }

    public double[] getLiquidRelativeVolume() {
        return this.liquidRelativeVolume;
    }

    public double[] getCummulativeMolePercDepleted() {
        return this.cummulativeMolePercDepleted;
    }
}

