/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.dataanalysis.datasmoothing;

import Jama.Matrix;

public class DataSmoother {
    double[] nonSmoothedNumbers;
    double[] smoothedNumbers;
    double[] cCoef;
    int nl = 0;
    int nr = 0;
    int ld = 0;
    int m = 0;
    int mm = 0;
    int imj = 0;
    int kk = 0;
    int[] index;
    double[][] a;
    double[] b;
    double sum = 0.0;
    double fac = 0.0;

    public DataSmoother(double[] nonSmoothedNumbers, int nl, int nr, int ld, int m) {
        this.nonSmoothedNumbers = new double[nonSmoothedNumbers.length];
        this.smoothedNumbers = new double[nonSmoothedNumbers.length];
        this.cCoef = new double[nonSmoothedNumbers.length];
        this.nonSmoothedNumbers = nonSmoothedNumbers;
        System.arraycopy(nonSmoothedNumbers, 0, this.smoothedNumbers, 0, nonSmoothedNumbers.length);
        this.nl = nl;
        this.nr = nr;
        this.ld = ld;
        this.m = m;
    }

    public void runSmoothing() {
        this.findCoefs();
        this.setSmoothedNumbers();
    }

    public void findCoefs() {
        if (this.nonSmoothedNumbers.length < this.nl + this.nr + 1 || this.nl < 0 || this.nr < 0 || this.ld > this.m || this.nl + this.nr < this.m) {
            System.err.println("Wrong input to DataSmoothor!");
        }
        this.index = new int[this.m + 1];
        this.a = new double[this.m + 1][this.m + 1];
        this.b = new double[this.m + 1];
        for (int i = 0; i < this.m + 1; ++i) {
            this.index[i] = 1;
            this.b[i] = 1.0;
            for (int j = 0; j < this.m + 1; ++j) {
                this.a[j][j] = 1.0;
            }
        }
        for (int ipj = 0; ipj <= this.m << 1; ++ipj) {
            int k;
            this.sum = ipj != 0 ? 0.0 : 1.0;
            for (k = 1; k <= this.nr; ++k) {
                this.sum += Math.pow(k, ipj);
            }
            for (k = 1; k <= this.nl; ++k) {
                this.sum += Math.pow(-k, ipj);
            }
            this.mm = Math.min(ipj, 2 * this.m - ipj);
            this.imj = -this.mm;
            while (this.imj <= this.mm) {
                this.a[(ipj + this.imj) / 2][(ipj - this.imj) / 2] = this.sum;
                this.imj += 2;
            }
        }
        for (int j = 0; j < this.m + 1; ++j) {
            this.b[j] = 0.0;
        }
        this.b[this.ld] = 1.0;
        Matrix amatrix = new Matrix(this.a);
        Matrix bmatrix = new Matrix(this.b, 1);
        bmatrix = amatrix.solve(bmatrix.transpose());
        this.b = bmatrix.transpose().getArray()[0];
        for (int kk = 0; kk < this.nonSmoothedNumbers.length; ++kk) {
            this.cCoef[kk] = 0.0;
        }
        for (int k = -this.nl; k <= this.nr; ++k) {
            this.sum = this.b[0];
            this.fac = 1.0;
            this.mm = 0;
            while (this.mm < this.m) {
                this.sum += this.b[this.mm + 1] * (this.fac *= (double)k);
                ++this.mm;
            }
            this.kk = (this.nonSmoothedNumbers.length - k) % this.nonSmoothedNumbers.length;
            this.cCoef[this.kk] = this.sum;
        }
    }

    public void setSmoothedNumbers() {
        for (int i = this.nl; i < this.nonSmoothedNumbers.length - this.nr; ++i) {
            int j;
            this.smoothedNumbers[i] = 0.0;
            this.smoothedNumbers[i] = this.cCoef[0] * this.nonSmoothedNumbers[i];
            for (j = 0; j < this.nl; ++j) {
                int n = i;
                this.smoothedNumbers[n] = this.smoothedNumbers[n] + this.cCoef[this.nonSmoothedNumbers.length - 1 - j] * this.nonSmoothedNumbers[i - j - 1];
            }
            for (j = 0; j < this.nr; ++j) {
                int n = i;
                this.smoothedNumbers[n] = this.smoothedNumbers[n] + this.cCoef[j + 1] * this.nonSmoothedNumbers[i + j - 1];
            }
        }
    }

    public double[] getSmoothedNumbers() {
        return this.smoothedNumbers;
    }
}

