/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import java.io.Serializable;
import neqsim.thermo.characterization.LumpingModel;
import neqsim.thermo.characterization.LumpingModelInterface;
import neqsim.thermo.characterization.PlusFractionModel;
import neqsim.thermo.characterization.PlusFractionModelInterface;
import neqsim.thermo.characterization.TBPCharacterize;
import neqsim.thermo.characterization.TBPModelInterface;
import neqsim.thermo.characterization.TBPfractionModel;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Characterise
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Characterise.class);
    SystemInterface system = null;
    TBPCharacterize TBPCharacterise = null;
    private TBPModelInterface TBPfractionModel = null;
    private PlusFractionModel plusFractionModelSelector = null;
    private PlusFractionModelInterface plusFractionModel = null;
    private LumpingModelInterface lumpingModel = null;
    protected String TBPFractionModelName = "PedersenSRK";
    protected LumpingModel lumpingModelSelector = null;
    protected TBPfractionModel TBPfractionModelSelector;

    public Characterise() {
    }

    public Characterise(SystemInterface system) {
        this.system = system;
        this.TBPCharacterise = new TBPCharacterize(system);
        this.TBPfractionModelSelector = new TBPfractionModel();
        this.TBPfractionModel = this.TBPfractionModelSelector.getModel("");
        this.lumpingModelSelector = new LumpingModel(system);
        this.lumpingModel = this.lumpingModelSelector.getModel("");
        this.plusFractionModelSelector = new PlusFractionModel(system);
        this.plusFractionModel = this.plusFractionModelSelector.getModel("");
    }

    public void setThermoSystem(SystemInterface system) {
        this.system = system;
    }

    public Characterise clone() {
        Characterise clonedSystem = null;
        try {
            clonedSystem = (Characterise)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    public TBPModelInterface getTBPModel() {
        return this.TBPfractionModel;
    }

    public void setTBPModel(String name) {
        this.TBPfractionModel = this.TBPfractionModelSelector.getModel(name);
    }

    public void setLumpingModel(String name) {
        this.lumpingModel = this.lumpingModelSelector.getModel(name);
    }

    public void setPlusFractionModel(String name) {
        this.plusFractionModel = this.plusFractionModelSelector.getModel(name);
    }

    public PlusFractionModelInterface getPlusFractionModel() {
        return this.plusFractionModel;
    }

    public LumpingModelInterface getLumpingModel() {
        return this.lumpingModel;
    }

    public void characterisePlusFraction() {
        this.system.init(0);
        if (this.plusFractionModel.hasPlusFraction()) {
            boolean couldCharacerize;
            if (this.plusFractionModel.getMPlus() > this.plusFractionModel.getMaxPlusMolarMass()) {
                logger.error("plus fraction molar mass too heavy for " + this.plusFractionModel.getName());
                this.plusFractionModel = this.plusFractionModelSelector.getModel("Pedersen Heavy Oil");
                logger.info("changing to " + this.plusFractionModel.getName());
            }
            if (couldCharacerize = this.plusFractionModel.characterizePlusFraction(this.TBPfractionModel)) {
                this.lumpingModel.generateLumpedComposition(this);
            }
        }
    }
}

