/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import java.io.Serializable;
import neqsim.thermo.characterization.Characterise;
import neqsim.thermo.characterization.LumpingModelInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.NotInitializedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LumpingModel
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(LumpingModel.class);
    int numberOfLumpedComponents = 7;
    int numberOfPseudocomponents = 7;
    private String[] lumpedComponentNames = null;
    double[] fractionOfHeavyEnd = null;
    String name = "";
    SystemInterface system = null;

    public LumpingModel(SystemInterface system) {
        this.system = system;
    }

    public LumpingModelInterface getModel(String modelName) {
        if (modelName.equals("PVTlumpingModel")) {
            return new PVTLumpingModel();
        }
        if (modelName.equals("no lumping")) {
            return new NoLumpingModel();
        }
        return new StandardLumpingModel();
    }

    public class NoLumpingModel
    extends StandardLumpingModel {
        private static final long serialVersionUID = 1000L;

        @Override
        public void generateLumpedComposition(Characterise charac) {
            LumpingModel.this.numberOfPseudocomponents = charac.getPlusFractionModel().getLastPlusFractionNumber();
            double weightFrac = 0.0;
            double weightTot = 0.0;
            double molFracTot = 0.0;
            int firstPlusFractionNumber = LumpingModel.this.system.getCharacterization().getPlusFractionModel().getFirstPlusFractionNumber();
            int compNumberOfFirstComponentInPlusFraction = LumpingModel.this.system.getCharacterization().getPlusFractionModel().getPlusComponentNumber();
            int numberOfDefinedTBPcomponents = 0;
            for (int compNumb = 0; compNumb < firstPlusFractionNumber; ++compNumb) {
                if (!LumpingModel.this.system.getPhase(0).hasComponent("C" + Integer.toString(compNumb) + "_PC")) continue;
                ++numberOfDefinedTBPcomponents;
            }
            if (LumpingModel.this.numberOfPseudocomponents - numberOfDefinedTBPcomponents <= LumpingModel.this.numberOfLumpedComponents) {
                LumpingModel.this.numberOfPseudocomponents = numberOfDefinedTBPcomponents + LumpingModel.this.numberOfLumpedComponents;
            }
            LumpingModel.this.numberOfLumpedComponents = LumpingModel.this.numberOfPseudocomponents - numberOfDefinedTBPcomponents;
            LumpingModel.this.lumpedComponentNames = new String[LumpingModel.this.numberOfLumpedComponents];
            LumpingModel.this.fractionOfHeavyEnd = new double[LumpingModel.this.numberOfLumpedComponents];
            double[] zPlus = new double[LumpingModel.this.numberOfLumpedComponents];
            for (int i = 0; i < LumpingModel.this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (!LumpingModel.this.system.getPhase(0).getComponent(i).isIsTBPfraction() && !LumpingModel.this.system.getPhase(0).getComponent(i).isIsPlusFraction() || i < compNumberOfFirstComponentInPlusFraction) continue;
                weightTot += LumpingModel.this.system.getPhase(0).getComponent(i).getz() * LumpingModel.this.system.getPhase(0).getComponent(i).getMolarMass();
                molFracTot += LumpingModel.this.system.getPhase(0).getComponent(i).getz();
            }
            double meanWeightFrac = weightTot / ((double)LumpingModel.this.numberOfLumpedComponents + 1.0E-10);
            int k = 0;
            double Maverage = 0.0;
            double denstemp1 = 0.0;
            double denstemp2 = 0.0;
            double totalNumberOfMoles = LumpingModel.this.system.getNumberOfMoles();
            int i = 0;
            int pseudoNumber = 1;
            double accumulatedWeigthFrac = 0.0;
            int starti = charac.getPlusFractionModel().getFirstPlusFractionNumber();
            i = charac.getPlusFractionModel().getFirstPlusFractionNumber();
            while (i < charac.getPlusFractionModel().getLastPlusFractionNumber()) {
                Maverage = charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                weightFrac = charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                accumulatedWeigthFrac = charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                zPlus[k] = charac.getPlusFractionModel().getZ()[i];
                denstemp1 = charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                denstemp2 = charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i] / charac.getPlusFractionModel().getDens()[i];
                ++pseudoNumber;
                String addName = "C" + Integer.toString(starti) + "-" + Integer.toString(i);
                this.getLumpedComponentNames()[k] = addName;
                LumpingModel.this.fractionOfHeavyEnd[k] = zPlus[k] / molFracTot;
                LumpingModel.this.system.addTBPfraction(addName, totalNumberOfMoles * zPlus[k], Maverage / zPlus[k], denstemp1 / denstemp2);
                ++k;
                starti = i++;
            }
            if (charac.getPlusFractionModel().hasPlusFraction()) {
                LumpingModel.this.system.removeComponent(LumpingModel.this.system.getPhase(0).getComponent(charac.getPlusFractionModel().getPlusComponentNumber()).getName());
            }
            LumpingModel.this.system.init(0);
        }

        @Override
        public double getFractionOfHeavyEnd(int i) {
            if (LumpingModel.this.fractionOfHeavyEnd == null) {
                throw new RuntimeException(new NotInitializedException(this, "getFractionOfHeavyEnd", "fractionOfHeavyEnd", "characterisePlusFraction or generateLumpedComposition"));
            }
            return LumpingModel.this.fractionOfHeavyEnd[i];
        }
    }

    public class PVTLumpingModel
    extends StandardLumpingModel {
        private static final long serialVersionUID = 1000L;

        @Override
        public void generateLumpedComposition(Characterise charac) {
            double weightFrac = 0.0;
            double weightTot = 0.0;
            double molFracTot = 0.0;
            int firstPlusFractionNumber = LumpingModel.this.system.getCharacterization().getPlusFractionModel().getFirstPlusFractionNumber();
            int compNumberOfFirstComponentInPlusFraction = LumpingModel.this.system.getCharacterization().getPlusFractionModel().getPlusComponentNumber();
            int numberOfDefinedTBPcomponents = 0;
            for (int compNumb = 0; compNumb < firstPlusFractionNumber; ++compNumb) {
                if (!LumpingModel.this.system.getPhase(0).hasComponent("C" + Integer.toString(compNumb) + "_PC")) continue;
                ++numberOfDefinedTBPcomponents;
            }
            if (LumpingModel.this.numberOfPseudocomponents - numberOfDefinedTBPcomponents <= LumpingModel.this.numberOfLumpedComponents) {
                LumpingModel.this.numberOfPseudocomponents = numberOfDefinedTBPcomponents + LumpingModel.this.numberOfLumpedComponents;
            }
            LumpingModel.this.numberOfLumpedComponents = LumpingModel.this.numberOfPseudocomponents - numberOfDefinedTBPcomponents;
            LumpingModel.this.lumpedComponentNames = new String[LumpingModel.this.numberOfLumpedComponents];
            LumpingModel.this.fractionOfHeavyEnd = new double[LumpingModel.this.numberOfLumpedComponents];
            double[] zPlus = new double[LumpingModel.this.numberOfLumpedComponents];
            for (int i = 0; i < LumpingModel.this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (!LumpingModel.this.system.getPhase(0).getComponent(i).isIsTBPfraction() && !LumpingModel.this.system.getPhase(0).getComponent(i).isIsPlusFraction() || i < compNumberOfFirstComponentInPlusFraction) continue;
                weightTot += LumpingModel.this.system.getPhase(0).getComponent(i).getz() * LumpingModel.this.system.getPhase(0).getComponent(i).getMolarMass();
                molFracTot += LumpingModel.this.system.getPhase(0).getComponent(i).getz();
            }
            double meanWeightFrac = weightTot / ((double)LumpingModel.this.numberOfLumpedComponents + 1.0E-10);
            int k = 0;
            double Maverage = 0.0;
            double denstemp1 = 0.0;
            double denstemp2 = 0.0;
            double totalNumberOfMoles = LumpingModel.this.system.getNumberOfMoles();
            int i = 0;
            int pseudoNumber = 1;
            double accumulatedWeigthFrac = 0.0;
            int starti = charac.getPlusFractionModel().getFirstPlusFractionNumber();
            for (i = charac.getPlusFractionModel().getFirstPlusFractionNumber(); i < charac.getPlusFractionModel().getLastPlusFractionNumber(); ++i) {
                Maverage += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                weightFrac += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                accumulatedWeigthFrac += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                int n = k;
                zPlus[n] = zPlus[n] + charac.getPlusFractionModel().getZ()[i];
                denstemp1 += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                denstemp2 += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i] / charac.getPlusFractionModel().getDens()[i];
                if (!(weightFrac >= meanWeightFrac && LumpingModel.this.numberOfLumpedComponents - pseudoNumber != 0) && i != charac.getPlusFractionModel().getLastPlusFractionNumber() - 1) continue;
                meanWeightFrac = (weightTot - accumulatedWeigthFrac) / (double)(LumpingModel.this.numberOfLumpedComponents - pseudoNumber);
                ++pseudoNumber;
                String addName = "C" + Integer.toString(starti) + "-" + Integer.toString(i);
                this.getLumpedComponentNames()[k] = addName;
                LumpingModel.this.fractionOfHeavyEnd[k] = zPlus[k] / molFracTot;
                LumpingModel.this.system.addTBPfraction(addName, totalNumberOfMoles * zPlus[k], Maverage / zPlus[k], denstemp1 / denstemp2);
                denstemp1 = 0.0;
                denstemp2 = 0.0;
                weightFrac = 0.0;
                Maverage = 0.0;
                ++k;
                starti = i + 1;
            }
            if (charac.getPlusFractionModel().hasPlusFraction()) {
                LumpingModel.this.system.removeComponent(LumpingModel.this.system.getPhase(0).getComponent(charac.getPlusFractionModel().getPlusComponentNumber()).getName());
            }
            LumpingModel.this.system.init(0);
        }

        @Override
        public double getFractionOfHeavyEnd(int i) {
            if (LumpingModel.this.fractionOfHeavyEnd == null) {
                throw new RuntimeException(new NotInitializedException(this, "getFractionOfHeavyEnd", "fractionOfHeavyEnd", "characterisePlusFraction or generateLumpedComposition"));
            }
            return LumpingModel.this.fractionOfHeavyEnd[i];
        }
    }

    public class StandardLumpingModel
    implements LumpingModelInterface,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1000L;

        @Override
        public void setNumberOfLumpedComponents(int lumpedNumb) {
            LumpingModel.this.numberOfLumpedComponents = lumpedNumb;
        }

        @Override
        public int getNumberOfLumpedComponents() {
            return LumpingModel.this.numberOfLumpedComponents;
        }

        @Override
        public void setNumberOfPseudoComponents(int lumpedNumb) {
            LumpingModel.this.numberOfPseudocomponents = lumpedNumb;
        }

        @Override
        public int getNumberOfPseudoComponents() {
            return LumpingModel.this.numberOfPseudocomponents;
        }

        @Override
        public String getName() {
            return LumpingModel.this.name;
        }

        @Override
        public String getLumpedComponentName(int i) {
            return LumpingModel.this.lumpedComponentNames[i];
        }

        @Override
        public String[] getLumpedComponentNames() {
            return LumpingModel.this.lumpedComponentNames;
        }

        @Override
        public void generateLumpedComposition(Characterise charac) {
            LumpingModel.this.numberOfLumpedComponents = LumpingModel.this.numberOfPseudocomponents;
            LumpingModel.this.lumpedComponentNames = new String[LumpingModel.this.numberOfLumpedComponents];
            LumpingModel.this.fractionOfHeavyEnd = new double[LumpingModel.this.numberOfPseudocomponents];
            double[] zPlus = new double[LumpingModel.this.numberOfPseudocomponents];
            double weightFrac = 0.0;
            double weightTot = 0.0;
            double molFracTot = 0.0;
            for (int i = 0; i < LumpingModel.this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (!LumpingModel.this.system.getPhase(0).getComponent(i).isIsTBPfraction() && !LumpingModel.this.system.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
                weightTot += LumpingModel.this.system.getPhase(0).getComponent(i).getz() * LumpingModel.this.system.getPhase(0).getComponent(i).getMolarMass();
                molFracTot += LumpingModel.this.system.getPhase(0).getComponent(i).getz();
            }
            double meanWeightFrac = weightTot / ((double)LumpingModel.this.numberOfPseudocomponents + 1.0E-10);
            int k = 0;
            double Maverage = 0.0;
            double denstemp1 = 0.0;
            double denstemp2 = 0.0;
            double totalNumberOfMoles = LumpingModel.this.system.getNumberOfMoles();
            int i = 0;
            int added = 0;
            if (charac.getPlusFractionModel().hasPlusFraction()) {
                ++added;
            }
            int pseudoNumber = 1;
            double accumulatedWeigthFrac = 0.0;
            for (int ii = 0; ii < LumpingModel.this.system.getPhase(0).getNumberOfComponents() - added; ++ii) {
                String name = LumpingModel.this.system.getPhase(0).getComponent(ii).getComponentName();
                if (LumpingModel.this.system.getPhase(0).getComponent(name).isIsTBPfraction() || LumpingModel.this.system.getPhase(0).getComponent(name).isIsPlusFraction()) {
                    Maverage += LumpingModel.this.system.getPhase(0).getComponent(name).getz() * LumpingModel.this.system.getPhase(0).getComponent(name).getMolarMass();
                    weightFrac += LumpingModel.this.system.getPhase(0).getComponent(name).getz() * LumpingModel.this.system.getPhase(0).getComponent(name).getMolarMass();
                    int n = k;
                    zPlus[n] = zPlus[n] + LumpingModel.this.system.getPhase(0).getComponent(name).getz();
                    denstemp1 += LumpingModel.this.system.getPhase(0).getComponent(name).getz() * LumpingModel.this.system.getPhase(0).getComponent(name).getMolarMass();
                    denstemp2 += LumpingModel.this.system.getPhase(0).getComponent(name).getz() * LumpingModel.this.system.getPhase(0).getComponent(name).getMolarMass() / LumpingModel.this.system.getPhase(0).getComponent(name).getNormalLiquidDensity();
                    LumpingModel.this.system.removeComponent(name);
                    --ii;
                }
                if (!(weightFrac >= meanWeightFrac)) continue;
                meanWeightFrac = (weightTot - (accumulatedWeigthFrac += weightFrac)) / (double)(LumpingModel.this.numberOfPseudocomponents - pseudoNumber);
                String addName = "PC" + Integer.toString(pseudoNumber++);
                LumpingModel.this.fractionOfHeavyEnd[k] = zPlus[k] / molFracTot;
                LumpingModel.this.lumpedComponentNames[pseudoNumber - 2] = addName;
                LumpingModel.this.system.addTBPfraction(addName, totalNumberOfMoles * zPlus[k], Maverage / zPlus[k], denstemp1 / denstemp2);
                denstemp1 = 0.0;
                denstemp2 = 0.0;
                weightFrac = 0.0;
                Maverage = 0.0;
                ++k;
                ++added;
            }
            for (i = charac.getPlusFractionModel().getFirstPlusFractionNumber(); i < charac.getPlusFractionModel().getLastPlusFractionNumber(); ++i) {
                Maverage += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                weightFrac += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                accumulatedWeigthFrac += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                int n = k;
                zPlus[n] = zPlus[n] + charac.getPlusFractionModel().getZ()[i];
                denstemp1 += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i];
                denstemp2 += charac.getPlusFractionModel().getZ()[i] * charac.getPlusFractionModel().getM()[i] / charac.getPlusFractionModel().getDens()[i];
                if (!(weightFrac >= meanWeightFrac && LumpingModel.this.numberOfPseudocomponents - pseudoNumber != 0) && i != charac.getPlusFractionModel().getLastPlusFractionNumber() - 1) continue;
                meanWeightFrac = (weightTot - accumulatedWeigthFrac) / (double)(LumpingModel.this.numberOfPseudocomponents - pseudoNumber);
                String addName = "PC" + Integer.toString(pseudoNumber++);
                LumpingModel.this.lumpedComponentNames[pseudoNumber - 2] = addName;
                LumpingModel.this.fractionOfHeavyEnd[k] = zPlus[k] / molFracTot;
                LumpingModel.this.system.addTBPfraction(addName, totalNumberOfMoles * zPlus[k], Maverage / zPlus[k], denstemp1 / denstemp2);
                denstemp1 = 0.0;
                denstemp2 = 0.0;
                weightFrac = 0.0;
                Maverage = 0.0;
                ++k;
            }
            if (charac.getPlusFractionModel().hasPlusFraction()) {
                LumpingModel.this.system.removeComponent(LumpingModel.this.system.getPhase(0).getComponent(charac.getPlusFractionModel().getPlusComponentNumber()).getName());
            }
        }

        @Override
        public double getFractionOfHeavyEnd(int i) {
            if (LumpingModel.this.fractionOfHeavyEnd == null) {
                throw new RuntimeException(new NotInitializedException(this, "getFractionOfHeavyEnd", "fractionOfHeavyEnd", "characterisePlusFraction or generateLumpedComposition"));
            }
            return LumpingModel.this.fractionOfHeavyEnd[i];
        }
    }
}

