/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentGE;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentGEUniquac
extends ComponentGE {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentGEUniquac.class);
    double r = 0.0;
    double q = 0.0;

    public ComponentGEUniquac(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
        if (!this.getClass().equals(ComponentGEUniquac.class)) {
            return;
        }
        if (name.contains("_PC")) {
            this.r = 1.0;
            this.q = 1.0;
            return;
        }
        try (NeqSimDataBase database = new NeqSimDataBase();){
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + name + "'");
                dataSet.next();
                dataSet.getClob("name");
            }
            catch (Exception ex) {
                dataSet.close();
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + name + "'");
                dataSet.next();
            }
            this.r = Double.parseDouble(dataSet.getString("rUNIQUAQ"));
            this.q = Double.parseDouble(dataSet.getString("qUNIQUAQ"));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public double fugcoef(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.fugacityCoefficient = this.getGamma(phase, numberOfComponents, temperature, pressure, pt) * this.getAntoineVaporPressure(temperature) / pressure;
        return this.fugacityCoefficient;
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt, double[][] HValpha, double[][] HVgij, double[][] intparam, String[][] mixRule) {
        return 0.0;
    }

    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        return this.gamma;
    }

    public double fugcoefDiffPres(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.dfugdp = (Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure + 0.01, pt)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure - 0.01, pt))) / 0.02;
        return this.dfugdp;
    }

    public double fugcoefDiffTemp(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.dfugdt = (Math.log(this.fugcoef(phase, numberOfComponents, temperature + 0.01, pressure, pt)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature - 0.01, pressure, pt))) / 0.02;
        return this.dfugdt;
    }

    public double getr() {
        return this.r;
    }

    public double getq() {
        return this.q;
    }

    @Override
    public double getlnGammadt() {
        return this.dlngammadt;
    }

    @Override
    public double getlnGammadn(int k) {
        return this.dlngammadn[k];
    }
}

