/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentSolid;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentWax
extends ComponentSolid {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentWax.class);

    public ComponentWax(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
    }

    @Override
    public double fugcoef(PhaseInterface phase1) {
        if (!this.isWaxFormer()) {
            this.fugacityCoefficient = 1.0E50;
            return this.fugacityCoefficient;
        }
        return this.fugcoef2(phase1);
    }

    @Override
    public double fugcoef2(PhaseInterface phase1) {
        try {
            this.refPhase.setTemperature(phase1.getTemperature());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.refPhase.setPressure(phase1.getPressure());
        this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 1, PhaseType.LIQUID, 1.0);
        this.refPhase.getComponent(0).fugcoef(this.refPhase);
        double liquidPhaseFugacity = this.refPhase.getComponent(0).getFugacityCoefficient() * this.refPhase.getPressure();
        double liquidDenisty = this.refPhase.getMolarVolume();
        double solidDensity = liquidDenisty * 0.9;
        double refPressure = 1.0;
        double presTerm = -(liquidDenisty - solidDensity) * (phase1.getPressure() - refPressure) / 8.3144621 / phase1.getTemperature();
        this.SolidFug = this.getx() * liquidPhaseFugacity * Math.exp(-this.getHeatOfFusion() / (8.3144621 * phase1.getTemperature()) * (1.0 - phase1.getTemperature() / this.getTriplePointTemperature()) + presTerm);
        this.fugacityCoefficient = this.SolidFug / (phase1.getPressure() * this.getx());
        return this.fugacityCoefficient;
    }
}

