/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.mathlib.nonlinearsolver.NewtonRhapson;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermPr;

public class AttractiveTermPr1978
extends AttractiveTermPr {
    private static final long serialVersionUID = 1000L;

    public AttractiveTermPr1978(ComponentEosInterface component) {
        super(component);
        this.m = component.getAcentricFactor() > 0.49 ? 0.379642 + 1.48503 * component.getAcentricFactor() - 0.164423 * component.getAcentricFactor() * component.getAcentricFactor() + 0.01666 * Math.pow(component.getAcentricFactor(), 3.0) : 0.37464 + 1.54226 * component.getAcentricFactor() - 0.26992 * component.getAcentricFactor() * component.getAcentricFactor();
    }

    @Override
    public void setm(double val) {
        this.m = val;
        NewtonRhapson solve = new NewtonRhapson();
        solve.setOrder(2);
        double[] acentricConstants = new double[]{-0.26992, 1.54226, 0.37464 - this.m};
        if (this.m > 0.49) {
            solve.setOrder(3);
            acentricConstants = new double[]{0.01666, -0.164423, 1.48503, 0.379642 - this.m};
        }
        solve.setConstants(acentricConstants);
        this.getComponent().setAcentricFactor(solve.solve(0.2));
    }

    @Override
    public AttractiveTermPr1978 clone() {
        AttractiveTermPr1978 attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermPr1978)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
        this.m = this.getComponent().getAcentricFactor() > 0.49 ? 0.379642 + 1.48503 * this.getComponent().getAcentricFactor() - 0.164423 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor() + 0.01666 * Math.pow(this.getComponent().getAcentricFactor(), 3.0) : 0.37464 + 1.54226 * this.getComponent().getAcentricFactor() - 0.26992 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor();
    }
}

