/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermPr1978;

public class AttractiveTermPrDanesh
extends AttractiveTermPr1978 {
    private static final long serialVersionUID = 1000L;
    double mMod = 0.0;

    public AttractiveTermPrDanesh(ComponentEosInterface component) {
        super(component);
    }

    @Override
    public AttractiveTermPrDanesh clone() {
        AttractiveTermPrDanesh attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermPrDanesh)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
        this.m = 0.37464 + 1.54226 * this.getComponent().getAcentricFactor() - 0.26992 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor();
    }

    @Override
    public double alpha(double temperature) {
        this.mMod = temperature > this.getComponent().getTC() ? this.m * 1.21 : this.m;
        return Math.pow(1.0 + this.mMod * (1.0 - Math.sqrt(temperature / this.getComponent().getTC())), 2.0);
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        this.mMod = temperature > this.getComponent().getTC() ? this.m * 1.21 : this.m;
        return -(1.0 + this.mMod * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.mMod / Math.sqrt(temperature / this.getComponent().getTC()) / this.getComponent().getTC();
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        this.mMod = temperature > this.getComponent().getTC() ? this.m * 1.21 : this.m;
        return this.mMod * this.mMod / temperature / this.getComponent().getTC() / 2.0 + (1.0 + this.mMod * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.m / Math.sqrt(temperature * temperature * temperature / Math.pow(this.getComponent().getTC(), 3.0)) / (this.getComponent().getTC() * this.getComponent().getTC()) / 2.0;
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

