/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermBaseClass;

public class AttractiveTermTwuCoonStatoil
extends AttractiveTermBaseClass {
    private static final long serialVersionUID = 1000L;
    private double a = this.parameters[0];
    private double b = this.parameters[1];
    private double c = this.parameters[2];

    public AttractiveTermTwuCoonStatoil(ComponentEosInterface component) {
        super(component);
    }

    public AttractiveTermTwuCoonStatoil(ComponentEosInterface component, double[] params) {
        this(component);
        System.arraycopy(params, 0, this.parameters, 0, params.length);
    }

    @Override
    public AttractiveTermTwuCoonStatoil clone() {
        AttractiveTermTwuCoonStatoil attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermTwuCoonStatoil)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
    }

    @Override
    public double alpha(double temperature) {
        this.a = this.parameters[0];
        this.b = this.parameters[1];
        this.c = this.parameters[2];
        double t = temperature;
        double TC = this.getComponent().getTC();
        double Tr = t / TC;
        return Math.pow(Tr, this.c * (this.b - 1.0)) * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c)));
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        this.a = this.parameters[0];
        this.b = this.parameters[1];
        this.c = this.parameters[2];
        double t = temperature;
        double TC = this.getComponent().getTC();
        double Tr = t / TC;
        return Math.pow(Tr, this.c * (this.b - 1.0)) * this.c * (this.b - 1.0) / t * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c))) - Math.pow(Tr, this.c * (this.b - 1.0)) * this.a * Math.pow(Tr, this.b * this.c) * this.b * this.c / t * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c)));
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        this.a = this.parameters[0];
        this.b = this.parameters[1];
        this.c = this.parameters[2];
        double t = temperature;
        double TC = this.getComponent().getTC();
        double Tr = t / TC;
        return Math.pow(Tr, this.c * (this.b - 1.0)) * (this.c * this.c) * (this.b - 1.0) * (this.b - 1.0) / (t * t) * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c))) - Math.pow(Tr, this.c * (this.b - 1.0)) * this.c * (this.b - 1.0) / (t * t) * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c))) - 2.0 * Math.pow(Tr, this.c * (this.b - 1.0)) * (this.c * this.c) * (this.b - 1.0) / (t * t) * this.a * Math.pow(Tr, this.b * this.c) * this.b * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c))) - Math.pow(Tr, this.c * (this.b - 1.0)) * this.a * Math.pow(Tr, this.b * this.c) * (this.b * this.b) * (this.c * this.c) / (t * t) * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c))) + Math.pow(Tr, this.c * (this.b - 1.0)) * this.a * Math.pow(Tr, this.b * this.c) * this.b * this.c / (t * t) * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c))) + Math.pow(Tr, this.c * (this.b - 1.0)) * (this.a * this.a) * Math.pow(Tr, 2.0 * this.b * this.c) * (this.b * this.b) * (this.c * this.c) / (t * t) * Math.exp(this.a * (1.0 - Math.pow(Tr, this.b * this.c)));
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

