/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentSoreideWhitson;
import neqsim.thermo.phase.PhasePrEos;

public class PhaseSoreideWhitson
extends PhasePrEos {
    private static final long serialVersionUID = 1L;
    private double salinityConcentration = 0.0;
    private double salinity = 0.0;

    public PhaseSoreideWhitson() {
        this.thermoPropertyModelName = "Soreide-Whitson-PR-EoS";
    }

    @Override
    public PhaseSoreideWhitson clone() {
        PhaseSoreideWhitson clonedPhase = null;
        try {
            clonedPhase = (PhaseSoreideWhitson)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        this.componentArray[compNumber] = new ComponentSoreideWhitson(name, moles, molesInPhase, compNumber);
    }

    public void setSalinityConcentration(double salinityConcentration) {
        this.salinityConcentration = salinityConcentration;
    }

    public double getSalinityConcentration() {
        return this.salinityConcentration;
    }

    public void addSalinity(double salinity) {
        this.salinity += salinity;
    }

    public double getSalinity(double salinity) {
        return this.salinity;
    }
}

