/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.InvalidInputException;

public enum StateOfMatter {
    GAS,
    LIQUID,
    SOLID;


    public static StateOfMatter fromPhaseType(PhaseType pt) {
        switch (pt) {
            case GAS: {
                return GAS;
            }
            case LIQUID: 
            case OIL: 
            case AQUEOUS: {
                return LIQUID;
            }
            case SOLID: 
            case SOLIDCOMPLEX: 
            case WAX: 
            case HYDRATE: {
                return SOLID;
            }
        }
        new RuntimeException(new InvalidInputException(StateOfMatter.class, "fromPhaseType", "pt", "Conversion not configured for"));
        return null;
    }

    public static boolean isGas(PhaseType pt) {
        return StateOfMatter.fromPhaseType(pt) == GAS;
    }

    public static boolean isLiquid(PhaseType pt) {
        return StateOfMatter.fromPhaseType(pt) == LIQUID;
    }

    public static boolean isSolid(PhaseType pt) {
        return StateOfMatter.fromPhaseType(pt) == SOLID;
    }
}

