/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseVegaEos;
import neqsim.thermo.system.SystemEos;

public class SystemVegaEos
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemVegaEos() {
        this(298.15, 1.0, false);
    }

    public SystemVegaEos(double T, double P) {
        this(T, P, false);
    }

    public SystemVegaEos(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.modelName = "Vega-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseVegaEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.setNumberOfPhases(5);
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        this.useVolumeCorrection(false);
        this.commonInitialization();
    }

    @Override
    public SystemVegaEos clone() {
        SystemVegaEos clonedSystem = null;
        try {
            clonedSystem = (SystemVegaEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    public void commonInitialization() {
        this.setImplementedCompositionDeriativesofFugacity(false);
        this.setImplementedPressureDeriativesofFugacity(false);
        this.setImplementedTemperatureDeriativesofFugacity(false);
    }
}

