/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.jfree.chart.JFreeChart;

public class PHflashVega
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Hspec = 0.0;
    Flash tpFlash;
    double enthalpy_Vega = 0.0;
    double cP_Vega = 0.0;

    public PHflashVega(SystemInterface system, double Hspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Hspec = Hspec;
    }

    public double calcdQdTT() {
        double dQdTT = -this.system.getTemperature() * this.system.getTemperature() * this.cP_Vega;
        return dQdTT / Math.abs(this.Hspec);
    }

    public double calcdQdT() {
        double dQ = (this.enthalpy_Vega - this.Hspec) / Math.abs(this.Hspec);
        return dQ;
    }

    public double solveQ() {
        double oldTemp = 1.0 / this.system.getTemperature();
        double nyTemp = 1.0 / this.system.getTemperature();
        double iterations = 1.0;
        double error = 1.0;
        double errorOld = 1.0E10;
        double factor = 0.8;
        double newCorr = 1.0;
        this.system.init(2);
        boolean correctFactor = true;
        double maxTemperature = 1.0E10;
        double minTemperature = 0.0;
        do {
            if (Math.abs(error) > Math.abs(errorOld) && factor > 0.1 && correctFactor) {
                factor *= 0.5;
            } else if (Math.abs(error) < Math.abs(errorOld) && correctFactor) {
                factor = iterations / (iterations + 1.0) * 1.0;
            }
            iterations += 1.0;
            oldTemp = nyTemp;
            double[] VegaProps = this.system.getPhase(0).getProperties_Vega();
            this.cP_Vega = VegaProps[10] * this.system.getPhase(0).getNumberOfMolesInPhase();
            this.enthalpy_Vega = VegaProps[7] * this.system.getPhase(0).getNumberOfMolesInPhase();
            newCorr = factor * this.calcdQdT() / this.calcdQdTT();
            nyTemp = oldTemp - newCorr;
            if (Math.abs(this.system.getTemperature() - 1.0 / nyTemp) > 10.0) {
                nyTemp = 1.0 / (this.system.getTemperature() - Math.signum(this.system.getTemperature() - 1.0 / nyTemp) * 10.0);
                correctFactor = false;
            } else if (nyTemp < 0.0) {
                nyTemp = Math.abs(1.0 / (this.system.getTemperature() + 10.0));
                correctFactor = false;
            } else if (Double.isNaN(nyTemp)) {
                nyTemp = oldTemp + 0.1;
                correctFactor = false;
            } else {
                correctFactor = true;
            }
            this.system.setTemperature(1.0 / nyTemp);
            if (this.system.getTemperature() > maxTemperature) {
                this.system.setTemperature(maxTemperature - 0.1);
            } else if (this.system.getTemperature() < minTemperature) {
                this.system.setTemperature(minTemperature + 0.1);
            }
            errorOld = error;
            error = this.calcdQdT();
            if (error > 0.0 && this.system.getTemperature() > maxTemperature) {
                maxTemperature = this.system.getTemperature();
                continue;
            }
            if (!(error < 0.0) || !(this.system.getTemperature() < minTemperature)) continue;
            minTemperature = this.system.getTemperature();
        } while ((Math.abs(error) + Math.abs(errorOld) > 1.0E-8 || iterations < 3.0) && iterations < 200.0);
        return 1.0 / nyTemp;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        if (this.system.getNumberOfPhases() > 1) {
            logger.error("PHflashVega only supports single-phase gas calculations");
            return;
        }
        this.solveQ();
        this.system.init(3);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

